/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionUtils {
    @NonNls
    private static final Set<String> s_collectionClassesRequiringCapacity = new HashSet<String>();
    @NonNls
    private static final Set<String> s_allCollectionClasses = new HashSet<String>();
    @NonNls
    private static final Set<String> s_allCollectionClassesAndInterfaces = new HashSet<String>();
    @NonNls
    private static final Map<String, String> s_interfaceForCollection = new HashMap<String, String>();

    private CollectionUtils() {
    }

    public static boolean isCollectionWithInitialCapacity(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass resolved = classType.resolve();
        if (resolved == null) {
            return false;
        }
        String className = resolved.getQualifiedName();
        return s_collectionClassesRequiringCapacity.contains(className);
    }

    public static boolean isCollectionClass(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass resolved = classType.resolve();
        if (resolved == null) {
            return false;
        }
        return CollectionUtils.isCollectionClass(resolved);
    }

    public static boolean isCollectionClass(PsiClass aClass) {
        String className = aClass.getQualifiedName();
        return s_allCollectionClasses.contains(className);
    }

    public static boolean isCollectionClassOrInterface(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass resolved = classType.resolve();
        if (resolved == null) {
            return false;
        }
        return CollectionUtils.isCollectionClassOrInterface(resolved);
    }

    public static boolean isCollectionClassOrInterface(PsiClass aClass) {
        return CollectionUtils.isCollectionClassOrInterface(aClass, new HashSet<PsiClass>());
    }

    private static boolean isCollectionClassOrInterface(PsiClass aClass, Set<PsiClass> visitedClasses) {
        PsiClass[] supers;
        if (!visitedClasses.add(aClass)) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (s_allCollectionClassesAndInterfaces.contains(className)) {
            return true;
        }
        for (PsiClass aSuper : supers = aClass.getSupers()) {
            if (!CollectionUtils.isCollectionClassOrInterface(aSuper, visitedClasses)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeakCollectionClass(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        String typeText = type.getCanonicalText();
        if (typeText == null) {
            return false;
        }
        return "java.util.WeakHashMap".equals(typeText);
    }

    public static boolean isConstantEmptyArray(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/CollectionUtils.isConstantEmptyArray must not be null");
        }
        if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final")) {
            return false;
        }
        return CollectionUtils.isEmptyArray(field);
    }

    public static boolean isEmptyArray(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer;
            PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
            return initializers.length == 0;
        }
        return ExpressionUtils.isZeroLengthArrayConstruction(initializer);
    }

    public static boolean isArrayOrCollectionField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/CollectionUtils.isArrayOrCollectionField must not be null");
        }
        PsiType type = field.getType();
        if (CollectionUtils.isCollectionClassOrInterface(type)) {
            return true;
        }
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        return !CollectionUtils.isConstantEmptyArray(field);
    }

    public static String getInterfaceForClass(String name) {
        int parameterStart = name.indexOf(60);
        String baseName = parameterStart >= 0 ? name.substring(0, parameterStart).trim() : name;
        return s_interfaceForCollection.get(baseName);
    }

    static {
        s_collectionClassesRequiringCapacity.add("java.util.BitSet");
        s_collectionClassesRequiringCapacity.add("java.util.Vector");
        s_collectionClassesRequiringCapacity.add("java.util.ArrayList");
        s_collectionClassesRequiringCapacity.add("java.util.HashMap");
        s_collectionClassesRequiringCapacity.add("java.util.LinkedHashMap");
        s_collectionClassesRequiringCapacity.add("java.util.WeakHashMap");
        s_collectionClassesRequiringCapacity.add("java.util.Hashtable");
        s_collectionClassesRequiringCapacity.add("java.util.HashSet");
        s_collectionClassesRequiringCapacity.add("java.util.LinkedHashSet");
        s_collectionClassesRequiringCapacity.add("com.sun.java.util.collections.BitSet");
        s_collectionClassesRequiringCapacity.add("com.sun.java.util.collections.Vector");
        s_collectionClassesRequiringCapacity.add("com.sun.java.util.collections.ArrayList");
        s_collectionClassesRequiringCapacity.add("com.sun.java.util.collections.HashMap");
        s_collectionClassesRequiringCapacity.add("com.sun.java.util.collections.Hashtable");
        s_collectionClassesRequiringCapacity.add("com.sun.java.util.collections.HashSet");
        s_allCollectionClasses.add("java.util.ArrayList");
        s_allCollectionClasses.add("java.util.EnumMap");
        s_allCollectionClasses.add("java.util.EnumSet");
        s_allCollectionClasses.add("java.util.HashMap");
        s_allCollectionClasses.add("java.util.HashSet");
        s_allCollectionClasses.add("java.util.Hashtable");
        s_allCollectionClasses.add("java.util.IdentityHashMap");
        s_allCollectionClasses.add("java.util.LinkedHashMap");
        s_allCollectionClasses.add("java.util.LinkedHashSet");
        s_allCollectionClasses.add("java.util.LinkedList");
        s_allCollectionClasses.add("java.util.PriorityQueue");
        s_allCollectionClasses.add("java.util.TreeMap");
        s_allCollectionClasses.add("java.util.TreeSet");
        s_allCollectionClasses.add("java.util.Vector");
        s_allCollectionClasses.add("java.util.WeakHashMap");
        s_allCollectionClasses.add("com.sun.java.util.collections.ArrayList");
        s_allCollectionClasses.add("com.sun.java.util.collections.HashMap");
        s_allCollectionClasses.add("com.sun.java.util.collections.HashSet");
        s_allCollectionClasses.add("com.sun.java.util.collections.Hashtable");
        s_allCollectionClasses.add("com.sun.java.util.collections.TreeMap");
        s_allCollectionClasses.add("com.sun.java.util.collections.TreeSet");
        s_allCollectionClasses.add("com.sun.java.util.collections.LinkedList");
        s_allCollectionClasses.add("com.sun.java.util.collections.Vector");
        s_allCollectionClassesAndInterfaces.add("java.util.AbstractCollection");
        s_allCollectionClassesAndInterfaces.add("java.util.AbstractList");
        s_allCollectionClassesAndInterfaces.add("java.util.AbstractMap");
        s_allCollectionClassesAndInterfaces.add("java.util.AbstractQueue");
        s_allCollectionClassesAndInterfaces.add("java.util.AbstractSequentialList");
        s_allCollectionClassesAndInterfaces.add("java.util.AbstractSet");
        s_allCollectionClassesAndInterfaces.add("java.util.ArrayList");
        s_allCollectionClassesAndInterfaces.add("java.util.Collection");
        s_allCollectionClassesAndInterfaces.add("java.util.Dictionary");
        s_allCollectionClassesAndInterfaces.add("java.util.HashMap");
        s_allCollectionClassesAndInterfaces.add("java.util.HashSet");
        s_allCollectionClassesAndInterfaces.add("java.util.Hashtable");
        s_allCollectionClassesAndInterfaces.add("java.util.IdentityHashMap");
        s_allCollectionClassesAndInterfaces.add("java.util.LinkedHashMap");
        s_allCollectionClassesAndInterfaces.add("java.util.LinkedHashSet");
        s_allCollectionClassesAndInterfaces.add("java.util.LinkedList");
        s_allCollectionClassesAndInterfaces.add("java.util.List");
        s_allCollectionClassesAndInterfaces.add("java.util.Map");
        s_allCollectionClassesAndInterfaces.add("java.util.Queue");
        s_allCollectionClassesAndInterfaces.add("java.util.Set");
        s_allCollectionClassesAndInterfaces.add("java.util.SortedMap");
        s_allCollectionClassesAndInterfaces.add("java.util.SortedSet");
        s_allCollectionClassesAndInterfaces.add("java.util.Stack");
        s_allCollectionClassesAndInterfaces.add("java.util.TreeMap");
        s_allCollectionClassesAndInterfaces.add("java.util.TreeSet");
        s_allCollectionClassesAndInterfaces.add("java.util.Vector");
        s_allCollectionClassesAndInterfaces.add("java.util.WeakHashMap");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.ArrayList");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Collection");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.HashMap");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.HashSet");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Hashtable");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.LinkedList");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.List");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Map");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Set");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.SortedMap");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.SortedSet");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.TreeMap");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.TreeSet");
        s_allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Vector");
        s_interfaceForCollection.put("ArrayList", "List");
        s_interfaceForCollection.put("EnumMap", "Map");
        s_interfaceForCollection.put("EnumSet", "Set");
        s_interfaceForCollection.put("HashMap", "Map");
        s_interfaceForCollection.put("HashSet", "Set");
        s_interfaceForCollection.put("Hashtable", "Map");
        s_interfaceForCollection.put("IdentityHashMap", "Map");
        s_interfaceForCollection.put("LinkedHashMap", "Map");
        s_interfaceForCollection.put("LinkedHashSet", "Set");
        s_interfaceForCollection.put("LinkedList", "List");
        s_interfaceForCollection.put("PriorityQueue", "Queue");
        s_interfaceForCollection.put("TreeMap", "Map");
        s_interfaceForCollection.put("TreeSet", "SortedSet");
        s_interfaceForCollection.put("Vector", "List");
        s_interfaceForCollection.put("WeakHashMap", "Map");
        s_interfaceForCollection.put("java.util.ArrayList", "java.util.List");
        s_interfaceForCollection.put("java.util.EnumMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.EnumSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.HashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.HashSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.Hashtable", "java.util.Map");
        s_interfaceForCollection.put("java.util.IdentityHashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.LinkedHashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.LinkedHashSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.LinkedList", "java.util.List");
        s_interfaceForCollection.put("java.util.PriorityQueue", "java.util.Queue");
        s_interfaceForCollection.put("java.util.TreeMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.TreeSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.Vector", "java.util.List");
        s_interfaceForCollection.put("java.util.WeakHashMap", "java.util.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.HashSet", "com.sun.java.util.collections.Set");
        s_interfaceForCollection.put("com.sun.java.util.collections.TreeSet", "com.sun.java.util.collections.Set");
        s_interfaceForCollection.put("com.sun.java.util.collections.Vector", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.ArrayList", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.LinkedList", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.TreeMap", "com.sun.java.util.collections.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.HashMap", "com.sun.java.util.collections.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.Hashtable", "com.sun.java.util.collections.Map");
    }
}

