/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TrivialStringConcatenationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ConcatenationWithEmptyString" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/TrivialStringConcatenationInspection.getID must not return null");
        }
        return "ConcatenationWithEmptyString";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("trivial.string.concatenation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/TrivialStringConcatenationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacementString = TrivialStringConcatenationInspection.calculateReplacementExpression((PsiElement)infos[0]);
        String string = InspectionGadgetsBundle.message("string.can.be.simplified.problem.descriptor", replacementString);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/TrivialStringConcatenationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @NonNls
    static String calculateReplacementExpression(PsiElement location) {
        String replacementText;
        PsiBinaryExpression expression = (PsiBinaryExpression)location;
        PsiExpression lOperand = expression.getLOperand();
        PsiExpression rOperand = expression.getROperand();
        PsiExpression replacement = ExpressionUtils.isEmptyStringLiteral(lOperand) ? rOperand : lOperand;
        if (replacement == null) {
            replacementText = "";
        } else {
            replacementText = ExpressionUtils.isNullLiteral(replacement) ? "(Object)null" : replacement.getText();
            if (TypeUtils.expressionHasType("java.lang.String", replacement)) {
                return replacementText;
            }
        }
        return "String.valueOf(" + replacementText + ')';
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryTemporaryObjectFix((PsiBinaryExpression)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialStringConcatenationVisitor();
    }

    private static class TrivialStringConcatenationVisitor
    extends BaseInspectionVisitor {
        private TrivialStringConcatenationVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/TrivialStringConcatenationInspection$TrivialStringConcatenationVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!TypeUtils.expressionHasType("java.lang.String", (PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (!ExpressionUtils.isEmptyStringLiteral(lhs) && !ExpressionUtils.isEmptyStringLiteral(rhs)) {
                return;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }
    }

    private static class UnnecessaryTemporaryObjectFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(PsiBinaryExpression expression) {
            this.m_name = InspectionGadgetsBundle.message("string.replace.quickfix", TrivialStringConcatenationInspection.calculateReplacementExpression((PsiElement)expression));
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/TrivialStringConcatenationInspection$UnnecessaryTemporaryObjectFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiBinaryExpression expression = (PsiBinaryExpression)descriptor.getPsiElement();
            String newExpression = TrivialStringConcatenationInspection.calculateReplacementExpression((PsiElement)expression);
            UnnecessaryTemporaryObjectFix.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

