/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringEqualsEmptyStringInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.equals.empty.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringEqualsEmptyStringInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.equals.empty.string.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringEqualsEmptyStringInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new StringEqualsEmptyStringFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsEmptyStringVisitor();
    }

    private static class StringEqualsEmptyStringVisitor
    extends BaseInspectionVisitor {
        private StringEqualsEmptyStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return;
            }
            if (!ExpressionUtils.isEmptyStringLiteral(args[0])) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type = qualifier.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            PsiElement context = call.getParent();
            if (context instanceof PsiExpressionStatement) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }
    }

    private static class StringEqualsEmptyStringFix
    extends InspectionGadgetsFix {
        private StringEqualsEmptyStringFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            if (expression == null) {
                return;
            }
            PsiExpression call = (PsiExpression)expression.getParent();
            PsiExpression qualifier = expression.getQualifierExpression();
            String qualifierText = StringEqualsEmptyStringFix.getRemainingText(qualifier);
            if (call == null) {
                return;
            }
            PsiElement parent = call.getParent();
            if (parent instanceof PsiExpression) {
                PsiExpression parentExpression = (PsiExpression)parent;
                if (BoolUtils.isNegation(parentExpression)) {
                    StringEqualsEmptyStringFix.replaceExpression(parentExpression, qualifierText + ".length()!=0");
                } else {
                    StringEqualsEmptyStringFix.replaceExpression(call, qualifierText + ".length()==0");
                }
            } else {
                StringEqualsEmptyStringFix.replaceExpression(call, qualifierText + ".length()==0");
            }
        }

        private static String getRemainingText(PsiExpression qualifier) {
            String qualifierText;
            if (qualifier instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)qualifier;
                PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
                String referenceName = methodExpression.getReferenceName();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (qualifierExpression == null) {
                    return qualifier.getText();
                }
                PsiType type = qualifierExpression.getType();
                qualifierText = "toString".equals(referenceName) && type != null && (type.equalsToText("java.lang.StringBuffer") || type.equalsToText("java.lang.StringBuilder")) ? qualifierExpression.getText() : qualifier.getText();
            } else {
                qualifierText = qualifier.getText();
            }
            return qualifierText;
        }
    }
}

