/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ParametersPerConstructorInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        if ("ConstructorWithTooManyParameters" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/ParametersPerConstructorInspection.getID must not return null");
        }
        return "ConstructorWithTooManyParameters";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameters.per.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/ParametersPerConstructorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer parameterCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("parameters.per.constructor.problem.descriptor", parameterCount);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/ParametersPerConstructorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("parameter.limit.option", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParametersPerMethodVisitor();
    }

    private class ParametersPerMethodVisitor
    extends BaseInspectionVisitor {
        private ParametersPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/ParametersPerConstructorInspection$ParametersPerMethodVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.isConstructor()) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount <= ParametersPerConstructorInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, parametersCount);
        }
    }
}

