/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.CallToSuperSetupVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class SetupCallsSuperSetupInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SetUpDoesntCallSuperSetUp" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/SetupCallsSuperSetupInspection.getID must not return null");
        }
        return "SetUpDoesntCallSuperSetUp";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("setup.calls.super.setup.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/SetupCallsSuperSetupInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("setup.calls.super.setup.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/SetupCallsSuperSetupInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSuperSetUpCall();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SetupCallsSuperSetupVisitor();
    }

    private static class SetupCallsSuperSetupVisitor
    extends BaseInspectionVisitor {
        private SetupCallsSuperSetupVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/SetupCallsSuperSetupInspection$SetupCallsSuperSetupVisitor.visitMethod must not be null");
            }
            String methodName = method.getName();
            if (!"setUp".equals(methodName)) {
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                return;
            }
            if (method.getBody() == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            if (!ClassUtils.isSubclass(targetClass, "junit.framework.TestCase")) {
                return;
            }
            CallToSuperSetupVisitor visitor = new CallToSuperSetupVisitor();
            method.accept((PsiElementVisitor)visitor);
            if (visitor.isCallToSuperSetupFound()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }

    private static class AddSuperSetUpCall
    extends InspectionGadgetsFix {
        private AddSuperSetUpCall() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("setup.calls.super.setup.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/SetupCallsSuperSetupInspection$AddSuperSetUpCall.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            assert (method != null);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiStatement newStatement = factory.createStatementFromText("super.setUp();", null);
            CodeStyleManager styleManager = psiManager.getCodeStyleManager();
            PsiJavaToken brace = body.getLBrace();
            body.addAfter((PsiElement)newStatement, (PsiElement)brace);
            styleManager.reformat((PsiElement)body);
        }
    }
}

