/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk15;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StringUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForCanBeForeachInspection
extends BaseInspection {
    private JCheckBox myReportIndexedLoop;
    private JPanel myPanel;
    public boolean REPORT_INDEXED_LOOP = true;

    public ForCanBeForeachInspection() {
        this.$$$setupUI$$$();
    }

    @NotNull
    public String getID() {
        if ("ForLoopReplaceableByForEach" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/ForCanBeForeachInspection.getID must not return null");
        }
        return "ForLoopReplaceableByForEach";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.can.be.foreach.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/ForCanBeForeachInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("for.can.be.foreach.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/ForCanBeForeachInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ForCanBeForeachFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForCanBeForeachVisitor();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        this.myReportIndexedLoop.setSelected(this.REPORT_INDEXED_LOOP);
        this.myReportIndexedLoop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForCanBeForeachInspection.this.REPORT_INDEXED_LOOP = ForCanBeForeachInspection.this.myReportIndexedLoop.isSelected();
            }
        });
        return this.myPanel;
    }

    private static boolean isIndexedListLoopStatement(PsiForStatement forStatement) {
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        String initializerText = initialValue.getText();
        if (!"0".equals(initializerText)) {
            return false;
        }
        PsiExpression condition = forStatement.getCondition();
        if (!ForCanBeForeachInspection.isListSizeComparison(condition, indexVariable)) {
            return false;
        }
        PsiStatement update = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update)) {
            return false;
        }
        PsiReferenceExpression collectionReference = ForCanBeForeachInspection.getVariableReferenceFromCondition(condition);
        if (collectionReference == null) {
            return false;
        }
        PsiElement resolved = collectionReference.resolve();
        PsiStatement body = forStatement.getBody();
        if (resolved instanceof PsiVariable) {
            PsiVariable collection = (PsiVariable)resolved;
            if (!ForCanBeForeachInspection.isIndexVariableOnlyUsedAsListIndex(collection, indexVariable, body)) {
                return false;
            }
            return !VariableAccessUtils.variableIsAssigned(collection, (PsiElement)body);
        }
        if (resolved instanceof PsiMethod) {
            return ForCanBeForeachInspection.isIndexVariableOnlyUsedAsListIndex(null, indexVariable, body);
        }
        return false;
    }

    static boolean isArrayLoopStatement(PsiForStatement forStatement) {
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Integer)) {
            return false;
        }
        Integer integer = (Integer)constant;
        if (integer != 0) {
            return false;
        }
        PsiExpression condition = forStatement.getCondition();
        if (!ForCanBeForeachInspection.isArrayLengthComparison(condition, indexVariable)) {
            return false;
        }
        PsiStatement update = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update)) {
            return false;
        }
        PsiReferenceExpression arrayReference = ForCanBeForeachInspection.getVariableReferenceFromCondition(condition);
        if (arrayReference == null) {
            return false;
        }
        PsiElement element = arrayReference.resolve();
        if (!(element instanceof PsiVariable)) {
            return false;
        }
        PsiVariable arrayVariable = (PsiVariable)element;
        PsiStatement body = forStatement.getBody();
        if (body == null) {
            return true;
        }
        if (!ForCanBeForeachInspection.isIndexVariableOnlyUsedAsIndex(arrayVariable, indexVariable, body)) {
            return false;
        }
        if (VariableAccessUtils.variableIsAssigned(arrayVariable, (PsiElement)body)) {
            return false;
        }
        return !VariableAccessUtils.arrayContentsAreAssigned(arrayVariable, (PsiElement)body);
    }

    private static boolean isIndexVariableOnlyUsedAsIndex(@NotNull PsiVariable arrayVariable, @NotNull PsiVariable indexVariable, @Nullable PsiStatement body) {
        if (arrayVariable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection.isIndexVariableOnlyUsedAsIndex must not be null");
        }
        if (indexVariable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection.isIndexVariableOnlyUsedAsIndex must not be null");
        }
        if (body == null) {
            return true;
        }
        VariableOnlyUsedAsIndexVisitor visitor = new VariableOnlyUsedAsIndexVisitor(arrayVariable, indexVariable);
        body.accept((PsiElementVisitor)visitor);
        return visitor.isIndexVariableUsedOnlyAsIndex();
    }

    private static boolean isIndexVariableOnlyUsedAsListIndex(PsiVariable collection, PsiVariable indexVariable, PsiStatement body) {
        if (body == null) {
            return true;
        }
        VariableOnlyUsedAsListIndexVisitor visitor = new VariableOnlyUsedAsListIndexVisitor(collection, indexVariable);
        body.accept((PsiElementVisitor)visitor);
        return visitor.isIndexVariableUsedOnlyAsIndex();
    }

    static boolean isCollectionLoopStatement(PsiForStatement forStatement) {
        PsiClass qualifierClass;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        if (variable == null) {
            return false;
        }
        PsiType variableType = variable.getType();
        if (!(variableType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)variableType;
        PsiClass declaredClass = classType.resolve();
        if (declaredClass == null) {
            return false;
        }
        if (!ClassUtils.isSubclass(declaredClass, "java.util.Iterator")) {
            return false;
        }
        PsiExpression initialValue = variable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        if (!(initialValue instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
        PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
        String initialCallName = initialMethodExpression.getReferenceName();
        if (!"iterator".equals(initialCallName)) {
            return false;
        }
        PsiExpression qualifier = initialMethodExpression.getQualifierExpression();
        if (qualifier == null) {
            qualifierClass = ClassUtils.getContainingClass((PsiElement)initialMethodExpression);
        } else {
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return false;
            }
            qualifierClass = ((PsiClassType)qualifierType).resolve();
        }
        if (qualifierClass == null) {
            return false;
        }
        if (!ClassUtils.isSubclass(qualifierClass, "java.lang.Iterable") && !ClassUtils.isSubclass(qualifierClass, "java.util.Collection")) {
            return false;
        }
        String iteratorName = variable.getName();
        PsiExpression condition = forStatement.getCondition();
        if (!ForCanBeForeachInspection.isHasNext(condition, iteratorName)) {
            return false;
        }
        PsiStatement update = forStatement.getUpdate();
        if (update != null && !(update instanceof PsiEmptyStatement)) {
            return false;
        }
        PsiStatement body = forStatement.getBody();
        if (body == null) {
            return false;
        }
        if (ForCanBeForeachInspection.calculateCallsToIteratorNext(iteratorName, body) != 1) {
            return false;
        }
        if (ForCanBeForeachInspection.isIteratorRemoveCalled(iteratorName, body)) {
            return false;
        }
        if (ForCanBeForeachInspection.isIteratorHasNextCalled(iteratorName, body)) {
            return false;
        }
        return !VariableAccessUtils.variableIsAssigned(variable, (PsiElement)body) && !VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)body);
    }

    private static int calculateCallsToIteratorNext(String iteratorName, PsiStatement body) {
        if (body == null) {
            return 0;
        }
        NumCallsToIteratorNextVisitor visitor = new NumCallsToIteratorNextVisitor(iteratorName);
        body.accept((PsiElementVisitor)visitor);
        return visitor.getNumCallsToIteratorNext();
    }

    private static boolean isIteratorRemoveCalled(String iteratorName, PsiStatement body) {
        IteratorRemoveVisitor visitor = new IteratorRemoveVisitor(iteratorName);
        body.accept((PsiElementVisitor)visitor);
        return visitor.isRemoveCalled();
    }

    private static boolean isIteratorHasNextCalled(String iteratorName, PsiStatement body) {
        IteratorHasNextVisitor visitor = new IteratorHasNextVisitor(iteratorName);
        body.accept((PsiElementVisitor)visitor);
        return visitor.isHasNextCalled();
    }

    private static boolean isHasNext(PsiExpression condition, String iterator) {
        if (!(condition instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)condition;
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 0) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"hasNext".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return true;
        }
        String target = qualifier.getText();
        return iterator.equals(target);
    }

    @Nullable
    private static PsiReferenceExpression getVariableReferenceFromCondition(PsiExpression condition) {
        if (!((condition = ParenthesesUtils.stripParentheses(condition)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
        PsiExpression rhs = binaryExpression.getROperand();
        if ((rhs = ParenthesesUtils.stripParentheses(rhs)) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)rhs;
            rhs = methodCallExpression.getMethodExpression();
        }
        if (rhs == null) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)rhs;
        PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
        if (qualifierExpression instanceof PsiReferenceExpression) {
            return (PsiReferenceExpression)qualifierExpression;
        }
        if (qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression || qualifierExpression == null) {
            return referenceExpression;
        }
        return null;
    }

    private static boolean isArrayLengthComparison(PsiExpression condition, PsiVariable variable) {
        PsiExpression strippedCondition = ParenthesesUtils.stripParentheses(condition);
        if (!(strippedCondition instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExp = (PsiBinaryExpression)strippedCondition;
        PsiJavaToken sign = binaryExp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (!tokenType.equals(JavaTokenType.LT)) {
            return false;
        }
        PsiExpression lhs = binaryExp.getLOperand();
        if (!VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
            return false;
        }
        PsiExpression rhs = binaryExp.getROperand();
        return rhs != null && ForCanBeForeachInspection.expressionIsArrayLengthLookup(rhs);
    }

    private static boolean isListSizeComparison(PsiExpression condition, PsiVariable variable) {
        if (!((condition = ParenthesesUtils.stripParentheses(condition)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (!tokenType.equals(JavaTokenType.LT)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        if (!VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        return ForCanBeForeachInspection.expressionIsListSizeLookup(rhs);
    }

    private static boolean expressionIsListSizeLookup(PsiExpression expression) {
        return ForCanBeForeachInspection.isListMethodCall(expression, "size");
    }

    static boolean expressionIsListGetLookup(PsiExpression expression) {
        return ForCanBeForeachInspection.isListMethodCall(expression, "get");
    }

    private static boolean isListMethodCall(PsiExpression expression, String methodName) {
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (!(strippedExpression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression reference = (PsiMethodCallExpression)strippedExpression;
        PsiReferenceExpression methodExpression = reference.getMethodExpression();
        PsiElement resolved = methodExpression.resolve();
        if (!(resolved instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)resolved;
        if (!methodName.equals(method.getName())) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return ClassUtils.isSubclass(aClass, "java.util.List");
    }

    private static boolean expressionIsArrayLengthLookup(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection.expressionIsArrayLengthLookup must not be null");
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (!(strippedExpression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)strippedExpression;
        String referenceName = reference.getReferenceName();
        if (!"length".equals(referenceName)) {
            return false;
        }
        PsiExpression qualifier = reference.getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiType type = qualifier.getType();
        return type != null && type.getArrayDimensions() > 0;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myReportIndexedLoop = jCheckBox = new JCheckBox();
        jCheckBox.setText("Report indexed java.util.List loops");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class VariableOnlyUsedAsListIndexVisitor
    extends JavaRecursiveElementVisitor {
        private boolean indexVariableUsedOnlyAsIndex;
        private final PsiVariable indexVariable;
        @Nullable
        private final PsiVariable collection;

        VariableOnlyUsedAsListIndexVisitor(@Nullable PsiVariable collection, @NotNull PsiVariable indexVariable) {
            if (indexVariable == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$VariableOnlyUsedAsListIndexVisitor.<init> must not be null");
            }
            this.indexVariableUsedOnlyAsIndex = true;
            this.collection = collection;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$VariableOnlyUsedAsListIndexVisitor.visitElement must not be null");
            }
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            if (reference == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$VariableOnlyUsedAsListIndexVisitor.visitReferenceExpression must not be null");
            }
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (this.indexVariable.equals(element)) {
                if (!this.isListIndexExpression(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                }
            } else if (this.collection == null) {
                if (this.isListNonGetMethodCall(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                }
            } else if (this.collection.equals(element) && !this.isListReferenceInIndexExpression(reference)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        public boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex;
        }

        private boolean isListNonGetMethodCall(PsiReferenceExpression reference) {
            PsiClass containingClass;
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class);
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)(containingClass = method.getContainingClass()), (boolean)true)) {
                return false;
            }
            return !this.isListGetExpression(methodCallExpression);
        }

        private boolean isListIndexExpression(PsiReferenceExpression reference) {
            PsiElement referenceParent = reference.getParent();
            if (!(referenceParent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)referenceParent;
            PsiElement parent = expressionList.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListReferenceInIndexExpression(PsiReferenceExpression reference) {
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiElement greatGrandParent = methodCallExpression.getParent();
            if (greatGrandParent instanceof PsiExpressionStatement) {
                return false;
            }
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListGetExpression(PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                if (this.collection == null && (qualifierExpression == null || qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression)) {
                    return ForCanBeForeachInspection.expressionIsListGetLookup((PsiExpression)methodCallExpression);
                }
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)qualifierExpression;
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = reference.resolve();
            if (this.collection == null || !this.collection.equals(target)) {
                return false;
            }
            return ForCanBeForeachInspection.expressionIsListGetLookup((PsiExpression)methodCallExpression);
        }
    }

    private static class VariableOnlyUsedAsIndexVisitor
    extends JavaRecursiveElementVisitor {
        private boolean indexVariableUsedOnlyAsIndex = true;
        private final PsiVariable arrayVariable;
        private final PsiVariable indexVariable;

        VariableOnlyUsedAsIndexVisitor(PsiVariable arrayVariable, PsiVariable indexVariable) {
            this.arrayVariable = arrayVariable;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$VariableOnlyUsedAsIndexVisitor.visitElement must not be null");
            }
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            PsiAssignmentExpression assignment;
            PsiExpression lhs;
            if (reference == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$VariableOnlyUsedAsIndexVisitor.visitReferenceExpression must not be null");
            }
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (!this.indexVariable.equals(element)) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiArrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (!this.arrayVariable.equals(target)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiElement arrayExpressionContext = arrayAccessExpression.getParent();
            if (arrayExpressionContext instanceof PsiAssignmentExpression && (lhs = (assignment = (PsiAssignmentExpression)arrayExpressionContext).getLExpression()).equals(arrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        public boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex;
        }
    }

    private static class IteratorHasNextVisitor
    extends JavaRecursiveElementVisitor {
        private boolean hasNextCalled = false;
        private final String iteratorName;

        IteratorHasNextVisitor(String iteratorName) {
            this.iteratorName = iteratorName;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$IteratorHasNextVisitor.visitElement must not be null");
            }
            if (!this.hasNextCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            String qualifierText;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$IteratorHasNextVisitor.visitMethodCallExpression must not be null");
            }
            if (this.hasNextCalled) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"hasNext".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && this.iteratorName.equals(qualifierText = qualifier.getText())) {
                this.hasNextCalled = true;
            }
        }

        public boolean isHasNextCalled() {
            return this.hasNextCalled;
        }
    }

    private static class IteratorRemoveVisitor
    extends JavaRecursiveElementVisitor {
        private boolean removeCalled = false;
        private final String iteratorName;

        IteratorRemoveVisitor(String iteratorName) {
            this.iteratorName = iteratorName;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$IteratorRemoveVisitor.visitElement must not be null");
            }
            if (!this.removeCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            String qualifierText;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$IteratorRemoveVisitor.visitMethodCallExpression must not be null");
            }
            if (this.removeCalled) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"remove".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && this.iteratorName.equals(qualifierText = qualifier.getText())) {
                this.removeCalled = true;
            }
        }

        public boolean isRemoveCalled() {
            return this.removeCalled;
        }
    }

    private static class NumCallsToIteratorNextVisitor
    extends JavaRecursiveElementVisitor {
        private int numCallsToIteratorNext = 0;
        private final String iteratorName;

        NumCallsToIteratorNextVisitor(String iteratorName) {
            this.iteratorName = iteratorName;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$NumCallsToIteratorNextVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            if (!this.iteratorName.equals(qualifierText)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        public int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }
    }

    private class ForCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private ForCanBeForeachVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement forStatement) {
            if (forStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$ForCanBeForeachVisitor.visitForStatement must not be null");
            }
            super.visitForStatement(forStatement);
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)forStatement)) {
                return;
            }
            if (ForCanBeForeachInspection.isArrayLoopStatement(forStatement) || ForCanBeForeachInspection.isCollectionLoopStatement(forStatement) || ForCanBeForeachInspection.this.REPORT_INDEXED_LOOP && ForCanBeForeachInspection.isIndexedListLoopStatement(forStatement)) {
                this.registerStatementError((PsiStatement)forStatement, new Object[0]);
            }
        }
    }

    private static class ForCanBeForeachFix
    extends InspectionGadgetsFix {
        private ForCanBeForeachFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/ForCanBeForeachInspection$ForCanBeForeachFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String newExpression;
            PsiElement forElement = descriptor.getPsiElement();
            PsiElement parent = forElement.getParent();
            if (!(parent instanceof PsiForStatement)) {
                return;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (ForCanBeForeachInspection.isArrayLoopStatement(forStatement)) {
                newExpression = ForCanBeForeachFix.createArrayIterationText(forStatement);
            } else if (ForCanBeForeachInspection.isCollectionLoopStatement(forStatement)) {
                newExpression = ForCanBeForeachFix.createCollectionIterationText(forStatement);
            } else if (ForCanBeForeachInspection.isIndexedListLoopStatement(forStatement)) {
                newExpression = ForCanBeForeachFix.createListIterationText(forStatement);
            } else {
                return;
            }
            if (newExpression == null) {
                return;
            }
            ForCanBeForeachFix.replaceStatementAndShortenClassNames((PsiStatement)forStatement, newExpression);
        }

        @Nullable
        private static String createListIterationText(@NotNull PsiForStatement forStatement) {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiVariable listVariable;
            PsiType parameterType;
            if (forStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$ForCanBeForeachFix.createListIterationText must not be null");
            }
            PsiBinaryExpression condition = (PsiBinaryExpression)forStatement.getCondition();
            if (condition == null) {
                return null;
            }
            PsiExpression lhs = condition.getLOperand();
            String indexName = lhs.getText();
            PsiExpression rOperand = condition.getROperand();
            if (rOperand == null) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(rOperand);
            if (methodCallExpression == null) {
                return null;
            }
            PsiReferenceExpression listLengthExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = listLengthExpression.getQualifierExpression();
            PsiReferenceExpression listReference = !(qualifier instanceof PsiReferenceExpression) ? null : (PsiReferenceExpression)qualifier;
            if (listReference == null) {
                parameterType = ForCanBeForeachFix.extractTypeFromContainingClass(forStatement);
            } else {
                PsiType type = listReference.getType();
                if (type == null) {
                    return null;
                }
                parameterType = ForCanBeForeachFix.extractContentTypeFromType(type, (PsiElement)forStatement);
            }
            if (parameterType == null) {
                return null;
            }
            String typeString = parameterType.getCanonicalText();
            if (listReference == null) {
                listVariable = null;
            } else {
                PsiElement target = listReference.resolve();
                if (!(target instanceof PsiVariable)) {
                    return null;
                }
                listVariable = (PsiVariable)target;
            }
            PsiStatement body = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachFix.getFirstStatement(body);
            boolean isDeclaration = ForCanBeForeachFix.isListElementDeclaration(firstStatement, listVariable, indexName, parameterType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                assert (declarationStatement != null);
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                contentVariableName = variable.getName();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                String collectionName = listReference == null ? null : listReference.getReferenceName();
                contentVariableName = ForCanBeForeachFix.createNewVariableName(forStatement, parameterType, collectionName);
                finalString = "";
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder();
            out.append("for(");
            out.append(finalString);
            out.append(typeString);
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            String listName = listReference == null ? "this" : listReference.getText();
            out.append(listName);
            out.append(')');
            if (body != null) {
                ForCanBeForeachFix.replaceCollectionGetAccess((PsiElement)body, contentVariableName, listVariable, indexName, (PsiElement)statementToSkip, out);
            }
            return out.toString();
        }

        @Nullable
        private static PsiType extractContentTypeFromType(PsiType collectionType, PsiElement context) {
            if (!(collectionType instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)collectionType;
            PsiType[] parameterTypes = classType.getParameters();
            if (parameterTypes.length == 0) {
                return PsiType.getJavaLangObject((PsiManager)context.getManager(), (GlobalSearchScope)context.getResolveScope());
            }
            PsiType parameterType = parameterTypes[0];
            if (parameterType == null) {
                return PsiType.getJavaLangObject((PsiManager)context.getManager(), (GlobalSearchScope)context.getResolveScope());
            }
            if (parameterType instanceof PsiWildcardType) {
                PsiWildcardType wildcardType = (PsiWildcardType)parameterType;
                return wildcardType.getExtendsBound();
            }
            if (parameterType instanceof PsiCapturedWildcardType) {
                PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)parameterType;
                PsiWildcardType wildcardType = capturedWildcardType.getWildcard();
                return wildcardType.getExtendsBound();
            }
            return parameterType;
        }

        @Nullable
        private static PsiType extractTypeFromContainingClass(PsiForStatement forStatement) {
            PsiClass listClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)forStatement, PsiClass.class);
            if (listClass == null) {
                return null;
            }
            PsiMethod[] getMethods = listClass.findMethodsByName("get", true);
            if (getMethods.length == 0) {
                return null;
            }
            PsiType type = getMethods[0].getReturnType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass parameterClass = classType.resolve();
            if (parameterClass == null) {
                return null;
            }
            PsiClass subClass = null;
            while (listClass != null && !listClass.hasTypeParameters()) {
                subClass = listClass;
                listClass = listClass.getSuperClass();
            }
            if (listClass == null || subClass == null) {
                return PsiType.getJavaLangObject((PsiManager)forStatement.getManager(), (GlobalSearchScope)forStatement.getResolveScope());
            }
            PsiTypeParameter[] typeParameters = listClass.getTypeParameters();
            if (!parameterClass.equals(typeParameters[0])) {
                return PsiType.getJavaLangObject((PsiManager)forStatement.getManager(), (GlobalSearchScope)forStatement.getResolveScope());
            }
            PsiReferenceList extendsList = subClass.getExtendsList();
            if (extendsList == null) {
                return null;
            }
            PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
            if (referenceElements.length == 0) {
                return null;
            }
            PsiType[] types = referenceElements[0].getTypeParameters();
            if (types.length == 0) {
                return PsiType.getJavaLangObject((PsiManager)forStatement.getManager(), (GlobalSearchScope)forStatement.getResolveScope());
            }
            return types[0];
        }

        @Nullable
        private static String createCollectionIterationText(@NotNull PsiForStatement forStatement) throws IncorrectOperationException {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiType collectionContentsType;
            if (forStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$ForCanBeForeachFix.createCollectionIterationText must not be null");
            }
            PsiStatement body = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachFix.getFirstStatement(body);
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement declaredIterator = declaration.getDeclaredElements()[0];
            if (!(declaredIterator instanceof PsiVariable)) {
                return null;
            }
            PsiVariable iterator = (PsiVariable)declaredIterator;
            PsiType iteratorType = iterator.getType();
            PsiType iteratedContentsType = ForCanBeForeachFix.extractContentTypeFromType(iteratorType, (PsiElement)iterator);
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)iterator.getInitializer();
            if (initializer == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = methodExpression.getQualifierExpression();
            if (collection == null) {
                collectionContentsType = ForCanBeForeachFix.extractTypeFromContainingClass(forStatement);
            } else {
                PsiType collectionType = collection.getType();
                collectionContentsType = ForCanBeForeachFix.extractContentTypeFromType(collectionType, (PsiElement)collection);
            }
            if (collectionContentsType == null) {
                return null;
            }
            PsiType contentType = iteratedContentsType == null ? collectionContentsType : iteratedContentsType;
            String iteratorName = iterator.getName();
            boolean isDeclaration = ForCanBeForeachFix.isIteratorNextDeclaration(firstStatement, iteratorName, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                assert (declarationStatement != null);
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                contentVariableName = variable.getName();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)collection;
                    String collectionName = referenceExpression.getReferenceName();
                    contentVariableName = ForCanBeForeachFix.createNewVariableName(forStatement, contentType, collectionName);
                } else {
                    contentVariableName = ForCanBeForeachFix.createNewVariableName(forStatement, contentType, null);
                }
                Project project = forStatement.getProject();
                CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
                finalString = codeStyleSettings.GENERATE_FINAL_LOCALS ? "final " : "";
                statementToSkip = null;
            }
            String contentTypeString = contentType.getCanonicalText();
            String iterableTypeString = "java.lang.Iterable<" + contentTypeString + '>';
            String castString = iteratedContentsType == null || iteratedContentsType.isAssignableFrom(collectionContentsType) ? "" : '(' + iterableTypeString + ')';
            StringBuilder out = new StringBuilder();
            out.append("for(");
            out.append(finalString);
            out.append(contentTypeString);
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            out.append(castString);
            if (collection == null) {
                out.append("this");
            } else {
                out.append(collection.getText());
            }
            out.append(')');
            ForCanBeForeachFix.replaceIteratorNext((PsiElement)body, contentVariableName, iteratorName, (PsiElement)statementToSkip, out, contentType);
            return out.toString();
        }

        @Nullable
        private static String createArrayIterationText(@NotNull PsiForStatement forStatement) {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            if (forStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$ForCanBeForeachFix.createArrayIterationText must not be null");
            }
            PsiExpression condition = forStatement.getCondition();
            PsiBinaryExpression strippedCondition = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(condition);
            if (strippedCondition == null) {
                return null;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(strippedCondition.getLOperand());
            if (lhs == null) {
                return null;
            }
            String indexName = lhs.getText();
            PsiExpression rhs = strippedCondition.getROperand();
            PsiReferenceExpression arrayLengthExpression = (PsiReferenceExpression)ParenthesesUtils.stripParentheses(rhs);
            assert (arrayLengthExpression != null);
            PsiReferenceExpression arrayReference = (PsiReferenceExpression)arrayLengthExpression.getQualifierExpression();
            if (arrayReference == null) {
                return null;
            }
            PsiArrayType arrayType = (PsiArrayType)arrayReference.getType();
            if (arrayType == null) {
                return null;
            }
            PsiType componentType = arrayType.getComponentType();
            String typeText = componentType.getCanonicalText();
            PsiElement target = arrayReference.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            PsiVariable arrayVariable = (PsiVariable)target;
            PsiStatement body = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachFix.getFirstStatement(body);
            boolean isDeclaration = ForCanBeForeachFix.isArrayElementDeclaration(firstStatement, arrayVariable, indexName);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                assert (declarationStatement != null);
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                contentVariableName = variable.getName();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                String collectionName = arrayReference.getReferenceName();
                contentVariableName = ForCanBeForeachFix.createNewVariableName(forStatement, componentType, collectionName);
                finalString = "";
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder();
            out.append("for(");
            out.append(finalString);
            out.append(typeText);
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            String arrayName = arrayReference.getText();
            out.append(arrayName);
            out.append(')');
            if (body != null) {
                ForCanBeForeachFix.replaceArrayAccess((PsiElement)body, contentVariableName, arrayVariable, indexName, (PsiElement)statementToSkip, out);
            }
            return out.toString();
        }

        private static void replaceArrayAccess(PsiElement element, String contentVariableName, PsiVariable arrayVariable, String indexName, PsiElement childToSkip, StringBuilder out) {
            if (ForCanBeForeachFix.isArrayLookup(element, indexName, arrayVariable)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    String text = element.getText();
                    if ("instanceof".equals(text) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(text);
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        ForCanBeForeachFix.replaceArrayAccess(child, contentVariableName, arrayVariable, indexName, childToSkip, out);
                    }
                }
            }
        }

        private static void replaceCollectionGetAccess(PsiElement element, String contentVariableName, PsiVariable listVariable, String indexName, PsiElement childToSkip, StringBuilder out) {
            if (ForCanBeForeachFix.isListGetLookup(element, indexName, listVariable)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    String text = element.getText();
                    if ("instanceof".equals(text) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(text);
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        ForCanBeForeachFix.replaceCollectionGetAccess(child, contentVariableName, listVariable, indexName, childToSkip, out);
                    }
                }
            }
        }

        private static boolean isListGetLookup(PsiElement element, String indexName, PsiVariable listVariable) {
            if (!(element instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expression = (PsiExpression)element;
            if (!ForCanBeForeachInspection.expressionIsListGetLookup(expression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(expression);
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 1) {
                return false;
            }
            if (!indexName.equals(expressions[0].getText())) {
                return false;
            }
            if (qualifierExpression == null || qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression) {
                return listVariable == null;
            }
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            return listVariable.equals(target);
        }

        private static void replaceIteratorNext(PsiElement element, String contentVariableName, String iteratorName, PsiElement childToSkip, StringBuilder out, PsiType contentType) {
            if (ForCanBeForeachFix.isIteratorNext(element, iteratorName, contentType)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    String text = element.getText();
                    if ("instanceof".equals(text) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(text);
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        ForCanBeForeachFix.replaceIteratorNext(child, contentVariableName, iteratorName, childToSkip, out, contentType);
                    }
                }
            }
        }

        private static boolean isArrayElementDeclaration(PsiStatement statement, PsiVariable arrayVariable, String indexName) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            return ForCanBeForeachFix.isArrayLookup((PsiElement)initializer, indexName, arrayVariable);
        }

        private static boolean isListElementDeclaration(PsiStatement statement, PsiVariable listVariable, String indexName, PsiType type) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            if (!ForCanBeForeachFix.isListGetLookup((PsiElement)initializer, indexName, listVariable)) {
                return false;
            }
            return type != null && type.equals(variable.getType());
        }

        private static boolean isIteratorNextDeclaration(PsiStatement statement, String iteratorName, PsiType contentType) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            return ForCanBeForeachFix.isIteratorNext((PsiElement)initializer, iteratorName, contentType);
        }

        private static boolean isArrayLookup(PsiElement element, String indexName, PsiVariable arrayVariable) {
            if (element == null) {
                return false;
            }
            if (!(element instanceof PsiArrayAccessExpression)) {
                return false;
            }
            PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)element;
            PsiExpression indexExpression = arrayAccess.getIndexExpression();
            if (indexExpression == null) {
                return false;
            }
            if (!indexName.equals(indexExpression.getText())) {
                return false;
            }
            PsiExpression arrayExpression = arrayAccess.getArrayExpression();
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            return arrayVariable.equals(target);
        }

        private static boolean isIteratorNext(PsiElement element, String iteratorName, PsiType contentType) {
            if (element == null) {
                return false;
            }
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)element;
                PsiType type = castExpression.getType();
                if (type == null) {
                    return false;
                }
                if (!type.equals(contentType)) {
                    return false;
                }
                PsiExpression operand = castExpression.getOperand();
                return ForCanBeForeachFix.isIteratorNext((PsiElement)operand, iteratorName, contentType);
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 0) {
                return false;
            }
            PsiReferenceExpression reference = callExpression.getMethodExpression();
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            if (!iteratorName.equals(qualifier.getText())) {
                return false;
            }
            String referenceName = reference.getReferenceName();
            return "next".equals(referenceName);
        }

        private static String createNewVariableName(@NotNull PsiForStatement scope, PsiType type, @Nullable String containerName) {
            String baseName;
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/ForCanBeForeachInspection$ForCanBeForeachFix.createNewVariableName must not be null");
            }
            Project project = scope.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            if (containerName != null) {
                baseName = StringUtils.createSingularFromName(containerName);
            } else {
                SuggestedNameInfo suggestions = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type);
                String[] names = suggestions.names;
                baseName = names != null && names.length > 0 ? names[0] : "value";
            }
            if (baseName == null || baseName.length() == 0) {
                baseName = "value";
            }
            return codeStyleManager.suggestUniqueVariableName(baseName, (PsiElement)scope, true);
        }

        @Nullable
        private static PsiStatement getFirstStatement(PsiStatement body) {
            if (!(body instanceof PsiBlockStatement)) {
                return body;
            }
            PsiBlockStatement block = (PsiBlockStatement)body;
            PsiCodeBlock codeBlock = block.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length <= 0) {
                return null;
            }
            return statements[0];
        }
    }
}

