/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CharacterComparisonInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CharacterComparison" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/internationalization/CharacterComparisonInspection.getID must not return null");
        }
        return "CharacterComparison";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("character.comparison.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/internationalization/CharacterComparisonInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("character.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/internationalization/CharacterComparisonInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CharacterComparisonVisitor();
    }

    private static class CharacterComparisonVisitor
    extends BaseInspectionVisitor {
        private CharacterComparisonVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/internationalization/CharacterComparisonInspection$CharacterComparisonVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression)) {
                return;
            }
            if (ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!CharacterComparisonVisitor.isCharacter(lhs)) {
                return;
            }
            if (!CharacterComparisonVisitor.isCharacter(rhs)) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotated(lhs) || NonNlsUtils.isNonNlsAnnotated(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean isCharacter(PsiExpression lhs) {
            return TypeUtils.expressionHasType("char", lhs) || TypeUtils.expressionHasType("java.lang.Character", lhs);
        }
    }
}

