/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClassInheritanceDepthInspection
extends ClassMetricInspection {
    private static final int CLASS_INHERITANCE_LIMIT = 2;

    @NotNull
    public String getID() {
        if ("ClassTooDeepInInheritanceTree" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ClassInheritanceDepthInspection.getID must not return null");
        }
        return "ClassTooDeepInInheritanceTree";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.too.deep.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ClassInheritanceDepthInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 2;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("class.too.deep.inheritance.depth.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("class.too.deep.problem.descriptor", count);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/ClassInheritanceDepthInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNestingLevel();
    }

    private class ClassNestingLevel
    extends BaseInspectionVisitor {
        private ClassNestingLevel() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ClassInheritanceDepthInspection$ClassNestingLevel.visitClass must not be null");
            }
            if (aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            int inheritanceDepth = this.getInheritanceDepth(aClass, new HashSet<PsiClass>());
            if (inheritanceDepth <= ClassInheritanceDepthInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, inheritanceDepth);
        }

        private int getInheritanceDepth(PsiClass aClass, Set<PsiClass> visited) {
            if (visited.contains(aClass)) {
                return 0;
            }
            visited.add(aClass);
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return 0;
            }
            if (LibraryUtil.classIsInLibrary(aClass) && LibraryUtil.classIsInLibrary(superClass)) {
                return 0;
            }
            return this.getInheritanceDepth(superClass, visited) + 1;
        }
    }
}

