/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class MismatchedArrayReadWriteInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("MismatchedReadAndWriteOfArray" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection.getID must not return null");
        }
        return "MismatchedReadAndWriteOfArray";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.read.write.array.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean written = (Boolean)infos[0];
        if (written) {
            string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.write.not.read", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.read.not.write", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection.buildErrorString must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedArrayReadWriteVisitor();
    }

    private static class MismatchedArrayReadWriteVisitor
    extends BaseInspectionVisitor {
        private MismatchedArrayReadWriteVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            boolean read;
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            if (containingClass == null) {
                return;
            }
            PsiType type = field.getType();
            if (type.getArrayDimensions() == 0) {
                return;
            }
            boolean written = MismatchedArrayReadWriteVisitor.arrayContentsAreWritten((PsiVariable)field, (PsiElement)containingClass);
            if (written == (read = MismatchedArrayReadWriteVisitor.arrayContentsAreRead((PsiVariable)field, (PsiElement)containingClass))) {
                return;
            }
            this.registerFieldError(field, written);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            boolean read;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (codeBlock == null) {
                return;
            }
            PsiType type = variable.getType();
            if (type.getArrayDimensions() == 0) {
                return;
            }
            boolean written = MismatchedArrayReadWriteVisitor.arrayContentsAreWritten((PsiVariable)variable, (PsiElement)codeBlock);
            if (written == (read = MismatchedArrayReadWriteVisitor.arrayContentsAreRead((PsiVariable)variable, (PsiElement)codeBlock))) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, written);
        }

        private static boolean arrayContentsAreWritten(PsiVariable variable, PsiElement context) {
            if (VariableAccessUtils.arrayContentsAreAssigned(variable, context)) {
                return true;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedArrayReadWriteVisitor.isDefaultArrayInitializer(initializer)) {
                return true;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return true;
            }
            if (MismatchedArrayReadWriteVisitor.variableIsWrittenAsMethodArgument(variable, context)) {
                return true;
            }
            return VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean arrayContentsAreRead(PsiVariable variable, PsiElement context) {
            if (VariableAccessUtils.arrayContentsAreAccessed(variable, context)) {
                return true;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedArrayReadWriteVisitor.isDefaultArrayInitializer(initializer)) {
                return true;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return true;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return true;
            }
            if (MismatchedArrayReadWriteVisitor.variableIsReadAsMethodArgument(variable, context)) {
                return true;
            }
            return VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean isDefaultArrayInitializer(PsiExpression initializer) {
            if (!(initializer instanceof PsiNewExpression)) {
                return false;
            }
            PsiNewExpression newExpression = (PsiNewExpression)initializer;
            return newExpression.getArrayInitializer() == null;
        }

        public static boolean variableIsWrittenAsMethodArgument(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor.variableIsWrittenAsMethodArgument must not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor.variableIsWrittenAsMethodArgument must not be null");
            }
            VariablePassedAsArgumentVisitor visitor = new VariablePassedAsArgumentVisitor(variable, true);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isPassed();
        }

        public static boolean variableIsReadAsMethodArgument(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor.variableIsReadAsMethodArgument must not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor.variableIsReadAsMethodArgument must not be null");
            }
            VariablePassedAsArgumentVisitor visitor = new VariablePassedAsArgumentVisitor(variable, false);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isPassed();
        }

        static class VariablePassedAsArgumentVisitor
        extends JavaRecursiveElementVisitor {
            @NotNull
            private final PsiVariable variable;
            private final boolean write;
            private boolean passed;

            VariablePassedAsArgumentVisitor(@NotNull PsiVariable variable, boolean write) {
                if (variable == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$VariablePassedAsArgumentVisitor.<init> must not be null");
                }
                this.passed = false;
                this.variable = variable;
                this.write = write;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$VariablePassedAsArgumentVisitor.visitElement must not be null");
                }
                if (!this.passed) {
                    super.visitElement(element);
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$VariablePassedAsArgumentVisitor.visitMethodCallExpression must not be null");
                }
                if (this.passed) {
                    return;
                }
                super.visitMethodCallExpression(call);
                PsiExpressionList argumentList = call.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                for (int i = 0; i < arguments.length; ++i) {
                    PsiExpression argument = arguments[i];
                    if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
                    if (this.write && i == 0 && VariablePassedAsArgumentVisitor.isCallToSystemArraycopy(call)) {
                        return;
                    }
                    if (!this.write && i == 2 && VariablePassedAsArgumentVisitor.isCallToSystemArraycopy(call)) {
                        return;
                    }
                    this.passed = true;
                }
            }

            private static boolean isCallToSystemArraycopy(PsiMethodCallExpression call) {
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                String name = methodExpression.getReferenceName();
                if (!"arraycopy".equals(name)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass = (PsiClass)element;
                String qualifiedName = aClass.getQualifiedName();
                return "java.lang.System".equals(qualifiedName);
            }

            public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
                PsiExpression[] arguments;
                if (newExpression == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$VariablePassedAsArgumentVisitor.visitNewExpression must not be null");
                }
                if (this.passed) {
                    return;
                }
                super.visitNewExpression(newExpression);
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
                    this.passed = true;
                }
            }

            public boolean isPassed() {
                return this.passed;
            }
        }
    }
}

