/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import org.jetbrains.annotations.NotNull;

public class CastToConcreteClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.to.concrete.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/CastToConcreteClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiElement typeElement = (PsiElement)infos[0];
        String string = InspectionGadgetsBundle.message("cast.to.concrete.class.problem.descriptor", typeElement.getText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/CastToConcreteClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastToConcreteClassVisitor();
    }

    private static class CastToConcreteClassVisitor
    extends BaseInspectionVisitor {
        private CastToConcreteClassVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/CastToConcreteClassInspection$CastToConcreteClassVisitor.visitTypeCastExpression must not be null");
            }
            super.visitTypeCastExpression(expression);
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement == null) {
                return;
            }
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement)) {
                return;
            }
            this.registerError((PsiElement)typeElement, typeElement);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"cast".equals(referenceName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)qualifier;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            if (!ConcreteClassUtil.typeIsConcreteClass(operand)) {
                return;
            }
            this.registerMethodCallError(expression, operand);
        }
    }
}

