/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.psi;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.util.StringUtil;

public abstract class PsiAdapter {
    protected PsiAdapter() {
    }

    @Nullable
    public PsiClass findClass(PsiElement element) {
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        if (element.getParent() != null) {
            return this.findClass(element.getParent());
        }
        return null;
    }

    public boolean isConstantField(PsiField field) {
        PsiModifierList list = field.getModifierList();
        if (list == null) {
            return false;
        }
        if (!list.hasModifierProperty("static")) {
            return false;
        }
        return !StringUtil.hasLowerCaseChar(field.getName());
    }

    @Nullable
    public PsiMethod findMethodByName(PsiClass clazz, String name) {
        PsiMethod[] methods = clazz.getMethods();
        for (int i = methods.length - 1; i >= 0; --i) {
            PsiMethod method = methods[i];
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public boolean isPrimitiveArrayType(PsiType type) {
        return type instanceof PsiArrayType && this.isPrimitiveType(((PsiArrayType)type).getComponentType());
    }

    public boolean isObjectArrayType(PsiType type) {
        return type instanceof PsiArrayType && !this.isPrimitiveType(((PsiArrayType)type).getComponentType());
    }

    public boolean isStringArrayType(PsiType type) {
        if (this.isPrimitiveType(type)) {
            return false;
        }
        return type.getCanonicalText().indexOf("String[]") > 0;
    }

    public boolean isCollectionType(PsiElementFactory factory, PsiType type) {
        return this.isTypeOf(factory, type, "java.util.Collection");
    }

    public boolean isMapType(PsiElementFactory factory, PsiType type) {
        return this.isTypeOf(factory, type, "java.util.Map");
    }

    public boolean isSetType(PsiElementFactory factory, PsiType type) {
        return this.isTypeOf(factory, type, "java.util.Set");
    }

    public boolean isListType(PsiElementFactory factory, PsiType type) {
        return this.isTypeOf(factory, type, "java.util.List");
    }

    public boolean isStringType(PsiElementFactory factory, PsiType type) {
        return this.isTypeOf(factory, type, "java.lang.String");
    }

    public boolean isObjectType(PsiElementFactory factory, PsiType type) {
        return this.isTypeOf(factory, type, "java.lang.Object");
    }

    public boolean isDateType(PsiElementFactory factory, PsiType type) {
        return this.isTypeOf(factory, type, "java.util.Date");
    }

    public boolean isCalendarType(PsiElementFactory factory, PsiType type) {
        return this.isTypeOf(factory, type, "java.util.Calendar");
    }

    public boolean isBooleanType(PsiElementFactory factory, PsiType type) {
        if (this.isPrimitiveType(type)) {
            String s = type.getCanonicalText();
            return "boolean".equals(s);
        }
        return this.isTypeOf(factory, type, "java.lang.Boolean");
    }

    public boolean isNumericType(PsiElementFactory factory, PsiType type) {
        if (this.isPrimitiveType(type)) {
            String s = type.getCanonicalText();
            return "byte".equals(s) || "double".equals(s) || "float".equals(s) || "int".equals(s) || "long".equals(s) || "short".equals(s);
        }
        return this.isTypeOf(factory, type, "java.lang.Number");
    }

    public boolean hasImportStatement(PsiJavaFile javaFile, String importStatement) {
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        if (importStatement.endsWith(".*")) {
            return importList.findOnDemandImportStatement(this.fixImportStatement(importStatement)) != null;
        }
        return importList.findSingleClassImportStatement(importStatement) != null;
    }

    public void addImportStatement(PsiJavaFile javaFile, String importStatementOnDemand, PsiElementFactory factory) throws IncorrectOperationException {
        PsiImportStatement is = factory.createImportStatementOnDemand(this.fixImportStatement(importStatementOnDemand));
        PsiImportList importList = javaFile.getImportList();
        if (importList != null) {
            importList.add((PsiElement)is);
        }
        JavaCodeStyleManager.getInstance((Project)javaFile.getProject()).optimizeImports((PsiFile)javaFile);
    }

    private String fixImportStatement(String importStatementOnDemand) {
        if (importStatementOnDemand.endsWith(".*")) {
            return importStatementOnDemand.substring(0, importStatementOnDemand.length() - 2);
        }
        boolean hasClassname = StringUtil.hasUpperCaseChar(importStatementOnDemand);
        if (hasClassname) {
            int pos = importStatementOnDemand.lastIndexOf(".");
            return importStatementOnDemand.substring(0, pos);
        }
        return importStatementOnDemand;
    }

    public boolean hasSuperClass(Project project, PsiClass clazz) {
        PsiClass superClass = this.getSuperClass(project, clazz);
        if (superClass == null) {
            return false;
        }
        return !"Object".equals(superClass.getName());
    }

    @Nullable
    public String getTypeQualifiedClassName(PsiType type) {
        if (this.isPrimitiveType(type)) {
            return null;
        }
        String name = type.getCanonicalText();
        if (name.endsWith("[]")) {
            return name.substring(0, name.length() - 2);
        }
        return name;
    }

    @Nullable
    public String getTypeClassName(PsiType type) {
        String name = this.getTypeQualifiedClassName(type);
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        return name.substring(i + 1, name.length());
    }

    @Nullable
    public PsiMethod findPublicStaticVoidMainMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz.findMethodsByName("main", false)) {
            PsiParameter[] parameters;
            PsiType returnType;
            if (!method.hasModifierProperty("public") || !method.hasModifierProperty("static") || (returnType = method.getReturnType()) == null || returnType.equalsToText("void") || (parameters = method.getParameterList().getParameters()).length != 1 || !this.isStringArrayType(parameters[0].getType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public PsiComment addOrReplaceJavadoc(PsiElementFactory factory, CodeStyleManager codeStyleManager, PsiMethod method, String javadoc, boolean replace) throws IncorrectOperationException {
        PsiComment comment = factory.createCommentFromText(javadoc, null);
        PsiDocComment doc = method.getDocComment();
        if (doc != null) {
            if (replace) {
                doc.replace((PsiElement)comment);
                codeStyleManager.reformat((PsiElement)method);
                return comment;
            }
            return null;
        }
        method.addBefore((PsiElement)comment, method.getFirstChild());
        codeStyleManager.reformat((PsiElement)method);
        return comment;
    }

    @Nullable
    public PsiField findFieldByName(PsiClass clazz, String name) {
        PsiField[] fields = clazz.getFields();
        for (int i = fields.length - 1; i >= 0; --i) {
            PsiField field = fields[i];
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public boolean isTypeOfVoid(PsiType type) {
        return type != null && type.equalsToText("void");
    }

    public boolean isGetterMethod(PsiElementFactory factory, PsiMethod method) {
        if (this.isTypeOfVoid(method.getReturnType())) {
            return false;
        }
        if (method.getName().matches("^(is|has)\\p{Upper}.*")) {
            return this.isBooleanType(factory, method.getReturnType());
        }
        return method.getName().matches("^(get)\\p{Upper}.*");
    }

    @Nullable
    public String getGetterFieldName(PsiElementFactory factory, PsiMethod method) {
        if (!this.isGetterMethod(factory, method)) {
            return null;
        }
        String getName = StringUtil.after(method.getName(), "get");
        if (getName != null) {
            getName = StringUtil.firstLetterToLowerCase(getName);
            return getName;
        }
        String isName = StringUtil.after(method.getName(), "is");
        if (isName != null) {
            isName = StringUtil.firstLetterToLowerCase(isName);
            return isName;
        }
        return null;
    }

    public boolean isEnumField(PsiField field) {
        PsiType type = field.getType();
        if (this.isPrimitiveType(type)) {
            return false;
        }
        GlobalSearchScope scope = type.getResolveScope();
        if (scope == null) {
            return false;
        }
        String name = type.getCanonicalText();
        PsiClass clazz = JavaPsiFacade.getInstance((Project)field.getProject()).findClass(name, scope);
        if (clazz == null) {
            return false;
        }
        return clazz.isEnum();
    }

    public static boolean isExceptionClass(PsiClass clazz) {
        return InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Throwable");
    }

    public boolean isAbstractClass(PsiClass clazz) {
        PsiModifierList list = clazz.getModifierList();
        if (list == null) {
            return false;
        }
        return clazz.getModifierList().hasModifierProperty("abstract");
    }

    @Nullable
    public PsiMethod findEqualsMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz.findMethodsByName("equals", false)) {
            PsiParameter[] parameters;
            PsiType returnType;
            if (!method.hasModifierProperty("public") || method.hasModifierProperty("static") || (returnType = method.getReturnType()) == null || !returnType.equalsToText("boolean") || (parameters = method.getParameterList().getParameters()).length != 1 || !parameters[0].getType().getCanonicalText().equals("java.lang.Object")) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public PsiMethod findHashCodeMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz.findMethodsByName("hashCode", false)) {
            PsiParameter[] parameters;
            PsiType returnType;
            if (!method.hasModifierProperty("public") || method.hasModifierProperty("static") || (returnType = method.getReturnType()) == null || !returnType.equalsToText("int") || (parameters = method.getParameterList().getParameters()).length != 0) continue;
            return method;
        }
        return null;
    }

    public PsiAnnotation addAnnotationToMethod(PsiElementFactory factory, PsiMethod method, String annotation) throws IncorrectOperationException {
        PsiAnnotation ann = method.getModifierList().findAnnotation(annotation);
        if (ann == null) {
            ann = factory.createAnnotationFromText(annotation, (PsiElement)method.getModifierList());
            PsiModifierList modifierList = method.getModifierList();
            modifierList.addBefore((PsiElement)ann, modifierList.getFirstChild());
        } else {
            PsiModifierList modifierList = method.getModifierList();
            modifierList.replace((PsiElement)ann);
        }
        return ann;
    }

    protected boolean isTypeOf(PsiElementFactory factory, PsiType type, String typeFQClassName) {
        if (this.isTypeOfVoid(type)) {
            return false;
        }
        if (this.isPrimitiveType(type)) {
            return false;
        }
        GlobalSearchScope scope = type.getResolveScope();
        if (scope == null) {
            return false;
        }
        PsiClassType typeTarget = factory.createTypeByFQClassName(typeFQClassName, scope);
        return typeTarget.isAssignableFrom(type);
    }

    @Nullable
    public PsiClass getSuperClass(Project project, PsiClass clazz) {
        PsiReferenceList list = clazz.getExtendsList();
        if (list == null || list.getReferencedTypes().length != 1) {
            return null;
        }
        GlobalSearchScope scope = list.getReferencedTypes()[0].getResolveScope();
        String classname = list.getReferencedTypes()[0].getCanonicalText();
        return JavaPsiFacade.getInstance((Project)project).findClass(classname, scope);
    }

    public String[] getImplementsClassnames(PsiClass clazz) {
        PsiClass[] interfaces = clazz.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            PsiClass anInterface = interfaces[i];
            names[i] = anInterface.getName();
        }
        return names;
    }

    public boolean isPrimitiveType(PsiType type) {
        return type instanceof PsiPrimitiveType;
    }

    public void executeCommand(Project project, Runnable runable) {
        CommandProcessor.getInstance().executeCommand(project, runable, "GenerateToString", null);
    }

    public void addImplements(Project project, PsiClass clazz, String interfaceName) throws IncorrectOperationException {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass interfaceClass = facade.findClass(interfaceName, GlobalSearchScope.allScope((Project)project));
        if (interfaceClass != null) {
            PsiJavaCodeReferenceElement ref = facade.getElementFactory().createClassReferenceElement(interfaceClass);
            PsiReferenceList list = clazz.getImplementsList();
            if (list != null) {
                list.add((PsiElement)ref);
            }
        }
    }

    public abstract String getPluginFilename();
}

