/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.openapi.util.io.FileUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.command.log.SymbolicName;

public class LogInformationWrapper {
    private final String myFile;
    private final List<Revision> myRevisions;
    private final List<SymbolicName> mySymbolicNames;
    @NonNls
    private static final String CVS_REPOSITORY_FILE_POSTFIX = ",v";

    public LogInformationWrapper(String file, List<Revision> revisions, List<SymbolicName> symbolicNames) {
        this.myFile = file;
        this.myRevisions = revisions;
        this.mySymbolicNames = symbolicNames;
    }

    public String getFile() {
        return this.myFile;
    }

    public List<Revision> getRevisions() {
        return this.myRevisions;
    }

    public List<SymbolicName> getSymbolicNames() {
        return this.mySymbolicNames;
    }

    @Nullable
    public static LogInformationWrapper wrap(String repository, LogInformation log) {
        String rcsFileName;
        LogInformationWrapper wrapper = null;
        if (!log.getRevisionList().isEmpty() && FileUtil.toSystemIndependentName((String)(rcsFileName = log.getRcsFileName())).startsWith(FileUtil.toSystemIndependentName((String)repository))) {
            String relativePath = rcsFileName.substring(repository.length());
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (relativePath.endsWith(CVS_REPOSITORY_FILE_POSTFIX)) {
                relativePath = relativePath.substring(0, relativePath.length() - CVS_REPOSITORY_FILE_POSTFIX.length());
            }
            wrapper = new LogInformationWrapper(relativePath, log.getRevisionList(), log.getAllSymbolicNames());
        }
        return wrapper;
    }
}

