/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.cvsSupport2.changeBrowser.LogInformationWrapper;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsLog.RlogCommand;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.log.LogInformation;

public class LoadHistoryOperation
extends LocalPathIndifferentOperation {
    @NonNls
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US));
    private static final Collection<String> ourDoNotSupportingSOptionServers = new HashSet<String>();
    private final String myModule;
    private final Date myDateFrom;
    private final Date myDateTo;
    private final List<LogInformationWrapper> myLog;

    public LoadHistoryOperation(CvsEnvironment environment, String module, @NotNull Date dateFrom, @Nullable Date dateTo, @Nullable List<LogInformationWrapper> log) {
        if (dateFrom == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/cvsSupport2/changeBrowser/LoadHistoryOperation.<init> must not be null");
        }
        super(environment);
        this.myLog = log == null ? new ArrayList() : log;
        this.myModule = module;
        this.myDateFrom = dateFrom;
        this.myDateTo = dateTo;
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        RlogCommand command = new RlogCommand();
        command.setModuleName(this.myModule);
        command.setHeadersOnly(false);
        command.setNoTags(false);
        command.setDateFrom(DATE_FORMAT.format(this.myDateFrom));
        if (this.myDateTo != null) {
            command.setDateTo(DATE_FORMAT.format(this.myDateTo));
        }
        if (ourDoNotSupportingSOptionServers.contains(root.getCvsRootAsString())) {
            command.setSuppressEmptyHeaders(false);
        }
        return command;
    }

    public static void doesNotSuppressEmptyHeaders(CvsEnvironment root) {
        ourDoNotSupportingSOptionServers.add(root.getCvsRootAsString());
    }

    @Override
    @NonNls
    protected String getOperationName() {
        return "rlog";
    }

    @Override
    public void fileInfoGenerated(Object info) {
        super.fileInfoGenerated(info);
        if (info instanceof LogInformation) {
            LogInformation logInfo = (LogInformation)info;
            LogInformationWrapper wrapper = LogInformationWrapper.wrap(this.myEnvironment.getRepository(), logInfo);
            if (wrapper != null) {
                this.myLog.add(wrapper);
                this.wrapperAdded(wrapper);
            }
        }
    }

    protected void wrapperAdded(LogInformationWrapper wrapper) {
    }

    @Override
    public boolean runInReadThread() {
        return false;
    }

    @Override
    protected boolean runInExclusiveLock() {
        return false;
    }
}

