/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CvsResultEx
implements CvsResult {
    private final List<VcsException> myErrors = new ArrayList<VcsException>();
    private final List<VcsException> myWarnings = new ArrayList<VcsException>();
    private boolean myIsCanceled = false;

    @Override
    public void setIsCanceled() {
        this.myIsCanceled = true;
    }

    @Override
    public List<VcsException> getErrors() {
        return this.myErrors;
    }

    @Override
    public List<VcsException> getWarnings() {
        return this.myWarnings;
    }

    @Override
    public boolean isCanceled() {
        return this.myIsCanceled;
    }

    @Override
    public void addAllErrors(Collection<VcsException> errors) {
        this.myErrors.addAll(errors);
    }

    @Override
    public void addAllWarnings(Collection<VcsException> warnings) {
        this.myWarnings.addAll(warnings);
    }

    @Override
    public boolean hasNoErrors() {
        return this.myErrors.isEmpty();
    }

    @Override
    public VcsException composeError() {
        return this.myErrors.iterator().next();
    }

    @Override
    public void addError(VcsException error) {
        this.myErrors.add(error);
    }

    @Override
    public List<VcsException> getErrorsAndWarnings() {
        ArrayList<VcsException> result = new ArrayList<VcsException>();
        result.addAll(this.myErrors);
        for (VcsException vcsException : this.myWarnings) {
            vcsException.setIsWarning(true);
        }
        result.addAll(this.myWarnings);
        return result;
    }

    public boolean finishedUnsuccessfully(boolean shouldBeLoggedIn, CvsHandler handler) {
        this.checkIsCanceled(handler);
        if (!this.hasNoErrors()) {
            return true;
        }
        return this.isCanceled();
    }

    private void checkIsCanceled(CvsHandler handler) {
        if (handler.isCanceled()) {
            this.setIsCanceled();
        }
    }
}

