/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.model;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.execution.junit2.states.NotFailedState;
import com.intellij.execution.junit2.ui.TestProgress;
import com.intellij.execution.junit2.ui.model.CompletionEvent;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.StateEvent;
import com.intellij.execution.junit2.ui.model.TestTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.project.Project;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpecialNode
extends TestProxy {
    private static final String ALL_PASSED = ExecutionBundle.message((String)"junit.all.tests.passed.label", (Object[])new Object[0]);
    private static final String TESTS_IN_PROGRESS = ExecutionBundle.message((String)"junit.tests.in.progress.label", (Object[])new Object[0]);
    private final JUnitRunningModel myModel;
    private final AbstractTreeBuilder myBuilder;
    private boolean myIsVisible = false;
    private CompletionEvent myCompletionEvent;

    public SpecialNode(TestTreeBuilder treeBuilder, JUnitRunningModel model) {
        super(new MyTestInfo());
        this.myModel = model;
        this.myBuilder = treeBuilder;
        MyJUnitAdapter listener = new MyJUnitAdapter();
        this.myModel.addListener(listener);
        this.myModel.getProgress().addChangeListener(listener);
        this.setState(NotFailedState.createPassed());
    }

    public Object[] asArray() {
        return new Object[]{this};
    }

    public void setVisible(boolean isVisible) {
        if (this.myIsVisible == isVisible) {
            return;
        }
        this.myIsVisible = isVisible;
        this.updateName();
    }

    private void updateName() {
        String newName;
        if (!this.myIsVisible) {
            return;
        }
        MyTestInfo myTestInfo = (MyTestInfo)this.getInfo();
        TestProgress progress = this.myModel.getProgress();
        if (this.myCompletionEvent == null) {
            newName = TESTS_IN_PROGRESS;
        } else if (this.myCompletionEvent.isNormalExit() && progress.getValue() == progress.getMaximum()) {
            newName = ALL_PASSED;
        } else {
            switch (this.myCompletionEvent.getType()) {
                case DONE: {
                    newName = ExecutionBundle.message((String)"junit.runing.info.tests.in.progress.done.tree.node", (Object[])new Object[0]);
                    break;
                }
                default: {
                    newName = ExecutionBundle.message((String)"junit.runing.info.tests.in.progress.terminated.tre.node", (Object[])new Object[0]);
                }
            }
        }
        myTestInfo.setName(newName);
        this.myBuilder.updateFromRoot();
    }

    static /* synthetic */ String access$100() {
        return TESTS_IN_PROGRESS;
    }

    private class MyJUnitAdapter
    extends JUnitAdapter
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            if (SpecialNode.this.myCompletionEvent != null) {
                SpecialNode.this.updateName();
            }
        }

        @Override
        public void onRunnerStateChanged(StateEvent event) {
            if (!event.isRunning()) {
                SpecialNode.this.myCompletionEvent = (CompletionEvent)event;
                SpecialNode.this.updateName();
            }
        }
    }

    private static class MyTestInfo
    extends TestInfo {
        private String myName = SpecialNode.access$100();

        private MyTestInfo() {
        }

        @Override
        public String getComment() {
            return "";
        }

        @Override
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        @Override
        public boolean shouldRun() {
            return false;
        }

        @Override
        public int getTestsCount() {
            return 0;
        }

        @Override
        public void readFrom(ObjectReader reader) {
        }

        @Override
        public Location getLocation(Project project) {
            return null;
        }
    }
}

