/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.doc;

import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntFilesProvider;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.psi.impl.reference.AntElementCompletionWrapper;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AntDocumentationProvider
implements DocumentationProvider {
    @NonNls
    private static final String CORE_TASKS_FOLDER_NAME = "CoreTasks";
    @NonNls
    private static final String CORE_TYPES_FOLDER_NAME = "CoreTypes";
    @NonNls
    private static final String OPTIONAL_TYPES_FOLDER_NAME = "OptionalTypes";
    @NonNls
    private static final String OPTIONAL_TASKS_FOLDER_NAME = "OptionalTasks";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        String mainDoc = AntDocumentationProvider.getMainDocumentation(element);
        String additionalDoc = AntDocumentationProvider.getAdditionalDocumentation(element);
        if (mainDoc == null && additionalDoc == null) {
            return null;
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            if (additionalDoc != null) {
                builder.append(additionalDoc);
            }
            if (mainDoc != null) {
                builder.append(mainDoc);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Nullable
    private static String getMainDocumentation(PsiElement elem) {
        if (!(elem instanceof AntElement)) {
            return null;
        }
        VirtualFile helpFile = AntDocumentationProvider.getHelpFile(elem);
        if (helpFile != null) {
            try {
                return VfsUtil.loadText((VirtualFile)helpFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getAdditionalDocumentation(PsiElement elem) {
        List<File> list;
        if (!(elem instanceof AntElement)) {
            return null;
        }
        AntElement antElement = (AntElement)elem;
        if (antElement instanceof AntFilesProvider && (list = ((AntFilesProvider)((Object)antElement)).getFiles(new HashSet<AntFilesProvider>())).size() > 0) {
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                XmlElement srcElement = antElement.getSourceElement();
                if (srcElement instanceof XmlTag) {
                    builder.append("<b>");
                    builder.append(((XmlTag)srcElement).getName());
                    builder.append(":</b>");
                }
                for (File file : list) {
                    if (builder.length() > 0) {
                        builder.append("<br>");
                    }
                    builder.append(file.getPath());
                }
                String string = builder.toString();
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile getHelpFile(PsiElement element) {
        String url;
        if (!(element instanceof AntElement)) {
            return null;
        }
        AntElement antElement = (AntElement)element;
        AntFile antFile = antElement.getAntFile();
        if (antFile == null) {
            return null;
        }
        AntFile originalFile = (AntFile)antFile.getOriginalFile();
        AntInstallation installation = originalFile.getAntInstallation();
        if (installation == null) {
            return null;
        }
        String antHomeDir = (String)AntInstallation.HOME_DIR.get(installation.getProperties());
        if (antHomeDir == null) {
            return null;
        }
        String path = antHomeDir + "/docs/manual";
        if (new File(path).exists()) {
            url = VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)path));
        } else {
            path = antHomeDir + "/docs.zip";
            if (new File(path).exists()) {
                url = VirtualFileManager.constructUrl((String)"jar", (String)(FileUtil.toSystemIndependentName((String)path) + "!/" + "docs/manual"));
            } else {
                return null;
            }
        }
        VirtualFile documentationRoot = VirtualFileManager.getInstance().findFileByUrl(url);
        if (documentationRoot == null) {
            return null;
        }
        return AntDocumentationProvider.getHelpFile(antElement, documentationRoot);
    }

    @Nullable
    private static VirtualFile getHelpFile(AntElement antElement, VirtualFile documentationRoot) {
        String helpFileShortName;
        if (antElement instanceof AntElementCompletionWrapper) {
            String name = ((AntElementCompletionWrapper)antElement).getName();
            if (name == null) {
                return null;
            }
            helpFileShortName = "/" + name.trim() + ".html";
        } else {
            XmlElement xmlElement = antElement.getSourceElement();
            if (!(xmlElement instanceof XmlTag)) {
                return null;
            }
            XmlTag xmlTag = (XmlTag)xmlElement;
            helpFileShortName = "/" + xmlTag.getName() + ".html";
        }
        VirtualFile candidateHelpFile = documentationRoot.findFileByRelativePath(CORE_TASKS_FOLDER_NAME + helpFileShortName);
        if (candidateHelpFile != null) {
            return candidateHelpFile;
        }
        candidateHelpFile = documentationRoot.findFileByRelativePath(OPTIONAL_TASKS_FOLDER_NAME + helpFileShortName);
        if (candidateHelpFile != null) {
            return candidateHelpFile;
        }
        candidateHelpFile = documentationRoot.findFileByRelativePath(CORE_TYPES_FOLDER_NAME + helpFileShortName);
        if (candidateHelpFile != null) {
            return candidateHelpFile;
        }
        candidateHelpFile = documentationRoot.findFileByRelativePath(OPTIONAL_TYPES_FOLDER_NAME + helpFileShortName);
        if (candidateHelpFile != null) {
            return candidateHelpFile;
        }
        if ((AntElementRole.TARGET_ROLE.equals((Object)antElement.getRole()) || AntElementRole.PROJECT_ROLE.equals((Object)antElement.getRole())) && (candidateHelpFile = documentationRoot.findFileByRelativePath("using.html")) != null) {
            return candidateHelpFile;
        }
        return null;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element) {
        String description;
        if (element instanceof AntTarget && (description = ((AntTarget)element).getDescription()) != null && description.length() > 0) {
            return description;
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        VirtualFile helpFile = AntDocumentationProvider.getHelpFile(originalElement);
        if (helpFile == null || !(helpFile.getFileSystem() instanceof LocalFileSystem)) {
            return null;
        }
        return Collections.singletonList(helpFile.getUrl());
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }
}

