/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.AntLanguageExtension;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.psi.changes.AntChangeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeSet;
import com.intellij.pom.xml.XmlChangeVisitor;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.psi.xml.XmlFile;

public class AntProjectComponent
extends AbstractProjectComponent {
    public AntProjectComponent(final XmlAspect xmlAspect, PomModel pomModel, Project project) {
        super(project);
        pomModel.addModelListener(new PomModelListener(){

            public void modelChanged(PomModelEvent event) {
                PomChangeSet changeSet = event.getChangeSet((PomModelAspect)xmlAspect);
                if (changeSet instanceof XmlChangeSet) {
                    XmlChangeSet xmlChangeSet = (XmlChangeSet)changeSet;
                    for (XmlFile file : xmlChangeSet.getChangedFiles()) {
                        if (file == null || !AntLanguageExtension.isAntFile(file)) continue;
                        AntChangeVisitor visitor = AntSupport.getChangeVisitor();
                        for (XmlChange change : xmlChangeSet.getChanges()) {
                            change.accept((XmlChangeVisitor)visitor);
                        }
                    }
                }
            }

            public boolean isAspectChangeInteresting(PomModelAspect aspect) {
                return aspect == xmlAspect;
            }
        }, (Disposable)project);
    }
}

