/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileType
extends LanguageFileType {
    public static final Icon FILE_ICON = IconLoader.getIcon((String)"/fileTypes/properties.png");
    public static final LanguageFileType FILE_TYPE = new PropertiesFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "properties";
    @NonNls
    public static final String DOT_DEFAULT_EXTENSION = ".properties";

    private PropertiesFileType() {
        super((Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("Properties" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesFileType.getName must not return null");
        }
        return "Properties";
    }

    @NotNull
    public String getDescription() {
        String string = PropertiesBundle.message("properties.files.file.type.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesFileType.getDescription must not return null");
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesFileType.getDefaultExtension must not return null");
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return FILE_ICON;
    }

    public String getCharset(@NotNull VirtualFile file, byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertiesFileType.getCharset must not be null");
        }
        Charset charset = EncodingManager.getInstance().getDefaultCharsetForPropertiesFiles(file);
        String defaultCharsetName = charset == null ? CharsetToolkit.getDefaultSystemCharset().name() : charset.name();
        return defaultCharsetName;
    }
}

