/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.lw.FontDescriptor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.BorderTypeEditor;
import com.intellij.uiDesigner.propertyInspector.editors.ColorEditor;
import com.intellij.uiDesigner.propertyInspector.editors.FontEditor;
import com.intellij.uiDesigner.propertyInspector.editors.IntEnumEditor;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditor;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractInsetsProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.ColorRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.FontRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.IntEnumRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.StringRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.shared.BorderType;
import java.awt.Insets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BorderProperty
extends Property<RadContainer, BorderType> {
    @NonNls
    public static final String NAME = "border";
    private final Project myProject;
    private final Property[] myChildren;
    private final NotNullLazyValue<PropertyRenderer<BorderType>> myRenderer = new NotNullLazyValue<PropertyRenderer<BorderType>>(){

        @NotNull
        protected PropertyRenderer<BorderType> compute() {
            LabelPropertyRenderer<BorderType> labelPropertyRenderer = new LabelPropertyRenderer<BorderType>(){

                @Override
                protected void customize(@NotNull BorderType value) {
                    if (value == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$1$1.customize must not be null");
                    }
                    this.setText(value.getName());
                }
            };
            if (labelPropertyRenderer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$1.compute must not return null");
            }
            return labelPropertyRenderer;
        }
    };
    private static final IntEnumEditor.Pair[] ourJustificationPairs = new IntEnumEditor.Pair[]{new IntEnumEditor.Pair(0, UIDesignerBundle.message("property.default", new Object[0])), new IntEnumEditor.Pair(1, UIDesignerBundle.message("property.left", new Object[0])), new IntEnumEditor.Pair(2, UIDesignerBundle.message("property.center", new Object[0])), new IntEnumEditor.Pair(3, UIDesignerBundle.message("property.right", new Object[0])), new IntEnumEditor.Pair(4, UIDesignerBundle.message("property.leading", new Object[0])), new IntEnumEditor.Pair(5, UIDesignerBundle.message("property.trailing", new Object[0]))};
    private static final IntEnumEditor.Pair[] ourPositionPairs = new IntEnumEditor.Pair[]{new IntEnumEditor.Pair(0, UIDesignerBundle.message("property.default", new Object[0])), new IntEnumEditor.Pair(1, UIDesignerBundle.message("property.above.top", new Object[0])), new IntEnumEditor.Pair(2, UIDesignerBundle.message("property.top", new Object[0])), new IntEnumEditor.Pair(3, UIDesignerBundle.message("property.below.top", new Object[0])), new IntEnumEditor.Pair(4, UIDesignerBundle.message("property.above.bottom", new Object[0])), new IntEnumEditor.Pair(5, UIDesignerBundle.message("property.bottom", new Object[0])), new IntEnumEditor.Pair(6, UIDesignerBundle.message("property.below.bottom", new Object[0]))};

    public BorderProperty(Project project) {
        super(null, NAME);
        this.myProject = project;
        this.myChildren = new Property[]{new MyTypeProperty(), new MyTitleProperty(), new MyTitleIntEnumProperty(this, "title justification", true), new MyTitleIntEnumProperty(this, "title position", false), new MyTitleFontProperty(this), new MyBorderColorProperty((Property)this, true)};
    }

    @Override
    public BorderType getValue(RadContainer component) {
        return component.getBorderType();
    }

    @Override
    protected void setValueImpl(RadContainer component, BorderType value) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Property[] getChildren(RadComponent component) {
        Property[] propertyArray;
        if (!(component instanceof RadContainer)) {
            propertyArray = Property.EMPTY_ARRAY;
            if (Property.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty.getChildren must not return null");
            return propertyArray;
        }
        BorderType borderType = ((RadContainer)component).getBorderType();
        if (borderType.equals((Object)BorderType.EMPTY)) {
            propertyArray = new Property[]{new MyTypeProperty(), new MySizeProperty(this), new MyTitleProperty(), new MyTitleIntEnumProperty(this, "title justification", true), new MyTitleIntEnumProperty(this, "title position", false), new MyTitleFontProperty(this), new MyBorderColorProperty((Property)this, true)};
            if (propertyArray == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty.getChildren must not return null");
            return propertyArray;
        }
        if (borderType.equals((Object)BorderType.LINE)) {
            propertyArray = new Property[]{new MyTypeProperty(), new MyBorderColorProperty((Property)this, false), new MyTitleProperty(), new MyTitleIntEnumProperty(this, "title justification", true), new MyTitleIntEnumProperty(this, "title position", false), new MyTitleFontProperty(this), new MyBorderColorProperty((Property)this, true)};
            if (propertyArray == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty.getChildren must not return null");
            return propertyArray;
        }
        propertyArray = this.myChildren;
        if (this.myChildren != null) return propertyArray;
        throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty.getChildren must not return null");
    }

    @Override
    @NotNull
    public PropertyRenderer<BorderType> getRenderer() {
        PropertyRenderer propertyRenderer = (PropertyRenderer)this.myRenderer.getValue();
        if (propertyRenderer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty.getRenderer must not return null");
        }
        return propertyRenderer;
    }

    @Override
    public PropertyEditor<BorderType> getEditor() {
        return null;
    }

    @Override
    public boolean isModified(RadContainer component) {
        return !component.getBorderType().equals((Object)BorderType.NONE) || component.getBorderTitle() != null;
    }

    @Override
    public void resetValue(RadContainer component) throws Exception {
        component.setBorderType(BorderType.NONE);
        component.setBorderTitle(null);
    }

    private static class MySizeProperty
    extends AbstractInsetsProperty<RadContainer> {
        public MySizeProperty(Property parent) {
            super(parent, "size");
        }

        @Override
        public Insets getValue(RadContainer container) {
            return container.getBorderSize();
        }

        @Override
        protected void setValueImpl(RadContainer container, Insets insets) throws Exception {
            container.setBorderSize(insets);
        }
    }

    private static class MyBorderColorProperty
    extends Property<RadContainer, ColorDescriptor> {
        private ColorRenderer myRenderer;
        private ColorEditor myEditor;
        private final boolean myTitleColor;

        public MyBorderColorProperty(Property parent, boolean titleColor) {
            super(parent, titleColor ? "title color" : "color");
            this.myTitleColor = titleColor;
        }

        @Override
        public ColorDescriptor getValue(RadContainer component) {
            return this.myTitleColor ? component.getBorderTitleColor() : component.getBorderColor();
        }

        @Override
        protected void setValueImpl(RadContainer component, ColorDescriptor value) throws Exception {
            if (this.myTitleColor) {
                component.setBorderTitleColor(value);
            } else {
                component.setBorderColor(value);
            }
        }

        @Override
        @NotNull
        public PropertyRenderer<ColorDescriptor> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new ColorRenderer();
            }
            ColorRenderer colorRenderer = this.myRenderer;
            if (colorRenderer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyBorderColorProperty.getRenderer must not return null");
            }
            return colorRenderer;
        }

        @Override
        public PropertyEditor<ColorDescriptor> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new ColorEditor(this.myTitleColor ? UIDesignerBundle.message("border.title.editor.title", new Object[0]) : UIDesignerBundle.message("border.color.editor.title", new Object[0]));
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return this.getValue(component) != null;
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            this.setValueImpl(component, null);
        }
    }

    private static class MyTitleFontProperty
    extends Property<RadContainer, FontDescriptor> {
        private FontRenderer myRenderer;
        private FontEditor myEditor;

        public MyTitleFontProperty(Property parent) {
            super(parent, "title font");
        }

        @Override
        public FontDescriptor getValue(RadContainer component) {
            return component.getBorderTitleFont();
        }

        @Override
        protected void setValueImpl(RadContainer component, FontDescriptor value) throws Exception {
            component.setBorderTitleFont(value);
        }

        @Override
        @NotNull
        public PropertyRenderer<FontDescriptor> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new FontRenderer();
            }
            FontRenderer fontRenderer = this.myRenderer;
            if (fontRenderer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyTitleFontProperty.getRenderer must not return null");
            }
            return fontRenderer;
        }

        @Override
        public PropertyEditor<FontDescriptor> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new FontEditor(UIDesignerBundle.message("border.title.editor.title", new Object[0]));
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return component.getBorderTitleFont() != null;
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            component.setBorderTitleFont(null);
        }
    }

    private static class MyTitleIntEnumProperty
    extends Property<RadContainer, Integer> {
        private IntEnumRenderer myRenderer;
        private IntEnumEditor myEditor;
        private final boolean myJustification;

        public MyTitleIntEnumProperty(Property parent, @NonNls String name, boolean isJustification) {
            super(parent, name);
            this.myJustification = isJustification;
        }

        @Override
        public Integer getValue(RadContainer component) {
            return this.myJustification ? component.getBorderTitleJustification() : component.getBorderTitlePosition();
        }

        @Override
        protected void setValueImpl(RadContainer component, Integer value) throws Exception {
            if (this.myJustification) {
                component.setBorderTitleJustification(value);
            } else {
                component.setBorderTitlePosition(value);
            }
        }

        @Override
        @NotNull
        public PropertyRenderer<Integer> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new IntEnumRenderer(this.myJustification ? ourJustificationPairs : ourPositionPairs);
            }
            IntEnumRenderer intEnumRenderer = this.myRenderer;
            if (intEnumRenderer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyTitleIntEnumProperty.getRenderer must not return null");
            }
            return intEnumRenderer;
        }

        @Override
        public PropertyEditor<Integer> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new IntEnumEditor(this.myJustification ? ourJustificationPairs : ourPositionPairs);
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return this.getValue(component) != 0;
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            this.setValue(component, 0);
        }
    }

    private final class MyTitleProperty
    extends Property<RadContainer, StringDescriptor> {
        private StringRenderer myRenderer;
        private StringEditor myEditor;

        public MyTitleProperty() {
            super(BorderProperty.this, "title");
        }

        @Override
        public StringDescriptor getValue(RadContainer component) {
            StringDescriptor descriptor = component.getBorderTitle();
            String resolvedValue = StringDescriptorManager.getInstance(component.getModule()).resolve(component, descriptor);
            if (descriptor != null) {
                descriptor.setResolvedValue(resolvedValue);
            }
            return descriptor;
        }

        @Override
        protected void setValueImpl(RadContainer component, StringDescriptor value) throws Exception {
            StringDescriptor title = value;
            if (title != null && StringDescriptorManager.getInstance(component.getModule()).resolve(component, title).length() == 0) {
                title = null;
            }
            component.setBorderTitle(title);
        }

        @Override
        @NotNull
        public PropertyRenderer<StringDescriptor> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new StringRenderer();
            }
            StringRenderer stringRenderer = this.myRenderer;
            if (stringRenderer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyTitleProperty.getRenderer must not return null");
            }
            return stringRenderer;
        }

        @Override
        public PropertyEditor<StringDescriptor> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new StringEditor(BorderProperty.this.myProject);
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return this.getValue(component) != null;
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            component.setBorderTitle(null);
        }
    }

    private final class MyTypeProperty
    extends Property<RadContainer, BorderType> {
        BorderTypeEditor myEditor;

        public MyTypeProperty() {
            super(BorderProperty.this, "type");
        }

        @Override
        public BorderType getValue(RadContainer component) {
            return component.getBorderType();
        }

        @Override
        protected void setValueImpl(RadContainer component, BorderType value) throws Exception {
            component.setBorderType(value);
        }

        @Override
        @NotNull
        public PropertyRenderer<BorderType> getRenderer() {
            PropertyRenderer propertyRenderer = (PropertyRenderer)BorderProperty.this.myRenderer.getValue();
            if (propertyRenderer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyTypeProperty.getRenderer must not return null");
            }
            return propertyRenderer;
        }

        @Override
        public PropertyEditor<BorderType> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new BorderTypeEditor();
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return !this.getValue(component).equals((Object)BorderType.NONE);
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            this.setValueImpl(component, BorderType.NONE);
        }

        @Override
        public boolean needRefreshPropertyList() {
            return true;
        }
    }
}

