/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadSplitPane;
import com.intellij.uiDesigner.radComponents.RadTabbedPane;
import com.intellij.uiDesigner.shared.XYLayoutManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;

public class SurroundAction
extends AbstractGuiEditorAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.SurroundAction");
    private final String myComponentClass;

    public SurroundAction(String componentClass) {
        String className = componentClass.substring(componentClass.lastIndexOf(46) + 1);
        this.getTemplatePresentation().setText(className);
        this.myComponentClass = componentClass;
    }

    @Override
    public void actionPerformed(final GuiEditor editor, final List<RadComponent> selection, AnActionEvent e) {
        FormEditingUtil.remapToActionTargets(selection);
        if (!editor.ensureEditable()) {
            return;
        }
        final RadContainer selectionParent = FormEditingUtil.getSelectionParent(selection);
        assert (selectionParent != null);
        final Palette palette = Palette.getInstance(editor.getProject());
        final ComponentItem cItem = palette.getItem(this.myComponentClass);
        assert (cItem != null);
        CommandProcessor.getInstance().executeCommand(editor.getProject(), new Runnable(){

            @Override
            public void run() {
                RadContainer newContainer = (RadContainer)InsertComponentProcessor.createInsertedComponent(editor, cItem);
                if (newContainer == null) {
                    return;
                }
                if (cItem == palette.getPanelItem()) {
                    if (selectionParent.getLayoutManager().isGrid()) {
                        try {
                            newContainer.setLayoutManager(LayoutManagerRegistry.createLayoutManager(selectionParent.getLayoutManager().getName()));
                        }
                        catch (Exception e1) {
                            LOG.error((Throwable)e1);
                            return;
                        }
                    } else {
                        newContainer.setLayoutManager(LayoutManagerRegistry.createDefaultGridLayoutManager(editor.getProject()));
                    }
                }
                Rectangle rc = new Rectangle(0, 0, 1, 1);
                int minIndex = Integer.MAX_VALUE;
                if (selectionParent.getLayoutManager().isGrid()) {
                    rc = FormEditingUtil.getSelectionBounds(selection);
                } else if (selectionParent.getLayoutManager().isIndexed()) {
                    for (RadComponent c : selection) {
                        minIndex = Math.min(minIndex, selectionParent.indexOfComponent(c));
                    }
                }
                for (RadComponent c : selection) {
                    selectionParent.removeComponent(c);
                }
                if (selectionParent.getLayoutManager().isGrid()) {
                    GridConstraints newConstraints = newContainer.getConstraints();
                    newConstraints.setRow(rc.y);
                    newConstraints.setColumn(rc.x);
                    newConstraints.setRowSpan(rc.height);
                    newConstraints.setColSpan(rc.width);
                } else if (selectionParent.getLayout() instanceof XYLayoutManager && selection.size() == 1) {
                    newContainer.setBounds(((RadComponent)selection.get(0)).getBounds());
                }
                if (selection.size() == 1) {
                    newContainer.setCustomLayoutConstraints(((RadComponent)selection.get(0)).getCustomLayoutConstraints());
                }
                if (minIndex != Integer.MAX_VALUE) {
                    selectionParent.addComponent(newContainer, minIndex);
                } else {
                    selectionParent.addComponent(newContainer);
                }
                if (newContainer instanceof RadTabbedPane) {
                    assert (newContainer.getComponentCount() == 1);
                    newContainer = (RadContainer)newContainer.getComponent(0);
                } else if (newContainer instanceof RadSplitPane) {
                    if (selection.size() > 2) {
                        RadContainer panel = InsertComponentProcessor.createPanelComponent(editor);
                        panel.setCustomLayoutConstraints("left");
                        newContainer.addComponent(panel);
                        newContainer = panel;
                    } else {
                        if (selection.size() > 0) {
                            ((RadComponent)selection.get(0)).setCustomLayoutConstraints("left");
                        }
                        if (selection.size() > 1) {
                            ((RadComponent)selection.get(1)).setCustomLayoutConstraints("right");
                        }
                    }
                }
                if (newContainer.getComponentClass().equals(JPanel.class) && selection.size() > 1) {
                    if (selectionParent.getLayoutManager().isGrid()) {
                        newContainer.getGridLayoutManager().copyGridSection(selectionParent, newContainer, rc);
                    } else {
                        newContainer.setLayout((LayoutManager)new GridLayoutManager(rc.height, rc.width));
                    }
                }
                for (RadComponent c : selection) {
                    if (selectionParent.getLayoutManager().isGrid()) {
                        if (selection.size() > 1) {
                            c.getConstraints().setRow(c.getConstraints().getRow() - rc.y);
                            c.getConstraints().setColumn(c.getConstraints().getColumn() - rc.x);
                        } else {
                            c.getConstraints().setRow(0);
                            c.getConstraints().setColumn(0);
                            c.getConstraints().setRowSpan(1);
                            c.getConstraints().setColSpan(1);
                        }
                    }
                    newContainer.addComponent(c);
                }
                editor.refreshAndSave(true);
            }
        }, null, null);
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/actions/SurroundAction.update must not be null");
        }
        FormEditingUtil.remapToActionTargets(selection);
        RadContainer selectionParent = FormEditingUtil.getSelectionParent(selection);
        e.getPresentation().setEnabled(selectionParent != null && (!selectionParent.getLayoutManager().isGrid() && selection.size() == 1 || SurroundAction.isSelectionContiguous(selectionParent, selection)) && this.canWrapSelection(selection));
    }

    private boolean canWrapSelection(ArrayList<RadComponent> selection) {
        if (this.myComponentClass.equals(JScrollPane.class.getName())) {
            if (selection.size() > 1) {
                return false;
            }
            RadComponent component = selection.get(0);
            return component.getDelegee() instanceof Scrollable;
        }
        return true;
    }

    private static boolean isSelectionContiguous(RadContainer selectionParent, ArrayList<RadComponent> selection) {
        if (!selectionParent.getLayoutManager().isGrid()) {
            return false;
        }
        Rectangle rc = FormEditingUtil.getSelectionBounds(selection);
        for (RadComponent c : selectionParent.getComponents()) {
            if (selection.contains(c) || !SurroundAction.constraintsIntersect(true, c.getConstraints(), rc) || !SurroundAction.constraintsIntersect(false, c.getConstraints(), rc)) continue;
            return false;
        }
        return true;
    }

    private static boolean constraintsIntersect(boolean horizontal, GridConstraints constraints, Rectangle rc) {
        int start = constraints.getCell(!horizontal);
        int end = start + constraints.getSpan(!horizontal) - 1;
        int otherStart = horizontal ? rc.x : rc.y;
        int otherEnd = otherStart + (horizontal ? rc.width : rc.height) - 1;
        return start <= otherEnd && otherStart <= end;
    }
}

