/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.quickFixes.ChangeFieldTypeFix;
import com.intellij.uiDesigner.quickFixes.CreateClassToBindFix;
import com.intellij.uiDesigner.quickFixes.CreateFieldFix;
import com.intellij.uiDesigner.quickFixes.FormInspectionTool;
import com.intellij.uiDesigner.quickFixes.GenerateCreateComponentsFix;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.ButtonGroup;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorAnalyzer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.ErrorAnalyzer");
    @NonNls
    public static final String CLIENT_PROP_CLASS_TO_BIND_ERROR = "classToBindError";
    @NonNls
    public static final String CLIENT_PROP_BINDING_ERROR = "bindingError";
    @NonNls
    public static final String CLIENT_PROP_ERROR_ARRAY = "errorArray";

    private ErrorAnalyzer() {
    }

    public static void analyzeErrors(GuiEditor editor, IRootContainer rootContainer, @Nullable ProgressIndicator progress) {
        ErrorAnalyzer.analyzeErrors(editor.getModule(), editor.getFile(), editor, rootContainer, progress);
    }

    public static void analyzeErrors(final @NotNull Module module, @NotNull VirtualFile formFile, final @Nullable GuiEditor editor, final @NotNull IRootContainer rootContainer, final @Nullable ProgressIndicator progress) {
        PsiClass psiClass;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/ErrorAnalyzer.analyzeErrors must not be null");
        }
        if (formFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/ErrorAnalyzer.analyzeErrors must not be null");
        }
        if (rootContainer == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/uiDesigner/ErrorAnalyzer.analyzeErrors must not be null");
        }
        String classToBind = rootContainer.getClassToBind();
        if (classToBind != null) {
            psiClass = FormEditingUtil.findClassToBind(module, classToBind);
            if (psiClass == null) {
                QuickFix[] quickFixArray;
                if (editor != null) {
                    QuickFix[] quickFixArray2 = new QuickFix[1];
                    quickFixArray = quickFixArray2;
                    quickFixArray2[0] = new CreateClassToBindFix(editor, classToBind);
                } else {
                    quickFixArray = QuickFix.EMPTY_ARRAY;
                }
                QuickFix[] fixes = quickFixArray;
                ErrorInfo errorInfo = new ErrorInfo(null, null, UIDesignerBundle.message("error.class.does.not.exist", classToBind), HighlightDisplayLevel.ERROR, fixes);
                rootContainer.putClientProperty((Object)CLIENT_PROP_CLASS_TO_BIND_ERROR, (Object)errorInfo);
            } else {
                rootContainer.putClientProperty((Object)CLIENT_PROP_CLASS_TO_BIND_ERROR, null);
            }
        } else {
            psiClass = null;
        }
        final ArrayList usedBindings = new ArrayList();
        HashSet processedGroups = new HashSet();
        FormEditingUtil.iterate((IComponent)rootContainer, new FormEditingUtil.ComponentVisitor<IComponent>((Set)processedGroups){
            final /* synthetic */ Set val$processedGroups;
            {
                this.val$processedGroups = set;
            }

            @Override
            public boolean visit(IComponent component) {
                IButtonGroup group;
                if (progress != null && progress.isCanceled()) {
                    return false;
                }
                component.putClientProperty((Object)ErrorAnalyzer.CLIENT_PROP_BINDING_ERROR, null);
                String binding = component.getBinding();
                if (psiClass != null && binding != null && ErrorAnalyzer.validateFieldInClass(component, binding, component.getComponentClassName(), psiClass, editor, module)) {
                    return true;
                }
                if (binding != null) {
                    if (usedBindings.contains(binding)) {
                        component.putClientProperty((Object)ErrorAnalyzer.CLIENT_PROP_BINDING_ERROR, (Object)new ErrorInfo(component, null, UIDesignerBundle.message("error.binding.already.exists", binding), HighlightDisplayLevel.ERROR, QuickFix.EMPTY_ARRAY));
                        return true;
                    }
                    usedBindings.add(binding);
                }
                if ((group = FormEditingUtil.findGroupForComponent(rootContainer, component)) != null && !this.val$processedGroups.contains(group)) {
                    this.val$processedGroups.add(group);
                    if (group.isBound()) {
                        ErrorAnalyzer.validateFieldInClass(component, group.getName(), ButtonGroup.class.getName(), psiClass, editor, module);
                    }
                }
                return true;
            }
        });
        if (progress != null) {
            progress.checkCanceled();
        }
        FormEditingUtil.iterate((IComponent)rootContainer, new FormEditingUtil.ComponentVisitor<IComponent>(){

            @Override
            public boolean visit(IComponent component) {
                if (progress != null && progress.isCanceled()) {
                    return false;
                }
                component.putClientProperty((Object)ErrorAnalyzer.CLIENT_PROP_ERROR_ARRAY, null);
                if (!(component instanceof IContainer)) {
                    return true;
                }
                IContainer container = (IContainer)component;
                if (container instanceof IRootContainer) {
                    IRootContainer rootContainer = (IRootContainer)container;
                    if (rootContainer.getComponentCount() > 1) {
                        ErrorAnalyzer.putError(component, new ErrorInfo(component, null, UIDesignerBundle.message("error.multiple.toplevel.components", new Object[0]), HighlightDisplayLevel.ERROR, QuickFix.EMPTY_ARRAY));
                    }
                } else if (container.isXY() && container.getComponentCount() > 0) {
                    ErrorAnalyzer.putError(component, new ErrorInfo(component, null, UIDesignerBundle.message("error.panel.not.laid.out", new Object[0]), HighlightDisplayLevel.ERROR, QuickFix.EMPTY_ARRAY));
                }
                return true;
            }
        });
        if (progress != null) {
            progress.checkCanceled();
        }
        try {
            PsiFile formPsiFile = PsiManager.getInstance((Project)module.getProject()).findFile(formFile);
            if (formPsiFile != null && rootContainer instanceof RadRootContainer) {
                FormInspectionTool[] registeredFormInspections;
                final ArrayList<FormInspectionTool> formInspectionTools = new ArrayList<FormInspectionTool>();
                for (FormInspectionTool formInspectionTool : registeredFormInspections = (FormInspectionTool[])Extensions.getExtensions(FormInspectionTool.EP_NAME)) {
                    if (!formInspectionTool.isActive((PsiElement)formPsiFile) || rootContainer.isInspectionSuppressed(formInspectionTool.getShortName(), null)) continue;
                    formInspectionTools.add(formInspectionTool);
                }
                if (formInspectionTools.size() > 0 && editor != null) {
                    for (FormInspectionTool tool : formInspectionTools) {
                        tool.startCheckForm(rootContainer);
                    }
                    FormEditingUtil.iterate((IComponent)rootContainer, new FormEditingUtil.ComponentVisitor<RadComponent>(){

                        @Override
                        public boolean visit(RadComponent component) {
                            if (progress != null && progress.isCanceled()) {
                                return false;
                            }
                            for (FormInspectionTool tool : formInspectionTools) {
                                ErrorInfo[] errorInfos;
                                if (rootContainer.isInspectionSuppressed(tool.getShortName(), component.getId()) || (errorInfos = tool.checkComponent(editor, component)) == null) continue;
                                ArrayList errorList = ErrorAnalyzer.getErrorInfos(component);
                                if (errorList == null) {
                                    errorList = new ArrayList();
                                    component.putClientProperty(ErrorAnalyzer.CLIENT_PROP_ERROR_ARRAY, errorList);
                                }
                                Collections.addAll(errorList, errorInfos);
                            }
                            return true;
                        }
                    });
                    for (FormInspectionTool tool : formInspectionTools) {
                        tool.doneCheckForm(rootContainer);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean validateFieldInClass(IComponent component, String fieldName, String fieldClassName, PsiClass psiClass, GuiEditor editor, Module module) {
        PsiField[] fields = psiClass.getFields();
        PsiField field = null;
        for (int i = fields.length - 1; i >= 0; --i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            field = fields[i];
            break;
        }
        if (field == null) {
            QuickFix[] quickFixArray;
            if (editor != null) {
                QuickFix[] quickFixArray2 = new QuickFix[1];
                quickFixArray = quickFixArray2;
                quickFixArray2[0] = new CreateFieldFix(editor, psiClass, fieldClassName, fieldName);
            } else {
                quickFixArray = QuickFix.EMPTY_ARRAY;
            }
            QuickFix[] fixes = quickFixArray;
            component.putClientProperty((Object)CLIENT_PROP_BINDING_ERROR, (Object)new ErrorInfo(component, null, UIDesignerBundle.message("error.no.field.in.class", fieldName, psiClass.getQualifiedName()), HighlightDisplayLevel.ERROR, fixes));
            return true;
        }
        if (field.hasModifierProperty("static")) {
            component.putClientProperty((Object)CLIENT_PROP_BINDING_ERROR, (Object)new ErrorInfo(component, null, UIDesignerBundle.message("error.cant.bind.to.static", fieldName), HighlightDisplayLevel.ERROR, QuickFix.EMPTY_ARRAY));
            return true;
        }
        try {
            String className = fieldClassName.replace('$', '.');
            PsiType componentType = JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createTypeFromText(className, null);
            PsiType fieldType = field.getType();
            if (!fieldType.isAssignableFrom(componentType)) {
                QuickFix[] quickFixArray;
                if (editor != null) {
                    QuickFix[] quickFixArray3 = new QuickFix[1];
                    quickFixArray = quickFixArray3;
                    quickFixArray3[0] = new ChangeFieldTypeFix(editor, field, componentType);
                } else {
                    quickFixArray = QuickFix.EMPTY_ARRAY;
                }
                QuickFix[] fixes = quickFixArray;
                component.putClientProperty((Object)CLIENT_PROP_BINDING_ERROR, (Object)new ErrorInfo(component, null, UIDesignerBundle.message("error.bind.incompatible.types", fieldType.getPresentableText(), className), HighlightDisplayLevel.ERROR, fixes));
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            // empty catch block
        }
        if (component.isCustomCreate() && FormEditingUtil.findCreateComponentsMethod(psiClass) == null) {
            QuickFix[] quickFixArray;
            if (editor != null) {
                QuickFix[] quickFixArray4 = new QuickFix[1];
                quickFixArray = quickFixArray4;
                quickFixArray4[0] = new GenerateCreateComponentsFix(editor, psiClass);
            } else {
                quickFixArray = QuickFix.EMPTY_ARRAY;
            }
            QuickFix[] fixes = quickFixArray;
            component.putClientProperty((Object)CLIENT_PROP_BINDING_ERROR, (Object)new ErrorInfo(component, "Custom Create", UIDesignerBundle.message("error.no.custom.create.method", new Object[0]), HighlightDisplayLevel.ERROR, fixes));
            return true;
        }
        return false;
    }

    private static void putError(IComponent component, ErrorInfo errorInfo) {
        ArrayList<ErrorInfo> errorList = ErrorAnalyzer.getErrorInfos(component);
        if (errorList == null) {
            errorList = new ArrayList();
            component.putClientProperty((Object)CLIENT_PROP_ERROR_ARRAY, errorList);
        }
        errorList.add(errorInfo);
    }

    @Nullable
    public static ErrorInfo getErrorForComponent(@NotNull IComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/ErrorAnalyzer.getErrorForComponent must not be null");
        }
        ArrayList<ErrorInfo> errorInfo = (ErrorInfo)component.getClientProperty((Object)CLIENT_PROP_CLASS_TO_BIND_ERROR);
        if (errorInfo != null) {
            return errorInfo;
        }
        ErrorInfo error = (ErrorInfo)component.getClientProperty((Object)CLIENT_PROP_BINDING_ERROR);
        if (error != null) {
            return error;
        }
        errorInfo = ErrorAnalyzer.getErrorInfos(component);
        if (errorInfo != null && errorInfo.size() > 0) {
            return (ErrorInfo)errorInfo.get(0);
        }
        return null;
    }

    @NotNull
    public static ErrorInfo[] getAllErrorsForComponent(@NotNull IComponent component) {
        ArrayList<ErrorInfo> errorInfos;
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/ErrorAnalyzer.getAllErrorsForComponent must not be null");
        }
        ArrayList<ErrorInfo> result = new ArrayList<ErrorInfo>();
        ErrorInfo errorInfo = (ErrorInfo)component.getClientProperty((Object)CLIENT_PROP_CLASS_TO_BIND_ERROR);
        if (errorInfo != null) {
            result.add(errorInfo);
        }
        if ((errorInfo = (ErrorInfo)component.getClientProperty((Object)CLIENT_PROP_BINDING_ERROR)) != null) {
            result.add(errorInfo);
        }
        if ((errorInfos = ErrorAnalyzer.getErrorInfos(component)) != null) {
            result.addAll(errorInfos);
        }
        ErrorInfo[] errorInfoArray = result.toArray(new ErrorInfo[result.size()]);
        if (errorInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/ErrorAnalyzer.getAllErrorsForComponent must not return null");
        }
        return errorInfoArray;
    }

    private static ArrayList<ErrorInfo> getErrorInfos(IComponent component) {
        return (ArrayList)component.getClientProperty((Object)CLIENT_PROP_ERROR_ARRAY);
    }

    @Nullable
    public static HighlightDisplayLevel getHighlightDisplayLevel(Project project, RadComponent component) {
        HighlightDisplayLevel displayLevel = null;
        for (ErrorInfo errInfo : ErrorAnalyzer.getAllErrorsForComponent(component)) {
            if (displayLevel != null && SeverityRegistrar.getInstance((Project)project).compare(errInfo.getHighlightDisplayLevel().getSeverity(), displayLevel.getSeverity()) <= 0) continue;
            displayLevel = errInfo.getHighlightDisplayLevel();
        }
        return displayLevel;
    }
}

