/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.DoWhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceDoWhileLoopWithWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        DoWhileLoopPredicate doWhileLoopPredicate = new DoWhileLoopPredicate();
        if (doWhileLoopPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/whileloop/ReplaceDoWhileLoopWithWhileLoopIntention.getElementPredicate must not return null");
        }
        return doWhileLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/whileloop/ReplaceDoWhileLoopWithWhileLoopIntention.processIntention must not be null");
        }
        PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)element.getParent();
        if (doWhileStatement == null) {
            return;
        }
        PsiStatement body = doWhileStatement.getBody();
        PsiElement parent = doWhileStatement.getParent();
        StringBuilder whileStatementText = new StringBuilder("while(");
        PsiExpression condition = doWhileStatement.getCondition();
        if (condition != null) {
            whileStatementText.append(condition.getText());
        }
        whileStatementText.append(')');
        if (body instanceof PsiBlockStatement) {
            whileStatementText.append('{');
            PsiBlockStatement blockStatement = (PsiBlockStatement)body;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                for (int i = 1; i < children.length - 1; ++i) {
                    PsiElement child = children[i];
                    parent.addBefore(child, (PsiElement)doWhileStatement);
                    if (child instanceof PsiDeclarationStatement) {
                        PsiElement[] declaredElements;
                        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)child;
                        for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                            PsiVariable variable;
                            PsiExpression initializer;
                            if (!(declaredElement instanceof PsiVariable) || (initializer = (variable = (PsiVariable)declaredElement).getInitializer()) == null) continue;
                            String name = variable.getName();
                            whileStatementText.append(name);
                            whileStatementText.append(" = ");
                            whileStatementText.append(initializer.getText());
                            whileStatementText.append(';');
                        }
                        continue;
                    }
                    whileStatementText.append(child.getText());
                }
            }
            whileStatementText.append('}');
        } else if (body != null) {
            parent.addBefore((PsiElement)body, (PsiElement)doWhileStatement);
            whileStatementText.append(body.getText());
        }
        ReplaceDoWhileLoopWithWhileLoopIntention.replaceStatement(whileStatementText.toString(), (PsiStatement)doWhileStatement);
    }
}

