/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceChecker {
    private static final int THIS_EXPRESSION = 0;
    private static final int LITERAL_EXPRESSION = 1;
    private static final int CLASS_OBJECT_EXPRESSION = 2;
    private static final int REFERENCE_EXPRESSION = 3;
    private static final int SUPER_EXPRESSION = 4;
    private static final int METHOD_CALL_EXPRESSION = 5;
    private static final int NEW_EXPRESSION = 6;
    private static final int ARRAY_INITIALIZER_EXPRESSION = 7;
    private static final int TYPECAST_EXPRESSION = 8;
    private static final int ARRAY_ACCESS_EXPRESSION = 9;
    private static final int PREFIX_EXPRESSION = 10;
    private static final int POSTFIX_EXPRESSION = 11;
    private static final int BINARY_EXPRESSION = 12;
    private static final int CONDITIONAL_EXPRESSION = 13;
    private static final int ASSIGNMENT_EXPRESSION = 14;
    private static final int ASSERT_STATEMENT = 0;
    private static final int BLOCK_STATEMENT = 1;
    private static final int BREAK_STATEMENT = 2;
    private static final int CONTINUE_STATEMENT = 3;
    private static final int DECLARATION_STATEMENT = 4;
    private static final int DO_WHILE_STATEMENT = 5;
    private static final int EMPTY_STATEMENT = 6;
    private static final int EXPRESSION_LIST_STATEMENT = 7;
    private static final int EXPRESSION_STATEMENT = 8;
    private static final int FOR_STATEMENT = 9;
    private static final int IF_STATEMENT = 10;
    private static final int LABELED_STATEMENT = 11;
    private static final int RETURN_STATEMENT = 12;
    private static final int SWITCH_LABEL_STATEMENT = 13;
    private static final int SWITCH_STATEMENT = 14;
    private static final int SYNCHRONIZED_STATEMENT = 15;
    private static final int THROW_STATEMENT = 16;
    private static final int TRY_STATEMENT = 17;
    private static final int WHILE_STATEMENT = 18;
    private static final int FOR_EACH_STATEMENT = 19;

    private EquivalenceChecker() {
    }

    public static boolean modifierListsAreEquivalent(@Nullable PsiModifierList list1, @Nullable PsiModifierList list2) {
        PsiAnnotation[] annotations;
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        for (PsiAnnotation annotation : annotations = list1.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            if (list2.findAnnotation(qualifiedName) != null) continue;
            return false;
        }
        if (list1.hasModifierProperty("abstract") && !list2.hasModifierProperty("abstract")) {
            return false;
        }
        if (list1.hasModifierProperty("final") && !list2.hasModifierProperty("final")) {
            return false;
        }
        if (list1.hasModifierProperty("native") && !list2.hasModifierProperty("native")) {
            return false;
        }
        if (list1.hasModifierProperty("packageLocal") && !list2.hasModifierProperty("packageLocal")) {
            return false;
        }
        if (list1.hasModifierProperty("private") && !list2.hasModifierProperty("private")) {
            return false;
        }
        if (list1.hasModifierProperty("protected") && !list2.hasModifierProperty("protected")) {
            return false;
        }
        if (list1.hasModifierProperty("public") && !list2.hasModifierProperty("public")) {
            return false;
        }
        if (list1.hasModifierProperty("static") && !list2.hasModifierProperty("static")) {
            return false;
        }
        if (list1.hasModifierProperty("strictfp") && !list2.hasModifierProperty("strictfp")) {
            return false;
        }
        if (list1.hasModifierProperty("synchronized") && !list2.hasModifierProperty("synchronized")) {
            return false;
        }
        if (list1.hasModifierProperty("transient") && !list2.hasModifierProperty("transient")) {
            return false;
        }
        return !list1.hasModifierProperty("volatile") || list2.hasModifierProperty("volatile");
    }

    public static boolean statementsAreEquivalent(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        int type2;
        if (statement1 == null && statement2 == null) {
            return true;
        }
        if (statement1 == null || statement2 == null) {
            return false;
        }
        int type1 = EquivalenceChecker.getStatementType(statement1);
        if (type1 != (type2 = EquivalenceChecker.getStatementType(statement2))) {
            return false;
        }
        switch (type1) {
            case 0: {
                return EquivalenceChecker.assertStatementsAreEquivalent((PsiAssertStatement)statement1, (PsiAssertStatement)statement2);
            }
            case 1: {
                return EquivalenceChecker.blockStatementsAreEquivalent((PsiBlockStatement)statement1, (PsiBlockStatement)statement2);
            }
            case 2: {
                return EquivalenceChecker.breakStatementsAreEquivalent((PsiBreakStatement)statement1, (PsiBreakStatement)statement2);
            }
            case 3: {
                return EquivalenceChecker.continueStatementsAreEquivalent((PsiContinueStatement)statement1, (PsiContinueStatement)statement2);
            }
            case 4: {
                return EquivalenceChecker.declarationStatementsAreEquivalent((PsiDeclarationStatement)statement1, (PsiDeclarationStatement)statement2);
            }
            case 5: {
                return EquivalenceChecker.doWhileStatementsAreEquivalent((PsiDoWhileStatement)statement1, (PsiDoWhileStatement)statement2);
            }
            case 6: {
                return true;
            }
            case 7: {
                return EquivalenceChecker.expressionListStatementsAreEquivalent((PsiExpressionListStatement)statement1, (PsiExpressionListStatement)statement2);
            }
            case 8: {
                return EquivalenceChecker.expressionStatementsAreEquivalent((PsiExpressionStatement)statement1, (PsiExpressionStatement)statement2);
            }
            case 9: {
                return EquivalenceChecker.forStatementsAreEquivalent((PsiForStatement)statement1, (PsiForStatement)statement2);
            }
            case 19: {
                return EquivalenceChecker.forEachStatementsAreEquivalent((PsiForeachStatement)statement1, (PsiForeachStatement)statement2);
            }
            case 10: {
                return EquivalenceChecker.ifStatementsAreEquivalent((PsiIfStatement)statement1, (PsiIfStatement)statement2);
            }
            case 11: {
                return EquivalenceChecker.labeledStatementsAreEquivalent((PsiLabeledStatement)statement1, (PsiLabeledStatement)statement2);
            }
            case 12: {
                return EquivalenceChecker.returnStatementsAreEquivalent((PsiReturnStatement)statement1, (PsiReturnStatement)statement2);
            }
            case 13: {
                return EquivalenceChecker.switchLabelStatementsAreEquivalent((PsiSwitchLabelStatement)statement1, (PsiSwitchLabelStatement)statement2);
            }
            case 14: {
                return EquivalenceChecker.switchStatementsAreEquivalent((PsiSwitchStatement)statement1, (PsiSwitchStatement)statement2);
            }
            case 15: {
                return EquivalenceChecker.synchronizedStatementsAreEquivalent((PsiSynchronizedStatement)statement1, (PsiSynchronizedStatement)statement2);
            }
            case 16: {
                return EquivalenceChecker.throwStatementsAreEquivalent((PsiThrowStatement)statement1, (PsiThrowStatement)statement2);
            }
            case 17: {
                return EquivalenceChecker.tryStatementsAreEquivalent((PsiTryStatement)statement1, (PsiTryStatement)statement2);
            }
            case 18: {
                return EquivalenceChecker.whileStatementsAreEquivalent((PsiWhileStatement)statement1, (PsiWhileStatement)statement2);
            }
        }
        String text1 = statement1.getText();
        String text2 = statement2.getText();
        return text1.equals(text2);
    }

    private static boolean declarationStatementsAreEquivalent(@NotNull PsiDeclarationStatement statement1, @NotNull PsiDeclarationStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.declarationStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.declarationStatementsAreEquivalent must not be null");
        }
        PsiElement[] elements1 = statement1.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars1 = new ArrayList<PsiLocalVariable>(elements1.length);
        for (PsiElement anElement : elements1) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars1.add((PsiLocalVariable)anElement);
        }
        PsiElement[] elements2 = statement2.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars2 = new ArrayList<PsiLocalVariable>(elements2.length);
        for (PsiElement anElement : elements2) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars2.add((PsiLocalVariable)anElement);
        }
        int size = vars1.size();
        if (size != vars2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            PsiLocalVariable var2;
            PsiLocalVariable var1 = (PsiLocalVariable)vars1.get(i);
            if (EquivalenceChecker.localVariableAreEquivalent(var1, var2 = (PsiLocalVariable)vars2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean localVariableAreEquivalent(@NotNull PsiLocalVariable localVariable1, @NotNull PsiLocalVariable localVariable2) {
        PsiType type2;
        if (localVariable1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.localVariableAreEquivalent must not be null");
        }
        if (localVariable2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.localVariableAreEquivalent must not be null");
        }
        PsiType type1 = localVariable1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = localVariable2.getType())) {
            return false;
        }
        String name1 = localVariable1.getName();
        String name2 = localVariable2.getName();
        if (name1 == null) {
            return name2 == null;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        PsiExpression initializer1 = localVariable1.getInitializer();
        PsiExpression initializer2 = localVariable2.getInitializer();
        return EquivalenceChecker.expressionsAreEquivalent(initializer1, initializer2);
    }

    private static boolean tryStatementsAreEquivalent(@NotNull PsiTryStatement statement1, @NotNull PsiTryStatement statement2) {
        PsiParameter[] catchParameters2;
        PsiCodeBlock[] catchBlocks2;
        PsiCodeBlock finallyBlock2;
        PsiCodeBlock tryBlock2;
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.tryStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.tryStatementsAreEquivalent must not be null");
        }
        PsiCodeBlock tryBlock1 = statement1.getTryBlock();
        if (!EquivalenceChecker.codeBlocksAreEquivalent(tryBlock1, tryBlock2 = statement2.getTryBlock())) {
            return false;
        }
        PsiCodeBlock finallyBlock1 = statement1.getFinallyBlock();
        if (!EquivalenceChecker.codeBlocksAreEquivalent(finallyBlock1, finallyBlock2 = statement2.getFinallyBlock())) {
            return false;
        }
        PsiCodeBlock[] catchBlocks1 = statement1.getCatchBlocks();
        if (catchBlocks1.length != (catchBlocks2 = statement2.getCatchBlocks()).length) {
            return false;
        }
        for (int i = 0; i < catchBlocks2.length; ++i) {
            if (EquivalenceChecker.codeBlocksAreEquivalent(catchBlocks1[i], catchBlocks2[i])) continue;
            return false;
        }
        PsiParameter[] catchParameters1 = statement1.getCatchBlockParameters();
        if (catchParameters1.length != (catchParameters2 = statement2.getCatchBlockParameters()).length) {
            return false;
        }
        for (int i = 0; i < catchParameters2.length; ++i) {
            if (EquivalenceChecker.parametersAreEquivalent(catchParameters2[i], catchParameters1[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean parametersAreEquivalent(@NotNull PsiParameter parameter1, @NotNull PsiParameter parameter2) {
        PsiType type2;
        if (parameter1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.parametersAreEquivalent must not be null");
        }
        if (parameter2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.parametersAreEquivalent must not be null");
        }
        PsiType type1 = parameter1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = parameter2.getType())) {
            return false;
        }
        String name1 = parameter1.getName();
        String name2 = parameter2.getName();
        if (name1 == null) {
            return name2 == null;
        }
        return name1.equals(name2);
    }

    private static boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        String type1Text = type1.getCanonicalText();
        String type2Text = type2.getCanonicalText();
        return type1Text.equals(type2Text);
    }

    private static boolean whileStatementsAreEquivalent(@NotNull PsiWhileStatement statement1, @NotNull PsiWhileStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.whileStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.whileStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forStatementsAreEquivalent(@NotNull PsiForStatement statement1, @NotNull PsiForStatement statement2) {
        PsiStatement update2;
        PsiStatement initialization2;
        PsiExpression condition2;
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.forStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.forStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getCondition();
        if (!EquivalenceChecker.expressionsAreEquivalent(condition1, condition2 = statement2.getCondition())) {
            return false;
        }
        PsiStatement initialization1 = statement1.getInitialization();
        if (!EquivalenceChecker.statementsAreEquivalent(initialization1, initialization2 = statement2.getInitialization())) {
            return false;
        }
        PsiStatement update1 = statement1.getUpdate();
        if (!EquivalenceChecker.statementsAreEquivalent(update1, update2 = statement2.getUpdate())) {
            return false;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forEachStatementsAreEquivalent(@NotNull PsiForeachStatement statement1, @NotNull PsiForeachStatement statement2) {
        PsiExpression value2;
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.forEachStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.forEachStatementsAreEquivalent must not be null");
        }
        PsiExpression value1 = statement1.getIteratedValue();
        if (!EquivalenceChecker.expressionsAreEquivalent(value1, value2 = statement2.getIteratedValue())) {
            return false;
        }
        PsiParameter parameter1 = statement1.getIterationParameter();
        PsiParameter parameter2 = statement1.getIterationParameter();
        String name1 = parameter1.getName();
        if (name1 == null) {
            return parameter2.getName() == null;
        }
        if (!name1.equals(parameter2.getName())) {
            return false;
        }
        PsiType type1 = parameter1.getType();
        if (!type1.equals(parameter2.getType())) {
            return false;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean switchStatementsAreEquivalent(@NotNull PsiSwitchStatement statement1, @NotNull PsiSwitchStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.switchStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.switchStatementsAreEquivalent must not be null");
        }
        PsiExpression switchExpression1 = statement1.getExpression();
        PsiExpression swithcExpression2 = statement2.getExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(switchExpression1, swithcExpression2) && EquivalenceChecker.codeBlocksAreEquivalent(body1, body2);
    }

    private static boolean doWhileStatementsAreEquivalent(@NotNull PsiDoWhileStatement statement1, @NotNull PsiDoWhileStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.doWhileStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.doWhileStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean assertStatementsAreEquivalent(@NotNull PsiAssertStatement statement1, @NotNull PsiAssertStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.assertStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.assertStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getAssertCondition();
        PsiExpression condition2 = statement2.getAssertCondition();
        PsiExpression description1 = statement1.getAssertDescription();
        PsiExpression description2 = statement2.getAssertDescription();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(description1, description2);
    }

    private static boolean synchronizedStatementsAreEquivalent(@NotNull PsiSynchronizedStatement statement1, @NotNull PsiSynchronizedStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.synchronizedStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.synchronizedStatementsAreEquivalent must not be null");
        }
        PsiExpression lock1 = statement1.getLockExpression();
        PsiExpression lock2 = statement2.getLockExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(lock1, lock2) && EquivalenceChecker.codeBlocksAreEquivalent(body1, body2);
    }

    private static boolean blockStatementsAreEquivalent(@NotNull PsiBlockStatement statement1, @NotNull PsiBlockStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.blockStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.blockStatementsAreEquivalent must not be null");
        }
        PsiCodeBlock block1 = statement1.getCodeBlock();
        PsiCodeBlock block2 = statement2.getCodeBlock();
        return EquivalenceChecker.codeBlocksAreEquivalent(block1, block2);
    }

    private static boolean breakStatementsAreEquivalent(@NotNull PsiBreakStatement statement1, @NotNull PsiBreakStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.breakStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.breakStatementsAreEquivalent must not be null");
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    private static boolean continueStatementsAreEquivalent(@NotNull PsiContinueStatement statement1, @NotNull PsiContinueStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.continueStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.continueStatementsAreEquivalent must not be null");
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    private static boolean switchLabelStatementsAreEquivalent(@NotNull PsiSwitchLabelStatement statement1, @NotNull PsiSwitchLabelStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.switchLabelStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.switchLabelStatementsAreEquivalent must not be null");
        }
        if (statement1.isDefaultCase()) {
            return statement2.isDefaultCase();
        }
        if (statement2.isDefaultCase()) {
            return false;
        }
        PsiExpression caseExpression1 = statement1.getCaseValue();
        PsiExpression caseExpression2 = statement2.getCaseValue();
        return EquivalenceChecker.expressionsAreEquivalent(caseExpression1, caseExpression2);
    }

    private static boolean labeledStatementsAreEquivalent(@NotNull PsiLabeledStatement statement1, @NotNull PsiLabeledStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.labeledStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.labeledStatementsAreEquivalent must not be null");
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    public static boolean codeBlocksAreEquivalent(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        if (block1 == null && block2 == null) {
            return true;
        }
        if (block1 == null || block2 == null) {
            return false;
        }
        PsiStatement[] statements1 = block1.getStatements();
        PsiStatement[] statements2 = block2.getStatements();
        if (statements2.length != statements1.length) {
            return false;
        }
        for (int i = 0; i < statements2.length; ++i) {
            if (EquivalenceChecker.statementsAreEquivalent(statements2[i], statements1[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean ifStatementsAreEquivalent(@NotNull PsiIfStatement statement1, @NotNull PsiIfStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.ifStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.ifStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement thenBranch1 = statement1.getThenBranch();
        PsiStatement thenBranch2 = statement2.getThenBranch();
        PsiStatement elseBranch1 = statement1.getElseBranch();
        PsiStatement elseBranch2 = statement2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(thenBranch1, thenBranch2) && EquivalenceChecker.statementsAreEquivalent(elseBranch1, elseBranch2);
    }

    private static boolean expressionStatementsAreEquivalent(@NotNull PsiExpressionStatement statement1, @NotNull PsiExpressionStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.expressionStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.expressionStatementsAreEquivalent must not be null");
        }
        PsiExpression expression1 = statement1.getExpression();
        PsiExpression expression2 = statement2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalent(expression1, expression2);
    }

    private static boolean returnStatementsAreEquivalent(@NotNull PsiReturnStatement statement1, @NotNull PsiReturnStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.returnStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.returnStatementsAreEquivalent must not be null");
        }
        PsiExpression returnValue1 = statement1.getReturnValue();
        PsiExpression returnValue2 = statement2.getReturnValue();
        return EquivalenceChecker.expressionsAreEquivalent(returnValue1, returnValue2);
    }

    private static boolean throwStatementsAreEquivalent(@NotNull PsiThrowStatement statement1, @NotNull PsiThrowStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.throwStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.throwStatementsAreEquivalent must not be null");
        }
        PsiExpression exception1 = statement1.getException();
        PsiExpression exception2 = statement2.getException();
        return EquivalenceChecker.expressionsAreEquivalent(exception1, exception2);
    }

    private static boolean expressionListStatementsAreEquivalent(@NotNull PsiExpressionListStatement statement1, @NotNull PsiExpressionListStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.expressionListStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.expressionListStatementsAreEquivalent must not be null");
        }
        PsiExpressionList expressionList1 = statement1.getExpressionList();
        PsiExpression[] expressions1 = expressionList1.getExpressions();
        PsiExpressionList expressionList2 = statement2.getExpressionList();
        PsiExpression[] expressions2 = expressionList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(expressions1, expressions2);
    }

    public static boolean expressionsAreEquivalent(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        int type2;
        if (expression1 == null && expression2 == null) {
            return true;
        }
        if (expression1 == null || expression2 == null) {
            return false;
        }
        PsiExpression expToCompare1 = expression1;
        while (expToCompare1 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expToCompare1;
            expToCompare1 = parenthesizedExpression.getExpression();
        }
        PsiExpression expToCompare2 = expression2;
        while (expToCompare2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expToCompare2;
            expToCompare2 = parenthesizedExpression.getExpression();
        }
        if (expToCompare1 == null && expToCompare2 == null) {
            return true;
        }
        if (expToCompare1 == null || expToCompare2 == null) {
            return false;
        }
        int type1 = EquivalenceChecker.getExpressionType(expToCompare1);
        if (type1 != (type2 = EquivalenceChecker.getExpressionType(expToCompare2))) {
            return false;
        }
        switch (type1) {
            case 0: 
            case 4: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: {
                String text1 = expToCompare1.getText();
                String text2 = expToCompare2.getText();
                return text1.equals(text2);
            }
            case 5: {
                return EquivalenceChecker.methodCallExpressionsAreEquivalent((PsiMethodCallExpression)expToCompare1, (PsiMethodCallExpression)expToCompare2);
            }
            case 6: {
                return EquivalenceChecker.newExpressionsAreEquivalent((PsiNewExpression)expToCompare1, (PsiNewExpression)expToCompare2);
            }
            case 7: {
                return EquivalenceChecker.arrayInitializerExpressionsAreEquivalent((PsiArrayInitializerExpression)expToCompare1, (PsiArrayInitializerExpression)expToCompare2);
            }
            case 8: {
                return EquivalenceChecker.typecastExpressionsAreEquivalent((PsiTypeCastExpression)expToCompare2, (PsiTypeCastExpression)expToCompare1);
            }
            case 9: {
                return EquivalenceChecker.arrayAccessExpressionsAreEquivalent((PsiArrayAccessExpression)expToCompare2, (PsiArrayAccessExpression)expToCompare1);
            }
            case 10: {
                return EquivalenceChecker.prefixExpressionsAreEquivalent((PsiPrefixExpression)expToCompare1, (PsiPrefixExpression)expToCompare2);
            }
            case 11: {
                return EquivalenceChecker.postfixExpressionsAreEquivalent((PsiPostfixExpression)expToCompare1, (PsiPostfixExpression)expToCompare2);
            }
            case 12: {
                return EquivalenceChecker.binaryExpressionsAreEquivalent((PsiBinaryExpression)expToCompare1, (PsiBinaryExpression)expToCompare2);
            }
            case 14: {
                return EquivalenceChecker.assignmentExpressionsAreEquivalent((PsiAssignmentExpression)expToCompare1, (PsiAssignmentExpression)expToCompare2);
            }
            case 13: {
                return EquivalenceChecker.conditionalExpressionsAreEquivalent((PsiConditionalExpression)expToCompare1, (PsiConditionalExpression)expToCompare2);
            }
        }
        return false;
    }

    private static boolean methodCallExpressionsAreEquivalent(@NotNull PsiMethodCallExpression methodCallExpression1, @NotNull PsiMethodCallExpression methodCallExpression2) {
        PsiReferenceExpression methodExpression2;
        if (methodCallExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.methodCallExpressionsAreEquivalent must not be null");
        }
        if (methodCallExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.methodCallExpressionsAreEquivalent must not be null");
        }
        PsiReferenceExpression methodExpression1 = methodCallExpression1.getMethodExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent((PsiExpression)methodExpression1, (PsiExpression)(methodExpression2 = methodCallExpression2.getMethodExpression()))) {
            return false;
        }
        PsiExpressionList argumentList1 = methodCallExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1.getExpressions();
        PsiExpressionList argumentList2 = methodCallExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static boolean newExpressionsAreEquivalent(@NotNull PsiNewExpression newExpression1, @NotNull PsiNewExpression newExpression2) {
        PsiExpression qualifier2;
        PsiArrayInitializerExpression arrayInitializer2;
        PsiExpression[] arrayDimensions2;
        if (newExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.newExpressionsAreEquivalent must not be null");
        }
        if (newExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.newExpressionsAreEquivalent must not be null");
        }
        PsiJavaCodeReferenceElement classReference1 = newExpression1.getClassReference();
        PsiJavaCodeReferenceElement classReference2 = newExpression2.getClassReference();
        if (classReference1 == null || classReference2 == null) {
            return false;
        }
        String text = classReference1.getText();
        if (!text.equals(classReference2.getText())) {
            return false;
        }
        PsiExpression[] arrayDimensions1 = newExpression1.getArrayDimensions();
        if (!EquivalenceChecker.expressionListsAreEquivalent(arrayDimensions1, arrayDimensions2 = newExpression2.getArrayDimensions())) {
            return false;
        }
        PsiArrayInitializerExpression arrayInitializer1 = newExpression1.getArrayInitializer();
        if (!EquivalenceChecker.expressionsAreEquivalent((PsiExpression)arrayInitializer1, (PsiExpression)(arrayInitializer2 = newExpression2.getArrayInitializer()))) {
            return false;
        }
        PsiExpression qualifier1 = newExpression1.getQualifier();
        if (!EquivalenceChecker.expressionsAreEquivalent(qualifier1, qualifier2 = newExpression2.getQualifier())) {
            return false;
        }
        PsiExpressionList argumentList1 = newExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1 == null ? null : argumentList1.getExpressions();
        PsiExpressionList argumentList2 = newExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2 == null ? null : argumentList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static boolean arrayInitializerExpressionsAreEquivalent(@NotNull PsiArrayInitializerExpression arrayInitializerExpression1, @NotNull PsiArrayInitializerExpression arrayInitializerExpression2) {
        if (arrayInitializerExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.arrayInitializerExpressionsAreEquivalent must not be null");
        }
        if (arrayInitializerExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.arrayInitializerExpressionsAreEquivalent must not be null");
        }
        PsiExpression[] initializers1 = arrayInitializerExpression1.getInitializers();
        PsiExpression[] initializers2 = arrayInitializerExpression2.getInitializers();
        return EquivalenceChecker.expressionListsAreEquivalent(initializers1, initializers2);
    }

    private static boolean typecastExpressionsAreEquivalent(@NotNull PsiTypeCastExpression typeCastExpression1, @NotNull PsiTypeCastExpression typeCastExpression2) {
        if (typeCastExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.typecastExpressionsAreEquivalent must not be null");
        }
        if (typeCastExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.typecastExpressionsAreEquivalent must not be null");
        }
        PsiTypeElement castType2 = typeCastExpression1.getCastType();
        PsiTypeElement castType1 = typeCastExpression2.getCastType();
        if (castType1 == null && castType2 == null) {
            return true;
        }
        if (castType1 == null || castType2 == null) {
            return false;
        }
        if (!castType2.equals(castType1)) {
            return false;
        }
        PsiExpression operand1 = typeCastExpression2.getOperand();
        PsiExpression operand2 = typeCastExpression1.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean arrayAccessExpressionsAreEquivalent(@NotNull PsiArrayAccessExpression arrayAccessExpression1, @NotNull PsiArrayAccessExpression arrayAccessExpression2) {
        if (arrayAccessExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.arrayAccessExpressionsAreEquivalent must not be null");
        }
        if (arrayAccessExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.arrayAccessExpressionsAreEquivalent must not be null");
        }
        PsiExpression arrayExpression2 = arrayAccessExpression1.getArrayExpression();
        PsiExpression arrayExpression1 = arrayAccessExpression2.getArrayExpression();
        PsiExpression indexExpression2 = arrayAccessExpression1.getIndexExpression();
        PsiExpression indexExpression1 = arrayAccessExpression2.getIndexExpression();
        return EquivalenceChecker.expressionsAreEquivalent(arrayExpression2, arrayExpression1) && EquivalenceChecker.expressionsAreEquivalent(indexExpression2, indexExpression1);
    }

    private static boolean prefixExpressionsAreEquivalent(@NotNull PsiPrefixExpression prefixExpression1, @NotNull PsiPrefixExpression prefixExpression2) {
        if (prefixExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.prefixExpressionsAreEquivalent must not be null");
        }
        if (prefixExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.prefixExpressionsAreEquivalent must not be null");
        }
        PsiJavaToken sign1 = prefixExpression1.getOperationSign();
        PsiJavaToken sign2 = prefixExpression2.getOperationSign();
        IElementType tokenType1 = sign1.getTokenType();
        if (!tokenType1.equals(sign2.getTokenType())) {
            return false;
        }
        PsiExpression operand1 = prefixExpression1.getOperand();
        PsiExpression operand2 = prefixExpression2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean postfixExpressionsAreEquivalent(@NotNull PsiPostfixExpression postfixExpression1, @NotNull PsiPostfixExpression postfixExpression2) {
        if (postfixExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.postfixExpressionsAreEquivalent must not be null");
        }
        if (postfixExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.postfixExpressionsAreEquivalent must not be null");
        }
        PsiJavaToken sign1 = postfixExpression1.getOperationSign();
        PsiJavaToken sign2 = postfixExpression2.getOperationSign();
        IElementType tokenType1 = sign1.getTokenType();
        if (!tokenType1.equals(sign2.getTokenType())) {
            return false;
        }
        PsiExpression operand1 = postfixExpression1.getOperand();
        PsiExpression operand2 = postfixExpression2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean binaryExpressionsAreEquivalent(@NotNull PsiBinaryExpression binaryExpression1, @NotNull PsiBinaryExpression binaryExpression2) {
        if (binaryExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.binaryExpressionsAreEquivalent must not be null");
        }
        if (binaryExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.binaryExpressionsAreEquivalent must not be null");
        }
        PsiJavaToken sign1 = binaryExpression1.getOperationSign();
        PsiJavaToken sign2 = binaryExpression2.getOperationSign();
        IElementType tokenType1 = sign1.getTokenType();
        if (!tokenType1.equals(sign2.getTokenType())) {
            return false;
        }
        PsiExpression lhs1 = binaryExpression1.getLOperand();
        PsiExpression lhs2 = binaryExpression2.getLOperand();
        PsiExpression rhs1 = binaryExpression1.getROperand();
        PsiExpression rhs2 = binaryExpression2.getROperand();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean assignmentExpressionsAreEquivalent(@NotNull PsiAssignmentExpression assignmentExpression1, @NotNull PsiAssignmentExpression assignmentExpression2) {
        if (assignmentExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.assignmentExpressionsAreEquivalent must not be null");
        }
        if (assignmentExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.assignmentExpressionsAreEquivalent must not be null");
        }
        PsiJavaToken sign1 = assignmentExpression1.getOperationSign();
        PsiJavaToken sign2 = assignmentExpression2.getOperationSign();
        IElementType tokenType1 = sign1.getTokenType();
        if (!tokenType1.equals(sign2.getTokenType())) {
            return false;
        }
        PsiExpression lhs1 = assignmentExpression1.getLExpression();
        PsiExpression lhs2 = assignmentExpression2.getLExpression();
        PsiExpression rhs1 = assignmentExpression1.getRExpression();
        PsiExpression rhs2 = assignmentExpression2.getRExpression();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean conditionalExpressionsAreEquivalent(@NotNull PsiConditionalExpression conditionalExpression1, @NotNull PsiConditionalExpression conditionalExpression2) {
        if (conditionalExpression1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.conditionalExpressionsAreEquivalent must not be null");
        }
        if (conditionalExpression2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/EquivalenceChecker.conditionalExpressionsAreEquivalent must not be null");
        }
        PsiExpression condition1 = conditionalExpression1.getCondition();
        PsiExpression condition2 = conditionalExpression2.getCondition();
        PsiExpression thenExpression1 = conditionalExpression1.getThenExpression();
        PsiExpression thenExpression2 = conditionalExpression2.getThenExpression();
        PsiExpression elseExpression1 = conditionalExpression1.getElseExpression();
        PsiExpression elseExpression2 = conditionalExpression2.getElseExpression();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(thenExpression1, thenExpression2) && EquivalenceChecker.expressionsAreEquivalent(elseExpression1, elseExpression2);
    }

    private static boolean expressionListsAreEquivalent(@Nullable PsiExpression[] expressions1, @Nullable PsiExpression[] expressions2) {
        if (expressions1 == null && expressions2 == null) {
            return true;
        }
        if (expressions1 == null || expressions2 == null) {
            return false;
        }
        if (expressions1.length != expressions2.length) {
            return false;
        }
        for (int i = 0; i < expressions1.length; ++i) {
            if (EquivalenceChecker.expressionsAreEquivalent(expressions1[i], expressions2[i])) continue;
            return false;
        }
        return true;
    }

    private static int getExpressionType(@Nullable PsiExpression expression) {
        if (expression instanceof PsiThisExpression) {
            return 0;
        }
        if (expression instanceof PsiLiteralExpression) {
            return 1;
        }
        if (expression instanceof PsiClassObjectAccessExpression) {
            return 2;
        }
        if (expression instanceof PsiReferenceExpression) {
            return 3;
        }
        if (expression instanceof PsiSuperExpression) {
            return 4;
        }
        if (expression instanceof PsiMethodCallExpression) {
            return 5;
        }
        if (expression instanceof PsiNewExpression) {
            return 6;
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            return 7;
        }
        if (expression instanceof PsiTypeCastExpression) {
            return 8;
        }
        if (expression instanceof PsiArrayAccessExpression) {
            return 9;
        }
        if (expression instanceof PsiPrefixExpression) {
            return 10;
        }
        if (expression instanceof PsiPostfixExpression) {
            return 11;
        }
        if (expression instanceof PsiBinaryExpression) {
            return 12;
        }
        if (expression instanceof PsiConditionalExpression) {
            return 13;
        }
        if (expression instanceof PsiAssignmentExpression) {
            return 14;
        }
        return -1;
    }

    private static int getStatementType(@Nullable PsiStatement statement) {
        if (statement instanceof PsiAssertStatement) {
            return 0;
        }
        if (statement instanceof PsiBlockStatement) {
            return 1;
        }
        if (statement instanceof PsiBreakStatement) {
            return 2;
        }
        if (statement instanceof PsiContinueStatement) {
            return 3;
        }
        if (statement instanceof PsiDeclarationStatement) {
            return 4;
        }
        if (statement instanceof PsiDoWhileStatement) {
            return 5;
        }
        if (statement instanceof PsiEmptyStatement) {
            return 6;
        }
        if (statement instanceof PsiExpressionListStatement) {
            return 7;
        }
        if (statement instanceof PsiExpressionStatement) {
            return 8;
        }
        if (statement instanceof PsiForStatement) {
            return 9;
        }
        if (statement instanceof PsiForeachStatement) {
            return 19;
        }
        if (statement instanceof PsiIfStatement) {
            return 10;
        }
        if (statement instanceof PsiLabeledStatement) {
            return 11;
        }
        if (statement instanceof PsiReturnStatement) {
            return 12;
        }
        if (statement instanceof PsiSwitchLabelStatement) {
            return 13;
        }
        if (statement instanceof PsiSwitchStatement) {
            return 14;
        }
        if (statement instanceof PsiSynchronizedStatement) {
            return 15;
        }
        if (statement instanceof PsiThrowStatement) {
            return 16;
        }
        if (statement instanceof PsiTryStatement) {
            return 17;
        }
        if (statement instanceof PsiWhileStatement) {
            return 18;
        }
        return -1;
    }
}

