/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ClassUtil;

class ConvertIntegerToHexPredicate
implements PsiElementPredicate {
    ConvertIntegerToHexPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element;
        PsiType type = expression.getType();
        if (PsiType.INT.equals(type) || PsiType.LONG.equals(type)) {
            String text = expression.getText();
            return !text.startsWith("0x") && !text.startsWith("0X");
        }
        if (PsiType.DOUBLE.equals(type) || PsiType.FLOAT.equals(type)) {
            if (!ClassUtil.classExists("javax.xml.xpath.XPath")) {
                return false;
            }
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                return false;
            }
            String text = expression.getText();
            if (text == null) {
                return false;
            }
            return !text.startsWith("0x") && !text.startsWith("0X");
        }
        return false;
    }
}

