/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.commutative;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class FlipCommutativeMethodCallPredicate
implements PsiElementPredicate {
    FlipCommutativeMethodCallPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiMethod[] methods;
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        PsiMethodCallExpression expression = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length != 1) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        String methodName = methodExpression.getReferenceName();
        PsiType callerType = qualifier.getType();
        PsiType argumentType = args[0].getType();
        if (argumentType == null || !(argumentType instanceof PsiClassType)) {
            return false;
        }
        if (callerType == null || !(callerType instanceof PsiClassType)) {
            return false;
        }
        PsiClass argumentClass = ((PsiClassType)argumentType).resolve();
        if (argumentClass == null) {
            return false;
        }
        for (PsiMethod testMethod : methods = argumentClass.findMethodsByName(methodName, true)) {
            PsiParameter parameter;
            PsiType type;
            PsiParameterList parameterList;
            PsiParameter[] parameters;
            String testMethodName = testMethod.getName();
            if (!testMethodName.equals(methodName) || (parameters = (parameterList = testMethod.getParameterList()).getParameters()).length != 1 || !(type = (parameter = parameters[0]).getType()).isAssignableFrom(callerType)) continue;
            return true;
        }
        return false;
    }
}

