/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PathUtil {
    private PathUtil() {
    }

    public static String getLocalPath(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (file.getFileSystem() instanceof JarFileSystem && file.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file.getPath());
    }

    @NotNull
    public static String getLocalPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/PathUtil.getLocalPath must not be null");
        }
        String string = FileUtil.toSystemDependentName((String)StringUtil.trimEnd((String)path, (String)"!/"));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/PathUtil.getLocalPath must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile file) {
        VirtualFile jarFile;
        VirtualFile virtualFile;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/PathUtil.getLocalFile must not be null");
        }
        if (!file.isValid()) {
            virtualFile = file;
            if (virtualFile == null) throw new IllegalStateException("@NotNull method com/intellij/util/PathUtil.getLocalFile must not return null");
            return virtualFile;
        }
        if (file.getFileSystem() instanceof JarFileSystem && (jarFile = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
            virtualFile = jarFile;
            if (virtualFile == null) throw new IllegalStateException("@NotNull method com/intellij/util/PathUtil.getLocalFile must not return null");
            return virtualFile;
        }
        virtualFile = file;
        if (virtualFile != null) return virtualFile;
        throw new IllegalStateException("@NotNull method com/intellij/util/PathUtil.getLocalFile must not return null");
    }

    public static String getJarPathForClass(Class aClass) {
        String resourceRoot = PathManager.getResourceRoot((Class)aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
        return new File(resourceRoot).getAbsoluteFile().getAbsolutePath();
    }

    public static String toPresentableUrl(String url) {
        return PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
    }

    public static String getCanonicalPath(@NonNls String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        path = path.replace(File.separatorChar, '/');
        StringTokenizer tok = new StringTokenizer(path, "/");
        Stack stack = new Stack();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("..".equals(token)) {
                if (stack.isEmpty()) {
                    return null;
                }
                stack.pop();
                continue;
            }
            if (token.length() == 0 || ".".equals(token)) continue;
            stack.push((Object)token);
        }
        StringBuilder result = new StringBuilder(path.length());
        if (path.charAt(0) == '/') {
            result.append("/");
        }
        for (int i = 0; i < stack.size(); ++i) {
            String str = (String)stack.get(i);
            if (i > 0) {
                result.append('/');
            }
            result.append(str);
        }
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getFileName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/PathUtil.getFileName must not be null");
        }
        if (path.length() == 0) {
            return "";
        }
        char c = path.charAt(path.length() - 1);
        int end = c == '/' || c == '\\' ? path.length() - 1 : path.length();
        int start = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1)) + 1;
        String string = path.substring(start, end);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/PathUtil.getFileName must not return null");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getParentPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/PathUtil.getParentPath must not be null");
        }
        if (path.length() == 0) {
            return "";
        }
        int end = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (end == path.length() - 1) {
            end = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1));
        }
        if (end == -1) {
            return "";
        }
        String string = path.substring(0, end);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/PathUtil.getParentPath must not return null");
        return string2;
    }

    public static String suggestFileName(String text) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!PathUtil.isValidFileNameChar(c) || c == '.' || Character.isWhitespace(c)) {
                result.append('_');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/PathUtil.isValidFileName must not be null");
        }
        for (int i = 0; i < fileName.length(); ++i) {
            if (PathUtil.isValidFileNameChar(fileName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidFileNameChar(char c) {
        return c != '/' && c != '\\' && c != '\t' && c != '\n' && c != '\r' && c != ':' && c != ';' && c != '*' && c != '?' && c != '\"' && c != '\'' && c != '<' && c != '>';
    }
}

