/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.impl.rules.ModuleGroupingRule;
import com.intellij.usages.impl.rules.NonCodeUsageGroupingRule;
import com.intellij.usages.impl.rules.UsageScopeGroupingRule;
import com.intellij.usages.impl.rules.UsageTypeGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.util.Icons;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class UsageGroupingRuleProviderImpl
implements UsageGroupingRuleProvider {
    @Override
    @NotNull
    public UsageGroupingRule[] getActiveRules(Project project) {
        ArrayList<UsageGroupingRule> rules = new ArrayList<UsageGroupingRule>();
        rules.add(new NonCodeUsageGroupingRule());
        if (UsageViewSettings.getInstance().GROUP_BY_SCOPE) {
            rules.add(new UsageScopeGroupingRule());
        }
        if (UsageViewSettings.getInstance().GROUP_BY_USAGE_TYPE) {
            rules.add(new UsageTypeGroupingRule());
        }
        if (UsageViewSettings.getInstance().GROUP_BY_MODULE) {
            rules.add(new ModuleGroupingRule());
        }
        if (UsageViewSettings.getInstance().GROUP_BY_PACKAGE) {
            rules.add(DirectoryGroupingRule.getInstance(project));
        }
        if (UsageViewSettings.getInstance().GROUP_BY_FILE_STRUCTURE) {
            FileStructureGroupRuleProvider[] providers;
            for (FileStructureGroupRuleProvider ruleProvider : providers = (FileStructureGroupRuleProvider[])Extensions.getExtensions(FileStructureGroupRuleProvider.EP_NAME)) {
                UsageGroupingRule rule = ruleProvider.getUsageGroupingRule(project);
                if (rule == null) continue;
                rules.add(rule);
            }
        } else {
            rules.add(new FileGroupingRule(project));
        }
        UsageGroupingRule[] usageGroupingRuleArray = rules.toArray(new UsageGroupingRule[rules.size()]);
        if (usageGroupingRuleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageGroupingRuleProviderImpl.getActiveRules must not return null");
        }
        return usageGroupingRuleArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public AnAction[] createGroupingActions(UsageView view) {
        AnAction[] anActionArray;
        UsageViewImpl impl = (UsageViewImpl)view;
        final JComponent component = impl.getComponent();
        final GroupByModuleTypeAction groupByModuleTypeAction = new GroupByModuleTypeAction(impl);
        groupByModuleTypeAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(68, 128)), component);
        final GroupByFileStructureAction groupByFileStructureAction = new GroupByFileStructureAction(impl);
        groupByFileStructureAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(77, 128)), component);
        impl.scheduleDisposeOnClose(new Disposable(){

            public void dispose() {
                groupByModuleTypeAction.unregisterCustomShortcutSet(component);
                groupByFileStructureAction.unregisterCustomShortcutSet(component);
            }
        });
        GroupByScopeAction groupByScopeAction = new GroupByScopeAction(impl);
        if (view.getPresentation().isCodeUsages()) {
            final GroupByUsageTypeAction groupByUsageTypeAction = new GroupByUsageTypeAction(impl);
            groupByUsageTypeAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(84, 128)), component);
            final GroupByPackageAction groupByPackageAction = new GroupByPackageAction(impl);
            groupByPackageAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(80, 128)), component);
            impl.scheduleDisposeOnClose(new Disposable(){

                public void dispose() {
                    groupByUsageTypeAction.unregisterCustomShortcutSet(component);
                    groupByPackageAction.unregisterCustomShortcutSet(component);
                }
            });
            anActionArray = new AnAction[]{groupByUsageTypeAction, groupByScopeAction, groupByModuleTypeAction, groupByPackageAction, groupByFileStructureAction};
            if (anActionArray == null) throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageGroupingRuleProviderImpl.createGroupingActions must not return null");
            return anActionArray;
        }
        anActionArray = new AnAction[]{groupByScopeAction, groupByModuleTypeAction, groupByFileStructureAction};
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageGroupingRuleProviderImpl.createGroupingActions must not return null");
    }

    private static class GroupByFileStructureAction
    extends RuleAction {
        private GroupByFileStructureAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.file.structure", new Object[0]), IconLoader.getIcon((String)"/actions/groupByMethod.png"));
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_FILE_STRUCTURE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_FILE_STRUCTURE = value;
        }
    }

    private static class GroupByPackageAction
    extends RuleAction {
        private GroupByPackageAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.package", new Object[0]), Icons.GROUP_BY_PACKAGES);
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_PACKAGE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_PACKAGE = value;
        }
    }

    private static class GroupByModuleTypeAction
    extends RuleAction {
        private GroupByModuleTypeAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.module", new Object[0]), IconLoader.getIcon((String)"/objectBrowser/showModules.png"));
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_MODULE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_MODULE = value;
        }
    }

    private static class GroupByScopeAction
    extends RuleAction {
        private GroupByScopeAction(UsageViewImpl view) {
            super(view, "Group by test/production", Icons.TEST_SOURCE_FOLDER);
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_SCOPE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_SCOPE = value;
        }
    }

    private static class GroupByUsageTypeAction
    extends RuleAction {
        private GroupByUsageTypeAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.usage.type", new Object[0]), IconLoader.getIcon((String)"/ant/filter.png"));
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().GROUP_BY_USAGE_TYPE;
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().GROUP_BY_USAGE_TYPE = value;
        }
    }
}

