/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class SimpleColoredComponent
extends JComponent
implements Accessible {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.SimpleColoredComponent");
    private final ArrayList<String> myFragments;
    private final ArrayList<SimpleTextAttributes> myAttributes;
    private ArrayList<Object> myFragmentTags = null;
    private Icon myIcon;
    private Insets myIpad;
    private int myIconTextGap = 2;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private final MyBorder myBorder;
    private int myMainTextLastIndex = -1;
    private int myAlignIndex;
    private int myAlignWidth;
    private boolean myIconOpaque = true;
    private boolean myAutoInvalidate = true;
    private AccessibleContext myContext = new MyAccessibleContext();

    public SimpleColoredComponent() {
        this.myFragments = new ArrayList(3);
        this.myAttributes = new ArrayList(3);
        this.myIpad = new Insets(1, 2, 1, 2);
        this.myBorder = new MyBorder();
        this.setOpaque(true);
    }

    public final void append(@NotNull String fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        SimpleColoredComponent simpleColoredComponent = this;
        synchronized (simpleColoredComponent) {
            this.myFragments.add(fragment);
            this.myAttributes.add(attributes);
            if (isMainText) {
                this.myMainTextLastIndex = this.myFragments.size() - 1;
            }
        }
        this.revalidateAndRepaint();
    }

    private void revalidateAndRepaint() {
        if (this.myAutoInvalidate) {
            this.revalidate();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        SimpleColoredComponent simpleColoredComponent = this;
        synchronized (simpleColoredComponent) {
            this.append(fragment, attributes);
            if (this.myFragmentTags == null) {
                this.myFragmentTags = new ArrayList();
            }
            while (this.myFragmentTags.size() < this.myFragments.size() - 1) {
                this.myFragmentTags.add(null);
            }
            this.myFragmentTags.add(tag);
        }
        this.revalidateAndRepaint();
    }

    public synchronized void appendAlign(int alignWidth) {
        this.myAlignIndex = this.myFragments.size() - 1;
        this.myAlignWidth = alignWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SimpleColoredComponent simpleColoredComponent = this;
        synchronized (simpleColoredComponent) {
            this.myIcon = null;
            this.myPaintFocusBorder = false;
            this.myFragments.clear();
            this.myAttributes.clear();
            this.myFragmentTags = null;
            this.myMainTextLastIndex = -1;
            this.myAlignIndex = -1;
            this.myAlignWidth = -1;
        }
        this.revalidateAndRepaint();
    }

    public final Icon getIcon() {
        return this.myIcon;
    }

    public final void setIcon(Icon icon) {
        this.myIcon = icon;
        this.revalidateAndRepaint();
    }

    public Insets getIpad() {
        return this.myIpad;
    }

    public void setIpad(Insets ipad) {
        this.myIpad = ipad;
        this.revalidateAndRepaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
        this.revalidateAndRepaint();
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        this.myPaintFocusBorder = paintFocusBorder;
        this.repaint();
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
        this.repaint();
    }

    public boolean isIconOpaque() {
        return this.myIconOpaque;
    }

    public void setIconOpaque(boolean iconOpaque) {
        this.myIconOpaque = iconOpaque;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computePreferredSize(false);
    }

    public synchronized Object getFragmentTag(int index) {
        if (this.myFragmentTags != null && index < this.myFragmentTags.size()) {
            return this.myFragmentTags.get(index);
        }
        return null;
    }

    public final synchronized Dimension computePreferredSize(boolean mainTextOnly) {
        int width = this.myIpad.left;
        if (this.myIcon != null) {
            width += this.myIcon.getIconWidth() + this.myIconTextGap;
        }
        Insets borderInsets = this.myBorder.getBorderInsets(this);
        width += borderInsets.left;
        Font font = this.getFont();
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        LOG.assertTrue(font != null);
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            if (font.getStyle() != attributes.getStyle()) {
                font = font.deriveFont(attributes.getStyle());
            }
            FontMetrics metrics = this.getFontMetrics(font);
            if (i == this.myAlignIndex && (width += metrics.stringWidth(this.myFragments.get(i))) < this.myAlignWidth) {
                width = this.myAlignWidth;
            }
            if (mainTextOnly && this.myMainTextLastIndex >= 0 && i == this.myMainTextLastIndex) break;
        }
        width += this.myIpad.right + borderInsets.right;
        int height = this.myIpad.top + this.myIpad.bottom;
        FontMetrics metrics = this.getFontMetrics(font);
        int textHeight = metrics.getHeight();
        height = this.myIcon != null ? (height += Math.max(this.myIcon.getIconHeight(), textHeight)) : (height += (textHeight += borderInsets.top + borderInsets.bottom));
        Insets insets = this.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public int findFragmentAt(int x) {
        Font font;
        int curX = this.myIpad.left;
        if (this.myIcon != null) {
            curX += this.myIcon.getIconWidth() + this.myIconTextGap;
        }
        LOG.assertTrue((font = this.getFont()) != null);
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            if (font.getStyle() != attributes.getStyle()) {
                font = font.deriveFont(attributes.getStyle());
            }
            FontMetrics metrics = this.getFontMetrics(font);
            int curWidth = metrics.stringWidth(this.myFragments.get(i));
            if (x >= curX && x < curX + curWidth) {
                return i;
            }
            if (i != this.myAlignIndex || (curX += curWidth) >= this.myAlignWidth) continue;
            curX = this.myAlignWidth;
        }
        return -1;
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            this.doPaint(g);
        }
        catch (RuntimeException e) {
            LOG.error(this.logSwingPath(), (Throwable)e);
            throw e;
        }
    }

    protected synchronized void doPaint(Graphics g) {
        SimpleColoredComponent.checkCanPaint(g);
        int xOffset = 0;
        Icon icon = this.myIcon;
        if (icon != null) {
            Container parent = this.getParent();
            Color iconBackgroundColor = null;
            if (this.isIconOpaque()) {
                iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isFullRowSelectionLAF() ? parent.getBackground() : this.getBackground();
            }
            if (iconBackgroundColor != null) {
                g.setColor(iconBackgroundColor);
                g.fillRect(0, 0, icon.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
            }
            icon.paintIcon(this, g, this.myIpad.left, (this.getHeight() - icon.getIconHeight()) / 2);
            xOffset += this.myIpad.left + icon.getIconWidth() + this.myIconTextGap;
        }
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(xOffset, 0, this.getWidth() - xOffset, this.getHeight());
        }
        if (xOffset == 0) {
            xOffset = this.myIpad.left;
        }
        int textStart = xOffset;
        xOffset += this.myBorder.getBorderInsets((Component)this).left;
        UIUtil.applyRenderingHints((Graphics)g);
        for (int i = 0; i < this.myFragments.size(); ++i) {
            Color color;
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            Font font = this.getFont();
            if (font.getStyle() != attributes.getStyle()) {
                font = font.deriveFont(attributes.getStyle());
            }
            g.setFont(font);
            FontMetrics metrics = this.getFontMetrics(font);
            String fragment = this.myFragments.get(i);
            int fragmentWidth = metrics.stringWidth(fragment);
            Color bgColor = attributes.getBgColor();
            if (this.isOpaque() && bgColor != null) {
                g.setColor(bgColor);
                g.fillRect(xOffset, 0, fragmentWidth, this.getHeight());
            }
            if ((color = attributes.getFgColor()) == null) {
                color = this.getForeground();
            }
            if (!this.isEnabled()) {
                color = UIUtil.getTextInactiveTextColor();
            }
            g.setColor(color);
            int textBaseline = (this.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
            g.drawString(fragment, xOffset, textBaseline);
            if (attributes.isStrikeout()) {
                int strikeOutAt = textBaseline + (metrics.getDescent() - metrics.getAscent()) / 2;
                UIUtil.drawLine((Graphics)g, (int)xOffset, (int)strikeOutAt, (int)(xOffset + fragmentWidth), (int)strikeOutAt);
            }
            if (attributes.isWaved()) {
                if (attributes.getWaveColor() != null) {
                    g.setColor(attributes.getWaveColor());
                }
                int wavedAt = textBaseline + 1;
                for (int x = xOffset; x <= xOffset + fragmentWidth; x += 4) {
                    UIUtil.drawLine((Graphics)g, (int)x, (int)wavedAt, (int)(x + 2), (int)(wavedAt + 2));
                    UIUtil.drawLine((Graphics)g, (int)(x + 3), (int)(wavedAt + 1), (int)(x + 4), (int)wavedAt);
                }
            }
            if (attributes.isUnderline()) {
                int underlineAt = textBaseline + 1;
                UIUtil.drawLine((Graphics)g, (int)xOffset, (int)underlineAt, (int)(xOffset + fragmentWidth), (int)underlineAt);
            }
            if (i != this.myAlignIndex || (xOffset += fragmentWidth) >= this.myAlignWidth) continue;
            xOffset = this.myAlignWidth;
        }
        if (this.myPaintFocusBorder) {
            if (this.myFocusBorderAroundIcon || icon == null) {
                this.myBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                this.myBorder.paintBorder(this, g, textStart, 0, this.getWidth() - textStart, this.getHeight());
            }
        }
    }

    private static void checkCanPaint(Graphics g) {
        if (UIUtil.isPrinting((Graphics)g)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertIsDispatchThread();
        } else if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException(Thread.currentThread().toString());
        }
    }

    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(((Component)c).toString());
        }
        return buffer.toString();
    }

    protected void setBorderInsets(Insets insets) {
        this.myBorder.setInsets(insets);
        this.revalidateAndRepaint();
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        for (String each : this.myFragments) {
            result.append(each);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(@NotNull Runnable runnable, boolean autoInvalidate) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.change must not be null");
        }
        boolean old = this.myAutoInvalidate;
        this.myAutoInvalidate = autoInvalidate;
        try {
            runnable.run();
        }
        finally {
            this.myAutoInvalidate = old;
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.myContext;
    }

    private static class MyAccessibleContext
    extends AccessibleContext {
        private MyAccessibleContext() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return 0;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }
    }

    private static final class MyBorder
    implements Border {
        private Insets myInsets = new Insets(1, 1, 1, 1);

        public void setInsets(Insets insets) {
            this.myInsets = insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.BLACK);
            UIUtil.drawDottedRectangle((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)(y + height - 1));
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

