/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class PathsChooserComponent {
    private JPanel myContentPane;
    private JList myList;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private DefaultListModel myListModel;
    private List<String> myWorkingCollection;
    private List<String> myInitialCollection;

    public PathsChooserComponent(@NotNull List<String> collection, final @NotNull PathProcessor processor) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/PathsChooserComponent.<init> must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/PathsChooserComponent.<init> must not be null");
        }
        this.myInitialCollection = collection;
        this.$$$setupUI$$$();
        this.myWorkingCollection = new ArrayList<String>(this.myInitialCollection);
        this.myListModel = new DefaultListModel();
        this.myList.setModel(this.myListModel);
        this.reset();
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile[] files;
                FileChooserDescriptor dirChooser = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                dirChooser.setShowFileSystemRoots(true);
                dirChooser.setHideIgnored(true);
                dirChooser.setTitle(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
                FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(dirChooser, PathsChooserComponent.this.myContentPane);
                for (VirtualFile file : files = chooser.choose(null, null)) {
                    String path = file.getPath();
                    if (!processor.addPath(PathsChooserComponent.this.myWorkingCollection, path)) continue;
                    PathsChooserComponent.this.myListModel.addElement(path);
                }
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = PathsChooserComponent.this.myList.getSelectedIndex();
                if (selected != -1) {
                    String path = (String)PathsChooserComponent.this.myListModel.get(selected);
                    if (processor.removePath(PathsChooserComponent.this.myWorkingCollection, path)) {
                        PathsChooserComponent.this.myListModel.remove(selected);
                    }
                }
            }
        });
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public List<String> getValues() {
        return this.myWorkingCollection;
    }

    public void reset() {
        this.myListModel.clear();
        this.myWorkingCollection = new ArrayList<String>(this.myInitialCollection);
        for (String path : this.myWorkingCollection) {
            this.myListModel.addElement(path);
        }
    }

    public boolean isModified() {
        return !((Object)this.myWorkingCollection).equals(this.myInitialCollection);
    }

    public void apply() {
        this.myInitialCollection.clear();
        this.myInitialCollection.addAll(this.myWorkingCollection);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JList jList;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(10, 7, 7, 7), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 7, null, null, null));
        this.myList = jList = new JList();
        jList.setSelectionMode(0);
        jScrollPane.setViewportView(jList);
        this.myAddButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/UIBundle").getString("row.add"));
        jPanel.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/UIBundle").getString("row.remove"));
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface PathProcessor {
        public boolean addPath(List<String> var1, String var2);

        public boolean removePath(List<String> var1, String var2);
    }
}

