/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ColorChooser;
import com.intellij.ui.EdgeBorder;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;

public class ColorPanel
extends JPanel {
    public static final Color[] fixedColors;
    public static final Color DARK_MAGENTA;
    public static final Color DARK_BLUE;
    public static final Color DARK_GREEN;
    public static final Color BLUE_GREEN;
    public static final Color DARK_YELLOW;
    public static final Color DARK_RED;
    public static final Color DISABLED_COLOR;
    private static Color[] myCustomColors;
    @NonNls
    private String myActionCommand = "colorPanelChanged";
    private boolean isFiringEvent = false;
    private int myBoxSize;
    private GridLayout myCustomGridLayout;
    private GridLayout myFixedGridLayout;
    private ColorBox[] myFgFixedColorBoxes;
    private ColorBox[] myFgCustomColorBoxes;
    private ColorBox myFgSelectedColorBox;

    public ColorPanel() {
        this(null, 10);
    }

    public ColorPanel(Color[] colors, int boxSize) {
        this.myBoxSize = boxSize;
        this.myFgSelectedColorBox = new ColorBox(null, (this.myBoxSize + 2) * 2, true);
        this.myFgSelectedColorBox.setSelectColorAction(new Runnable(){

            @Override
            public void run() {
                ColorPanel.this.fireActionEvent();
            }
        });
        this.myFgFixedColorBoxes = new ColorBox[16];
        this.myFixedGridLayout = new GridLayout(2, 0, 2, 2);
        this.myCustomGridLayout = new GridLayout(2, 0, 2, 2);
        this.myFgCustomColorBoxes = new ColorBox[8];
        if (colors == null) {
            if (myCustomColors == null) {
                myCustomColors = new Color[]{Color.lightGray, Color.lightGray, Color.lightGray, Color.lightGray, Color.lightGray, Color.lightGray, Color.lightGray, Color.lightGray};
            }
        } else {
            myCustomColors = colors;
        }
        JPanel selectedColorPanel = new JPanel(new GridBagLayout());
        selectedColorPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.myFgSelectedColorBox.setBorder(BorderFactory.createEtchedBorder());
        selectedColorPanel.add((Component)this.myFgSelectedColorBox, new GridBagConstraints());
        this.initializeColorBoxes();
        JPanel fixedColorsPanel = new JPanel(this.myFixedGridLayout);
        for (int i = 0; i < this.myFgFixedColorBoxes.length; ++i) {
            JPanel jpanel2 = new JPanel(new BorderLayout());
            jpanel2.setBorder(BorderFactory.createEtchedBorder());
            jpanel2.add((Component)this.myFgFixedColorBoxes[i], "Center");
            fixedColorsPanel.add(jpanel2);
        }
        JPanel customColorsPanel = new JPanel(this.myCustomGridLayout);
        EdgeBorder edgeborder = new EdgeBorder(240);
        Border border = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        customColorsPanel.setBorder(BorderFactory.createCompoundBorder(edgeborder, border));
        for (int k = 0; k < this.myFgCustomColorBoxes.length; ++k) {
            JPanel jpanel4 = new JPanel(new BorderLayout());
            jpanel4.setBorder(BorderFactory.createEtchedBorder());
            jpanel4.add((Component)this.myFgCustomColorBoxes[k], "Center");
            customColorsPanel.add(jpanel4);
        }
        JPanel allColorsPanel = new JPanel(new GridBagLayout());
        allColorsPanel.setBorder(BorderFactory.createEtchedBorder());
        allColorsPanel.add((Component)fixedColorsPanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 0, new Insets(2, 2, 2, 1), 0, 0));
        allColorsPanel.add((Component)customColorsPanel, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)selectedColorPanel, "West");
        this.add((Component)allColorsPanel, "Center");
    }

    @Override
    public void setEnabled(boolean enabled) {
        ColorBox colorBox;
        int i;
        for (i = 0; i < this.myFgFixedColorBoxes.length; ++i) {
            colorBox = this.myFgFixedColorBoxes[i];
            colorBox.setEnabled(enabled);
        }
        for (i = 0; i < this.myFgCustomColorBoxes.length; ++i) {
            colorBox = this.myFgCustomColorBoxes[i];
            colorBox.setEnabled(enabled);
        }
        this.myFgSelectedColorBox.setEnabled(enabled);
        super.setEnabled(enabled);
        this.repaint();
    }

    void updateColorBoxes() {
        for (int i = 0; i < this.myFgCustomColorBoxes.length; ++i) {
            this.myFgCustomColorBoxes[i].setColor(myCustomColors[i]);
        }
    }

    protected void initializeColorBoxes() {
        int i;
        for (i = 0; i < this.myFgFixedColorBoxes.length; ++i) {
            this.myFgFixedColorBoxes[i] = new ColorBox(fixedColors[i], this.myBoxSize, false);
        }
        for (i = 0; i < this.myFgCustomColorBoxes.length; ++i) {
            this.myFgCustomColorBoxes[i] = new ColorBox(Color.orange, this.myBoxSize, true);
            final int customColorIndex = i;
            final ColorBox customColorBox = this.myFgCustomColorBoxes[i];
            this.myFgCustomColorBoxes[i].setSelectColorAction(new Runnable(){

                @Override
                public void run() {
                    myCustomColors[customColorIndex] = customColorBox.getColor();
                }
            });
        }
        this.updateColorBoxes();
    }

    public void setActionCommand(String actionCommand) {
        this.myActionCommand = actionCommand;
    }

    public String getActionCommand() {
        return this.myActionCommand;
    }

    private void fireActionEvent() {
        if (!this.isFiringEvent) {
            this.isFiringEvent = true;
            ActionEvent actionevent = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                if (actionevent == null) {
                    actionevent = new ActionEvent(this, 1001, this.getActionCommand());
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(actionevent);
            }
            this.isFiringEvent = false;
        }
    }

    public void removeActionListener(ActionListener actionlistener) {
        this.listenerList.remove(ActionListener.class, actionlistener);
    }

    public void addActionListener(ActionListener actionlistener) {
        this.listenerList.add(ActionListener.class, actionlistener);
    }

    public void setCustomColor(int index, Color color1) {
        ColorPanel.myCustomColors[index - this.myFgFixedColorBoxes.length] = color1;
    }

    public Color getSelectedColor() {
        return this.myFgSelectedColorBox.getColor();
    }

    public void setSelectedColor(Color color) {
        this.myFgSelectedColorBox.setColor(color);
    }

    public Color[] getCustomColors() {
        return myCustomColors;
    }

    public void setPanelGridHeight(int i) {
        this.myFixedGridLayout.setRows(i);
        this.myCustomGridLayout.setRows(i);
        this.doLayout();
    }

    public void setCustomColors(Color[] colors) {
        myCustomColors = colors;
        if (myCustomColors == null) {
            myCustomColors = fixedColors;
        }
        if (colors != null) {
            this.updateColorBoxes();
        }
    }

    static {
        DARK_MAGENTA = new Color(128, 0, 128);
        DARK_BLUE = new Color(0, 0, 128);
        DARK_GREEN = new Color(0, 128, 0);
        BLUE_GREEN = new Color(0, 128, 128);
        DARK_YELLOW = new Color(128, 128, 0);
        DARK_RED = new Color(128, 0, 0);
        DISABLED_COLOR = UIUtil.getPanelBackgound();
        fixedColors = new Color[]{Color.white, Color.lightGray, Color.red, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta, Color.black, Color.gray, DARK_RED, DARK_YELLOW, DARK_GREEN, BLUE_GREEN, DARK_BLUE, DARK_MAGENTA};
    }

    private class ColorBox
    extends JComponent {
        private final Dimension mySize;
        private final boolean isSelectable;
        private Runnable mySelectColorAction = null;
        private Color myColor;
        @NonNls
        public static final String RGB = "RGB";

        public ColorBox(Color color, int size, boolean isSelectable) {
            this.mySize = new Dimension(size, size);
            this.isSelectable = isSelectable;
            this.myColor = color;
            this.updateToolTip();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseevent) {
                    if (!ColorBox.this.isEnabled()) {
                        return;
                    }
                    if (mouseevent.isPopupTrigger()) {
                        ColorBox.this.selectColor();
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseevent) {
                    if (!ColorBox.this.isEnabled()) {
                        return;
                    }
                    if (mouseevent.getClickCount() == 2) {
                        ColorBox.this.selectColor();
                    } else if (SwingUtilities.isLeftMouseButton(mouseevent)) {
                        ColorPanel.this.setSelectedColor(ColorBox.this.myColor);
                        ColorPanel.this.fireActionEvent();
                    } else if (mouseevent.isPopupTrigger()) {
                        ColorBox.this.selectColor();
                    }
                }
            });
        }

        public void setSelectColorAction(Runnable selectColorAction) {
            this.mySelectColorAction = selectColorAction;
        }

        private void selectColor() {
            Color color;
            if (this.isSelectable && (color = ColorChooser.chooseColor(ColorPanel.this, UIBundle.message((String)"color.panel.select.color.dialog.description", (Object[])new Object[0]), this.myColor)) != null) {
                this.setColor(color);
                if (this.mySelectColorAction != null) {
                    this.mySelectColorAction.run();
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.mySize;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.mySize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.mySize;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.isEnabled()) {
                g.setColor(this.myColor);
            } else {
                g.setColor(DISABLED_COLOR);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        private void updateToolTip() {
            if (this.myColor == null) {
                return;
            }
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("RGB: ");
            buffer.append(this.myColor.getRed());
            buffer.append(", ");
            buffer.append(this.myColor.getGreen());
            buffer.append(", ");
            buffer.append(this.myColor.getBlue());
            if (this.isSelectable) {
                buffer.append(" (" + UIBundle.message((String)"color.panel.right.click.to.customize.tooltip.suffix", (Object[])new Object[0]) + ")");
            }
            this.setToolTipText(buffer.toString());
        }

        public void setColor(Color color) {
            this.myColor = color;
            this.updateToolTip();
            this.repaint();
        }

        public Color getColor() {
            return this.myColor;
        }
    }
}

