/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;

public class CollectionListModel
extends AbstractListModel {
    private final List myItems;

    public CollectionListModel(List items) {
        this.myItems = items;
    }

    public CollectionListModel(Object ... items) {
        this.myItems = Arrays.asList(items);
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.myItems.get(index);
    }

    public void add(Object element) {
        int i = this.myItems.size();
        this.myItems.add(element);
        this.fireIntervalAdded(this, i, i);
    }

    public void remove(Object element) {
        int i = this.myItems.indexOf(element);
        this.myItems.remove(element);
        this.fireIntervalRemoved(this, i, i);
    }

    public void removeAll() {
        int size = this.myItems.size();
        this.myItems.clear();
        this.fireIntervalRemoved(this, 0, size - 1);
    }

    public void contentsChanged(Object element) {
        int i = this.myItems.indexOf(element);
        this.fireContentsChanged(this, i, i);
    }
}

