/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.GlobalJavaInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.PsiTestCase;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public abstract class InspectionTestCase
extends PsiTestCase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.InspectionTestCase");

    public InspectionManagerEx getManager() {
        return (InspectionManagerEx)InspectionManager.getInstance(this.myProject);
    }

    public void doTest(@NonNls String folderName, LocalInspectionTool tool) throws Exception {
        this.doTest(folderName, (InspectionTool)new LocalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool) throws Exception {
        this.doTest(folderName, (InspectionTool)new GlobalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool, boolean checkRange) throws Exception {
        this.doTest(folderName, (InspectionTool)new GlobalInspectionToolWrapper(tool), checkRange);
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool, boolean checkRange, boolean runDeadCodeFirst) throws Exception {
        this.doTest(folderName, (InspectionTool)new GlobalInspectionToolWrapper(tool), "java 1.4", checkRange, runDeadCodeFirst);
    }

    public void doTest(@NonNls String folderName, InspectionTool tool) throws Exception {
        this.doTest(folderName, tool, "java 1.4");
    }

    public void doTest(@NonNls String folderName, InspectionTool tool, boolean checkRange) throws Exception {
        this.doTest(folderName, tool, "java 1.4", checkRange);
    }

    public void doTest(@NonNls String folderName, InspectionTool tool, @NonNls String jdkName) throws Exception {
        this.doTest(folderName, tool, jdkName, false);
    }

    public void doTest(@NonNls String folderName, InspectionTool tool, @NonNls String jdkName, boolean checkRange) throws Exception {
        this.doTest(folderName, tool, jdkName, checkRange, false);
    }

    public void doTest(@NonNls String folderName, InspectionTool tool, @NonNls String jdkName, boolean checkRange, boolean runDeadCodeFirst) throws Exception {
        String testDir = this.getTestDataPath() + "/" + folderName;
        this.runTool(testDir, jdkName, tool, runDeadCodeFirst);
        InspectionTestUtil.compareToolResults((InspectionTool)tool, (boolean)checkRange, (String)testDir);
    }

    protected void runTool(@NonNls String testDir, @NonNls String jdkName, InspectionTool tool) {
        this.runTool(testDir, jdkName, tool, false);
    }

    protected void runTool(final String testDir, final String jdkName, InspectionTool tool, boolean runDeadCodeFirst) {
        final VirtualFile[] sourceDir = new VirtualFile[1];
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    InspectionTestCase.this.setupRootModel(testDir, sourceDir, jdkName);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        AnalysisScope scope = this.createAnalysisScope(sourceDir[0]);
        InspectionManagerEx inspectionManager = (InspectionManagerEx)InspectionManager.getInstance(this.myProject);
        GlobalInspectionContextImpl globalContext = inspectionManager.createNewGlobalContext(true);
        globalContext.setCurrentScope(scope);
        if (runDeadCodeFirst) {
            InspectionTestCase.runTool((InspectionTool)new UnusedDeclarationInspection(), scope, globalContext, inspectionManager);
        }
        InspectionTestCase.runTool(tool, scope, globalContext, inspectionManager);
    }

    protected AnalysisScope createAnalysisScope(VirtualFile sourceDir) {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        return new AnalysisScope(psiManager.findDirectory(sourceDir));
    }

    private static void runTool(InspectionTool tool, AnalysisScope scope, GlobalInspectionContextImpl globalContext, InspectionManagerEx inspectionManager) {
        InspectionTestUtil.runTool((InspectionTool)tool, (AnalysisScope)scope, (GlobalInspectionContextImpl)globalContext, (InspectionManagerEx)inspectionManager);
        GlobalJavaInspectionContextImpl javaInspectionContext = (GlobalJavaInspectionContextImpl)globalContext.getExtension(GlobalJavaInspectionContextImpl.CONTEXT);
        if (javaInspectionContext != null) {
            do {
                javaInspectionContext.processSearchRequests((GlobalInspectionContext)globalContext);
            } while (tool.queryExternalUsagesRequests((InspectionManager)inspectionManager));
        }
    }

    protected void setupRootModel(String testDir, VirtualFile[] sourceDir, String sdkName) {
        VirtualFile projectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir));
        InspectionTestCase.assertNotNull((String)("could not find project dir " + testDir), (Object)projectDir);
        sourceDir[0] = projectDir.findChild("src");
        if (sourceDir[0] == null) {
            sourceDir[0] = projectDir;
        }
        VirtualFile ext_src = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir + "/ext_src"));
        ModuleRootManager rootManager = ModuleRootManager.getInstance(this.myModule);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        rootModel.clear();
        ContentEntry contentEntry = rootModel.addContentEntry(projectDir);
        contentEntry.addSourceFolder(sourceDir[0], false);
        if (ext_src != null) {
            contentEntry.addSourceFolder(ext_src, false);
        }
        rootModel.setSdk(this.getTestProjectSdk(sdkName));
        rootModel.commit();
    }

    protected Sdk getTestProjectSdk(String sdkName) {
        Sdk sdk;
        if ("java 1.5".equals(sdkName)) {
            sdk = JavaSdkImpl.getMockJdk15((String)sdkName);
            LanguageLevelProjectExtension.getInstance(this.getProject()).setLanguageLevel(LanguageLevel.JDK_1_5);
        } else {
            sdk = JavaSdkImpl.getMockJdk((String)sdkName);
        }
        return sdk;
    }

    @Override
    @NonNls
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/inspection/";
    }
}

