/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.testFramework.PlatformTestCase;
import org.jetbrains.annotations.NonNls;

@NonNls
public abstract class IdeaTestCase
extends PlatformTestCase {
    private static boolean ourPlatformPrefixInitialized;

    protected IdeaTestCase() {
        IdeaTestCase.initPlatformPrefix();
    }

    public final JavaPsiFacadeEx getJavaFacade() {
        return JavaPsiFacadeEx.getInstanceEx((Project)this.myProject);
    }

    protected Sdk getTestProjectJdk() {
        return JavaSdkImpl.getMockJdk((String)"java 1.4");
    }

    protected ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public static void initPlatformPrefix() {
        if (!ourPlatformPrefixInitialized) {
            ourPlatformPrefixInitialized = true;
            boolean isUltimate = true;
            try {
                IdeaTestCase.class.getClassLoader().loadClass("com.intellij.idea.IdeaUltimateApplication");
            }
            catch (ClassNotFoundException e) {
                isUltimate = false;
            }
            if (!isUltimate) {
                System.setProperty("idea.platform.prefix", "Idea");
            }
        }
    }
}

