/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.ref;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiChildLink;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRef;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationChildLink
extends PsiChildLink<PsiModifierListOwner, PsiAnnotation> {
    private final String myAnnoFqn;

    public AnnotationChildLink(String fqn) {
        this.myAnnoFqn = fqn;
    }

    public String getAnnotationQualifiedName() {
        return this.myAnnoFqn;
    }

    public static PsiRef<PsiAnnotation> createRef(@NotNull PsiModifierListOwner parent, @NonNls String fqn) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ref/AnnotationChildLink.createRef must not be null");
        }
        return new AnnotationChildLink(fqn).createChildRef(parent);
    }

    @Override
    public PsiAnnotation findLinkedChild(@Nullable PsiModifierListOwner member) {
        if (member == null) {
            return null;
        }
        PsiModifierList modifierList = member.getModifierList();
        return modifierList != null ? modifierList.findAnnotation(this.myAnnoFqn) : null;
    }

    @Override
    @NotNull
    public PsiAnnotation createChild(@NotNull PsiModifierListOwner member) throws IncorrectOperationException {
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ref/AnnotationChildLink.createChild must not be null");
        }
        PsiModifierList modifierList = member.getModifierList();
        assert (modifierList != null);
        PsiAnnotation psiAnnotation = modifierList.addAnnotation(this.myAnnoFqn);
        if (psiAnnotation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/ref/AnnotationChildLink.createChild must not return null");
        }
        return psiAnnotation;
    }

    public String toString() {
        return "AnnotationChildLink{myAnnoFqn='" + this.myAnnoFqn + '\'' + '}';
    }
}

