/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import org.jetbrains.annotations.NotNull;

public abstract class WalkingState<T> {
    private boolean isDown;
    protected boolean startedWalking;
    private final TreeGuide<T> myWalker;
    private boolean stopped;

    public abstract void elementFinished(@NotNull T var1);

    protected WalkingState(@NotNull TreeGuide<T> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/WalkingState.<init> must not be null");
        }
        this.myWalker = delegate;
    }

    public void visit(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/WalkingState.visit must not be null");
        }
        this.elementStarted(element);
    }

    public void elementStarted(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/WalkingState.elementStarted must not be null");
        }
        this.isDown = true;
        if (!this.startedWalking) {
            this.stopped = false;
            this.startedWalking = true;
            this.walkChildren(element);
            this.startedWalking = false;
        }
    }

    private void walkChildren(T root) {
        T element = this.next(root, root, this.isDown);
        while (element != null && !this.stopped) {
            this.isDown = false;
            T parent = this.myWalker.getParent(element);
            T next = this.myWalker.getNextSibling(element);
            this.visit(element);
            assert (this.myWalker.getNextSibling(element) == next) : "Next sibling of the element '" + element + "' changed. Was: " + next + "; Now:" + this.myWalker.getNextSibling(element) + "; Root:" + root;
            assert (this.myWalker.getParent(element) == parent) : "Parent of the element '" + element + "' changed. Was: " + parent + "; Now:" + this.myWalker.getParent(element) + "; Root:" + root;
            element = this.next(element, root, this.isDown);
        }
    }

    public T next(T element, T root, boolean isDown) {
        T child;
        if (isDown && (child = this.myWalker.getFirstChild(element)) != null) {
            return child;
        }
        while (element != root && element != null) {
            T next = this.myWalker.getNextSibling(element);
            this.elementFinished(element);
            if (next != null) {
                T nextPrev = this.myWalker.getPrevSibling(next);
                if (nextPrev != element) {
                    T top;
                    String msg = "Element: " + element + "; next: " + next + "; next.prev: " + nextPrev;
                    while ((top = this.myWalker.getParent(element)) != null) {
                        element = top;
                    }
                    assert (false) : msg + " Top:" + element;
                }
                return next;
            }
            element = this.myWalker.getParent(element);
        }
        this.elementFinished(element);
        return null;
    }

    public void startedWalking() {
        this.startedWalking = true;
    }

    public void stopWalking() {
        this.stopped = true;
    }

    public static interface TreeGuide<T> {
        public T getNextSibling(@NotNull T var1);

        public T getPrevSibling(@NotNull T var1);

        public T getFirstChild(@NotNull T var1);

        public T getParent(@NotNull T var1);
    }
}

