/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRefElementCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiRef<T extends PsiElement> {
    private volatile PsiRefColleague<T> myColleague;

    public PsiRef(PsiRefColleague<T> colleague) {
        this.myColleague = colleague;
    }

    public final boolean isImaginary() {
        return this.getPsiElement() == null;
    }

    @Nullable
    public final T getPsiElement() {
        return this.myColleague.getPsiElement();
    }

    @NotNull
    public final T ensurePsiElementExists() {
        PsiRefColleague.Real<T> realColleague = this.myColleague.makeReal();
        this.myColleague = realColleague;
        T t = realColleague.getPsiElement();
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiRef.ensurePsiElementExists must not return null");
        }
        return t;
    }

    @NotNull
    public final PsiElement getRoot() {
        PsiElement psiElement = this.myColleague.getRoot();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiRef.getRoot must not return null");
        }
        return psiElement;
    }

    public boolean equals(Object o) {
        return o instanceof PsiRef && this.myColleague.equals(((PsiRef)o).myColleague);
    }

    public int hashCode() {
        return this.myColleague.hashCode();
    }

    public final boolean isValid() {
        return this.myColleague.isValid();
    }

    public static <T extends PsiElement> PsiRef<T> real(T element) {
        return new PsiRef<T>(new PsiRefColleague.Real<T>(element));
    }

    public static <Child extends PsiElement, Parent extends PsiElement> PsiRef<Child> imaginary(PsiRef<? extends Parent> parent, PsiRefElementCreator<Parent, Child> creator) {
        return new PsiRef(new PsiRefColleague.Imaginary<Child, Parent>(parent, creator));
    }

    public PsiManager getPsiManager() {
        return this.myColleague.getRoot().getManager();
    }

    private static interface PsiRefColleague<T extends PsiElement> {
        public boolean isValid();

        @Nullable
        public T getPsiElement();

        @NotNull
        public Real<T> makeReal();

        @NotNull
        public PsiElement getRoot();

        public static class Imaginary<Child extends PsiElement, Parent extends PsiElement>
        implements PsiRefColleague<Child> {
            private final PsiRef<? extends Parent> myParent;
            private final PsiRefElementCreator<Parent, Child> myCreator;

            public Imaginary(PsiRef<? extends Parent> parent, PsiRefElementCreator<Parent, Child> creator) {
                this.myParent = parent;
                this.myCreator = creator;
            }

            @Override
            public boolean isValid() {
                return this.myParent.isValid();
            }

            @Override
            public Child getPsiElement() {
                return null;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Imaginary imaginary = (Imaginary)o;
                if (!this.myCreator.equals(imaginary.myCreator)) {
                    return false;
                }
                return this.myParent.equals(imaginary.myParent);
            }

            public int hashCode() {
                int result = this.myParent.hashCode();
                result = 31 * result + this.myCreator.hashCode();
                return result;
            }

            @Override
            @NotNull
            public Real<Child> makeReal() {
                Real<PsiElement> real = new Real<PsiElement>((PsiElement)this.myCreator.createChild(this.myParent.ensurePsiElementExists()));
                if (real == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiRef$PsiRefColleague$Imaginary.makeReal must not return null");
                }
                return real;
            }

            @Override
            @NotNull
            public PsiElement getRoot() {
                PsiElement psiElement = this.myParent.getRoot();
                if (psiElement == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiRef$PsiRefColleague$Imaginary.getRoot must not return null");
                }
                return psiElement;
            }
        }

        public static class Real<T extends PsiElement>
        implements PsiRefColleague<T> {
            private final T myElement;

            public Real(T element) {
                this.myElement = element;
            }

            @Override
            @NotNull
            public T getPsiElement() {
                T t = this.myElement;
                if (t == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiRef$PsiRefColleague$Real.getPsiElement must not return null");
                }
                return t;
            }

            @Override
            public boolean isValid() {
                return this.myElement.isValid();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Real real = (Real)o;
                return this.myElement.equals(real.myElement);
            }

            public int hashCode() {
                return this.myElement.hashCode();
            }

            @Override
            @NotNull
            public Real<T> makeReal() {
                Real real = this;
                if (real == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiRef$PsiRefColleague$Real.makeReal must not return null");
                }
                return real;
            }

            @Override
            @NotNull
            public PsiElement getRoot() {
                T t = this.myElement;
                if (t == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiRef$PsiRefColleague$Real.getRoot must not return null");
                }
                return t;
            }
        }
    }
}

