/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ComponentWithActions {
    @Nullable
    public ActionGroup getToolbarActions();

    @Nullable
    public JComponent getSearchComponent();

    @Nullable
    public String getToolbarPlace();

    @Nullable
    public JComponent getToolbarContextComponent();

    @NotNull
    public JComponent getComponent();

    public boolean isContentBuiltIn();

    public static class Impl
    implements ComponentWithActions {
        private ActionGroup myToolbar;
        private String myToolbarPlace;
        private JComponent myToolbarContext;
        private JComponent mySearchComponent;
        private JComponent myComponent;

        public Impl(ActionGroup toolbar, String toolbarPlace, JComponent toolbarContext, JComponent searchComponent, JComponent component) {
            this.myToolbar = toolbar;
            this.myToolbarPlace = toolbarPlace;
            this.myToolbarContext = toolbarContext;
            this.mySearchComponent = searchComponent;
            this.myComponent = component;
        }

        @Override
        public boolean isContentBuiltIn() {
            return false;
        }

        public Impl(JComponent component) {
            this(null, null, null, null, component);
        }

        @Override
        public ActionGroup getToolbarActions() {
            return this.myToolbar;
        }

        @Override
        public JComponent getSearchComponent() {
            return this.mySearchComponent;
        }

        @Override
        public String getToolbarPlace() {
            return this.myToolbarPlace;
        }

        @Override
        public JComponent getToolbarContextComponent() {
            return this.myToolbarContext;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/ComponentWithActions$Impl.getComponent must not return null");
            }
            return jComponent;
        }
    }
}

