/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class BackgroundTaskQueue {
    private final Project myProject;
    private final Queue<Task> myQueue = new LinkedList<Task>();
    private boolean myHasActiveTask = false;
    private Task.Backgroundable myRunnerTask;

    public BackgroundTaskQueue(String title) {
        this(null, title);
    }

    public BackgroundTaskQueue(Project project, String title) {
        this.myProject = project;
        this.myRunnerTask = new Task.Backgroundable(project, title){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/BackgroundTaskQueue$1.run must not be null");
                }
                while (true) {
                    Task task;
                    Queue queue = BackgroundTaskQueue.this.myQueue;
                    synchronized (queue) {
                        BackgroundTaskQueue.this.myHasActiveTask = true;
                        task = (Task)BackgroundTaskQueue.this.myQueue.poll();
                        if (task == null) {
                            BackgroundTaskQueue.this.myHasActiveTask = false;
                            return;
                        }
                    }
                    indicator.setText(task.getTitle());
                    try {
                        task.run(indicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (myProject == null || !myProject.isDisposed()) {
                                task.onSuccess();
                            }
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Task.Backgroundable task) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            task.run(new EmptyProgressIndicator());
            task.onSuccess();
        } else if (task.isConditionalModal() && !task.shouldStartInBackground()) {
            ProgressManager.getInstance().run(task);
        } else {
            boolean hadActiveTask;
            Queue<Task> queue = this.myQueue;
            synchronized (queue) {
                hadActiveTask = this.myHasActiveTask;
                this.myQueue.offer(task);
                this.myHasActiveTask = true;
            }
            if (!hadActiveTask) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    ProgressManager.getInstance().run(this.myRunnerTask);
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (BackgroundTaskQueue.this.myProject == null || !BackgroundTaskQueue.this.myProject.isDisposed()) {
                                ProgressManager.getInstance().run(BackgroundTaskQueue.this.myRunnerTask);
                            }
                        }
                    });
                }
            }
        }
    }
}

