/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ContentChooser<Data>
extends DialogWrapper {
    private static final Icon textIcon = IconLoader.getIcon((String)"/fileTypes/text.png");
    private JList myList;
    private List<Data> myAllContents;
    private Editor myViewer;
    private final boolean myUseIdeaEditor;
    private Splitter mySplitter;
    private final Project myProject;

    public ContentChooser(Project project, String title, boolean useIdeaEditor) {
        super(project, true);
        this.myProject = project;
        this.myUseIdeaEditor = useIdeaEditor;
        this.setOKButtonText(CommonBundle.getOkButtonText());
        this.setTitle(title);
        this.init();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myList = new JList();
        this.myList.setSelectionMode(0);
        this.rebuildListContent();
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed() || e.getClickCount() != 2 || e.isPopupTrigger()) {
                    return;
                }
                ContentChooser.this.close(0);
            }
        });
        this.myList.setCellRenderer(new MyListCellRenderer());
        if (this.myAllContents.size() > 0) {
            this.myList.setSelectedIndex(0);
        }
        this.myList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int selectedIndex = ContentChooser.this.getSelectedIndex();
                    int size = ContentChooser.this.myAllContents.size();
                    ContentChooser.this.removeContentAt(ContentChooser.this.myAllContents.get(selectedIndex));
                    ContentChooser.this.rebuildListContent();
                    if (size == 1) {
                        ContentChooser.this.close(1);
                        return;
                    }
                    ContentChooser.this.myList.setSelectedIndex(Math.min(selectedIndex, ContentChooser.this.myAllContents.size() - 1));
                } else if (e.getKeyCode() == 10) {
                    ContentChooser.this.close(0);
                } else {
                    char aChar = e.getKeyChar();
                    if (aChar >= '0' && aChar <= '9') {
                        int idx;
                        int n = idx = aChar == '0' ? 9 : aChar - 49;
                        if (idx < ContentChooser.this.myAllContents.size()) {
                            ContentChooser.this.myList.setSelectedIndex(idx);
                        }
                    }
                }
            }
        });
        this.mySplitter = new Splitter(true);
        this.mySplitter.setFirstComponent((JComponent)new JScrollPane(this.myList));
        this.mySplitter.setSecondComponent((JComponent)new JPanel());
        this.updateViewerForSelection();
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ContentChooser.this.updateViewerForSelection();
            }
        });
        this.mySplitter.setPreferredSize(new Dimension(500, 500));
        return this.mySplitter;
    }

    protected abstract void removeContentAt(Data var1);

    @Override
    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.editor.actions.MultiplePasteAction.Chooser";
    }

    private void updateViewerForSelection() {
        if (this.myAllContents.size() == 0) {
            return;
        }
        String fullString = this.getStringRepresentationFor(this.myAllContents.get(this.getSelectedIndex()));
        fullString = StringUtil.convertLineSeparators((String)fullString);
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
        }
        if (this.myUseIdeaEditor) {
            Document doc = EditorFactory.getInstance().createDocument(fullString);
            this.myViewer = EditorFactory.getInstance().createViewer(doc, this.myProject);
            this.myViewer.getComponent().setPreferredSize(new Dimension(300, 500));
            this.myViewer.getSettings().setFoldingOutlineShown(false);
            this.myViewer.getSettings().setLineNumbersShown(false);
            this.myViewer.getSettings().setLineMarkerAreaShown(false);
            this.myViewer.getSettings().setIndentGuidesShown(false);
            this.mySplitter.setSecondComponent(this.myViewer.getComponent());
        } else {
            JTextArea textArea = new JTextArea(fullString);
            textArea.setRows(3);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setSelectionStart(0);
            textArea.setSelectionEnd(textArea.getText().length());
            textArea.setEditable(false);
            this.mySplitter.setSecondComponent((JComponent)new JScrollPane(textArea));
        }
        this.mySplitter.revalidate();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
            this.myViewer = null;
        }
    }

    private void rebuildListContent() {
        ArrayList<Data> allContents = new ArrayList<Data>(this.getContents());
        ArrayList<String> shortened = new ArrayList<String>();
        block0: for (Object content : allContents) {
            String fullString = this.getStringRepresentationFor(content);
            if (fullString == null) continue;
            int newLineIdx = (fullString = StringUtil.convertLineSeparators((String)fullString)).indexOf(10);
            if (newLineIdx == -1) {
                shortened.add(fullString.trim());
                continue;
            }
            int lastLooked = 0;
            while (true) {
                int nextLineIdx;
                if ((nextLineIdx = fullString.indexOf("\n", lastLooked)) > lastLooked) {
                    shortened.add(fullString.substring(lastLooked, nextLineIdx).trim() + " ...");
                    continue block0;
                }
                if (nextLineIdx == -1) {
                    shortened.add(" ...");
                    continue block0;
                }
                lastLooked = nextLineIdx + 1;
            }
        }
        this.myAllContents = allContents;
        this.myList.setListData(ArrayUtil.toStringArray(shortened));
    }

    protected abstract String getStringRepresentationFor(Data var1);

    protected abstract List<Data> getContents();

    public int getSelectedIndex() {
        if (this.myList.getSelectedIndex() == -1) {
            return 0;
        }
        return this.myList.getSelectedIndex();
    }

    public List<Data> getAllContents() {
        return this.myAllContents;
    }

    private static class MyListCellRenderer
    extends ColoredListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            this.setIcon(textIcon);
            if (index <= 9) {
                this.append(String.valueOf((index + 1) % 10) + "  ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

