/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.IntermediateOutputCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CompilerPaths {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.compiler.CompilerPaths");
    private static volatile String ourSystemPath;
    private static final Comparator<String> URLS_COMPARATOR;
    private static final String DEFAULT_GENERATED_DIR_NAME = "generated";

    public static File getGeneratedDataDirectory(Project project, Compiler compiler) {
        return new File(CompilerPaths.getGeneratedDataDirectory(project), compiler.getDescription().replaceAll("\\s+", "_"));
    }

    public static File getGeneratedDataDirectory(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".generated");
    }

    public static File getCacheStoreDirectory(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".caches");
    }

    public static File getCompilerSystemDirectory(Project project) {
        String projectName = CompilerPaths.getPresentableName(project);
        return new File(CompilerPaths.getCompilerSystemDirectory(), projectName + "." + project.getLocationHash());
    }

    private static String getPresentableName(Project project) {
        int lastSlash;
        if (project.isDefault()) {
            return project.getName();
        }
        String projectName = FileUtil.toSystemIndependentName((String)project.getLocation());
        if (projectName.endsWith("/")) {
            projectName = projectName.substring(0, projectName.length() - 1);
        }
        if ((lastSlash = projectName.lastIndexOf(47)) >= 0 && lastSlash + 1 < projectName.length()) {
            projectName = projectName.substring(lastSlash + 1);
        }
        if (StringUtil.endsWithIgnoreCase((String)projectName, (String)".ipr")) {
            projectName = projectName.substring(0, projectName.length() - ".ipr".length());
        }
        projectName = projectName.toLowerCase(Locale.US);
        return projectName;
    }

    public static File getCompilerSystemDirectory() {
        String systemPath = ourSystemPath != null ? ourSystemPath : (ourSystemPath = PathUtil.getCanonicalPath(PathManager.getSystemPath()));
        return new File(systemPath, "compiler");
    }

    @Nullable
    public static VirtualFile getModuleOutputDirectory(Module module, boolean forTestClasses) {
        VirtualFile path;
        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance(module);
        VirtualFile outPath = forTestClasses ? ((path = compilerModuleExtension.getCompilerOutputPathForTests()) != null ? path : compilerModuleExtension.getCompilerOutputPath()) : compilerModuleExtension.getCompilerOutputPath();
        if (outPath == null) {
            return null;
        }
        if (!outPath.isValid()) {
            LOG.info("Requested output path for module " + module.getName() + " is not valid");
            return null;
        }
        return outPath;
    }

    @Nullable
    public static String getModuleOutputPath(Module module, boolean forTestClasses) {
        String url;
        Application application = ApplicationManager.getApplication();
        final CompilerModuleExtension extension = CompilerModuleExtension.getInstance(module);
        String outPathUrl = forTestClasses ? (application.isDispatchThread() ? ((url = extension.getCompilerOutputUrlForTests()) != null ? url : extension.getCompilerOutputUrl()) : application.runReadAction(new Computable<String>(){

            public String compute() {
                String url = extension.getCompilerOutputUrlForTests();
                return url != null ? url : extension.getCompilerOutputUrl();
            }
        })) : (application.isDispatchThread() ? extension.getCompilerOutputUrl() : application.runReadAction(new Computable<String>(){

            public String compute() {
                return extension.getCompilerOutputUrl();
            }
        }));
        return outPathUrl != null ? VirtualFileManager.extractPath(outPathUrl) : null;
    }

    @Nullable
    public static String getAnnotationProcessorsGenerationPath(Module module) {
        CompilerConfiguration config = CompilerConfiguration.getInstance(module.getProject());
        String sourceDirName = config.getGeneratedSourceDirName(module);
        if (sourceDirName != null && sourceDirName.length() > 0) {
            String[] roots = ModuleRootManager.getInstance(module).getContentRootUrls();
            if (roots.length == 0) {
                return null;
            }
            if (roots.length > 1) {
                Arrays.sort(roots, URLS_COMPARATOR);
            }
            return VirtualFileManager.extractPath(roots[0]) + "/" + sourceDirName;
        }
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance(module.getProject());
        if (extension == null) {
            return null;
        }
        String url = extension.getCompilerOutputUrl();
        if (url == null) {
            return null;
        }
        return VirtualFileManager.extractPath(url) + "/" + DEFAULT_GENERATED_DIR_NAME + "/" + module.getName().toLowerCase();
    }

    @NonNls
    public static String getGenerationOutputPath(IntermediateOutputCompiler compiler, Module module, boolean forTestSources) {
        String generatedCompilerDirectoryPath = CompilerPaths.getGeneratedDataDirectory(module.getProject(), compiler).getPath();
        String moduleDir = module.getName().replaceAll("\\s+", "_") + "." + Integer.toHexString(module.getModuleFilePath().hashCode());
        return generatedCompilerDirectoryPath.replace(File.separatorChar, '/') + "/" + moduleDir + "/" + (forTestSources ? "test" : "production");
    }

    static {
        URLS_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
    }
}

