/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PathsList;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SimpleJavaParameters {
    private Sdk myJdk;
    private final PathsList myClassPath = new PathsList();
    private String myMainClass;
    private final ParametersList myVmParameters = new ParametersList();
    private final ParametersList myProgramParameters = new ParametersList();
    private String myWorkingDirectory;
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();
    private Map<String, String> myEnv;
    private boolean myPassParentEnvs = true;

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public String getMainClass() {
        return this.myMainClass;
    }

    @Nullable
    public Sdk getJdk() {
        return this.myJdk;
    }

    public void setJdk(Sdk jdk) {
        this.myJdk = jdk;
    }

    public void setMainClass(@NonNls String mainClass) {
        this.myMainClass = mainClass;
    }

    public void setWorkingDirectory(File path) {
        this.setWorkingDirectory(path.getPath());
    }

    public void setWorkingDirectory(@NonNls String path) {
        this.myWorkingDirectory = path;
    }

    public ParametersList getVMParametersList() {
        return this.myVmParameters;
    }

    public ParametersList getProgramParametersList() {
        return this.myProgramParameters;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public PathsList getClassPath() {
        return this.myClassPath;
    }

    public Map<String, String> getEnv() {
        return this.myEnv;
    }

    public void setEnv(Map<String, String> env) {
        this.myEnv = env;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passDefaultEnvs) {
        this.myPassParentEnvs = passDefaultEnvs;
    }

    public void setupEnvs(Map<String, String> envs, boolean passDefault) {
        if (!envs.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>(envs);
            EnvironmentVariablesComponent.inlineParentOccurrences(map);
            this.setEnv(map);
            this.setPassParentEnvs(passDefault);
        }
    }

    public OSProcessHandler createOSProcessHandler() throws ExecutionException {
        Sdk sdk = this.getJdk();
        assert (sdk != null) : "SDK should be defined";
        final GeneralCommandLine commandLine = JdkUtil.setupJVMCommandLine(((JavaSdkType)((Object)sdk.getSdkType())).getVMExecutablePath(sdk), this, JdkUtil.useDynamicClasspath(PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext())));
        OSProcessHandler processHandler = new OSProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString()){

            @Override
            public Charset getCharset() {
                return commandLine.getCharset();
            }
        };
        ProcessTerminatedListener.attach(processHandler);
        return processHandler;
    }
}

