/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunnableState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import org.jetbrains.annotations.NotNull;

public abstract class CommandLineState
implements RunnableState {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.CommandLineState");
    private TextConsoleBuilder myConsoleBuilder;
    private final ExecutionEnvironment myEnvironment;

    protected CommandLineState(ExecutionEnvironment environment) {
        this.myEnvironment = environment;
    }

    @Override
    public RunnerSettings getRunnerSettings() {
        return this.myEnvironment.getRunnerSettings();
    }

    @Override
    public ConfigurationPerRunnerSettings getConfigurationSettings() {
        return this.myEnvironment.getConfigurationSettings();
    }

    @Override
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        ConsoleView console;
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/CommandLineState.execute must not be null");
        }
        if (runner == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/configurations/CommandLineState.execute must not be null");
        }
        OSProcessHandler processHandler = this.startProcess();
        TextConsoleBuilder builder = this.getConsoleBuilder();
        ConsoleView consoleView = console = builder != null ? builder.getConsole() : null;
        if (console != null) {
            console.attachToProcess(processHandler);
        }
        return new DefaultExecutionResult(console, processHandler, this.createActions(console, processHandler, executor));
    }

    protected abstract OSProcessHandler startProcess() throws ExecutionException;

    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler) {
        return this.createActions(console, processHandler, null);
    }

    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        if (console == null || !console.canPause() || executor != null && !DefaultRunExecutor.EXECUTOR_ID.equals(executor.getId())) {
            return new AnAction[0];
        }
        return new AnAction[]{new PauseOutputAction(console, processHandler)};
    }

    public TextConsoleBuilder getConsoleBuilder() {
        return this.myConsoleBuilder;
    }

    public void setConsoleBuilder(TextConsoleBuilder consoleBuilder) {
        this.myConsoleBuilder = consoleBuilder;
    }

    protected static class PauseOutputAction
    extends ToggleAction
    implements DumbAware {
        private final ConsoleView myConsole;
        private final ProcessHandler myProcessHandler;

        public PauseOutputAction(ConsoleView console, ProcessHandler processHandler) {
            super(ExecutionBundle.message("run.configuration.pause.output.action.name", new Object[0]), null, IconLoader.getIcon((String)"/actions/pause.png"));
            this.myConsole = console;
            this.myProcessHandler = processHandler;
        }

        @Override
        public boolean isSelected(AnActionEvent event) {
            return this.myConsole.isOutputPaused();
        }

        @Override
        public void setSelected(final AnActionEvent event, boolean flag) {
            this.myConsole.setOutputPaused(flag);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    PauseOutputAction.this.update(event);
                }
            });
        }

        @Override
        public void update(final AnActionEvent event) {
            boolean isRunning;
            super.update(event);
            Presentation presentation = event.getPresentation();
            boolean bl = isRunning = this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
            if (isRunning) {
                presentation.setEnabled(true);
            } else {
                if (!this.myConsole.canPause()) {
                    presentation.setEnabled(false);
                    return;
                }
                if (!this.myConsole.hasDeferredOutput()) {
                    presentation.setEnabled(false);
                } else {
                    presentation.setEnabled(true);
                    this.myConsole.performWhenNoDeferredOutput(new Runnable(){

                        @Override
                        public void run() {
                            PauseOutputAction.this.update(event);
                        }
                    });
                }
            }
        }
    }
}

