/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class ModuleCompilerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.ModuleCompilerUtil");

    private ModuleCompilerUtil() {
    }

    public static Module[] getDependencies(Module module) {
        return ModuleRootManager.getInstance(module).getDependencies();
    }

    public static Graph<Module> createModuleGraph(final Module[] modules) {
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Module>(){

            public Collection<Module> getNodes() {
                return Arrays.asList(modules);
            }

            public Iterator<Module> getIn(Module module) {
                return Arrays.asList(ModuleCompilerUtil.getDependencies(module)).iterator();
            }
        }));
    }

    public static List<Chunk<Module>> getSortedModuleChunks(Project project, List<Module> modules) {
        Module[] allModules = ModuleManager.getInstance(project).getModules();
        List<Chunk<Module>> chunks = ModuleCompilerUtil.getSortedChunks(ModuleCompilerUtil.createModuleGraph(allModules));
        HashSet<Module> modulesSet = new HashSet<Module>(modules);
        Iterator<Chunk<Module>> it = chunks.iterator();
        while (it.hasNext()) {
            Chunk<Module> chunk = it.next();
            if (ContainerUtil.intersects((Collection)chunk.getNodes(), modulesSet)) continue;
            it.remove();
        }
        return chunks;
    }

    public static <Node> List<Chunk<Node>> getSortedChunks(Graph<Node> graph) {
        Graph<Chunk<Node>> chunkGraph = ModuleCompilerUtil.toChunkGraph(graph);
        ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(chunkGraph.getNodes().size());
        for (Chunk chunk : chunkGraph.getNodes()) {
            chunks.add(chunk);
        }
        DFSTBuilder builder = new DFSTBuilder(chunkGraph);
        if (!builder.isAcyclic()) {
            LOG.error("Acyclic graph expected");
            return null;
        }
        Collections.sort(chunks, builder.comparator());
        return chunks;
    }

    public static <Node> Graph<Chunk<Node>> toChunkGraph(final Graph<Node> graph) {
        final DFSTBuilder builder = new DFSTBuilder(graph);
        TIntArrayList sccs = builder.getSCCs();
        final ArrayList chunks = new ArrayList(sccs.size());
        final LinkedHashMap nodeToChunkMap = new LinkedHashMap();
        sccs.forEach(new TIntProcedure(){
            int myTNumber = 0;

            public boolean execute(int size) {
                LinkedHashSet<Object> chunkNodes = new LinkedHashSet<Object>();
                Chunk chunk = new Chunk(chunkNodes);
                chunks.add(chunk);
                for (int j = 0; j < size; ++j) {
                    Object node = builder.getNodeByTNumber(this.myTNumber + j);
                    chunkNodes.add(node);
                    nodeToChunkMap.put(node, chunk);
                }
                this.myTNumber += size;
                return true;
            }
        });
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Chunk<Node>>(){

            public Collection<Chunk<Node>> getNodes() {
                return chunks;
            }

            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet ins = new LinkedHashSet();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add(nodeToChunkMap.get(in));
                    }
                }
                return ins.iterator();
            }
        }));
    }

    public static void sortModules(final Project project, final List<Module> modules) {
        Application application = ApplicationManager.getApplication();
        Runnable sort = new Runnable(){

            @Override
            public void run() {
                Comparator<Module> comparator = ModuleManager.getInstance(project).moduleDependencyComparator();
                Collections.sort(modules, comparator);
            }
        };
        if (application.isDispatchThread()) {
            sort.run();
        } else {
            application.runReadAction(sort);
        }
    }

    public static GraphGenerator<ModifiableRootModel> createGraphGenerator(final Map<Module, ModifiableRootModel> models) {
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<ModifiableRootModel>(){

            public Collection<ModifiableRootModel> getNodes() {
                return models.values();
            }

            public Iterator<ModifiableRootModel> getIn(ModifiableRootModel model) {
                Module[] modules = model.getModuleDependencies();
                ArrayList dependencies = new ArrayList();
                for (Module module : modules) {
                    dependencies.add(models.get(module));
                }
                return dependencies.iterator();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Pair<Module, Module> addingDependencyFormsCircularity(Module currentModule, Module toDependOn) {
        assert (currentModule != toDependOn);
        LinkedHashMap<Module, ModifiableRootModel> models = new LinkedHashMap<Module, ModifiableRootModel>();
        Project project = currentModule.getProject();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            ModifiableRootModel model = ModuleRootManager.getInstance(module).getModifiableModel();
            models.put(module, model);
        }
        ModifiableRootModel currentModel = (ModifiableRootModel)models.get(currentModule);
        ModifiableRootModel toDependOnModel = (ModifiableRootModel)models.get(toDependOn);
        Collection<Chunk<ModifiableRootModel>> nodesBefore = ModuleCompilerUtil.buildChunks(models);
        for (Chunk<ModifiableRootModel> chunk : nodesBefore) {
            if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
            return null;
        }
        try {
            currentModel.addModuleOrderEntry(toDependOn);
            Collection<Chunk<ModifiableRootModel>> nodesAfter = ModuleCompilerUtil.buildChunks(models);
            for (Chunk<ModifiableRootModel> chunk : nodesAfter) {
                if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
                Iterator nodes = chunk.getNodes().iterator();
                Pair pair = Pair.create((Object)((ModifiableRootModel)nodes.next()).getModule(), (Object)((ModifiableRootModel)nodes.next()).getModule());
                return pair;
            }
        }
        finally {
            for (ModifiableRootModel model : models.values()) {
                model.dispose();
            }
        }
        return null;
    }

    public static Collection<Chunk<ModifiableRootModel>> buildChunks(Map<Module, ModifiableRootModel> models) {
        return ModuleCompilerUtil.toChunkGraph(ModuleCompilerUtil.createGraphGenerator(models)).getNodes();
    }
}

