/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AutoCompletionPolicy {
    NEVER_AUTOCOMPLETE,
    SETTINGS_DEPENDENT,
    GIVE_CHANCE_TO_OVERWRITE,
    ALWAYS_AUTOCOMPLETE;


    @NotNull
    public LookupElement applyPolicy(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/AutoCompletionPolicy.applyPolicy must not be null");
        }
        PolicyDecorator policyDecorator = new PolicyDecorator(element, this);
        if (policyDecorator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/AutoCompletionPolicy.applyPolicy must not return null");
        }
        return policyDecorator;
    }

    @Nullable
    public static AutoCompletionPolicy getPolicy(LookupElement element) {
        PolicyDecorator decorator = element.as(PolicyDecorator.class);
        if (decorator != null) {
            return decorator.myPolicy;
        }
        return null;
    }

    private static class PolicyDecorator
    extends LookupElementDecorator<LookupElement> {
        private final AutoCompletionPolicy myPolicy;

        public PolicyDecorator(LookupElement element, AutoCompletionPolicy policy) {
            super(element);
            this.myPolicy = policy;
        }
    }
}

