/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightAction
extends AnAction {
    @Override
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = PlatformDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            Editor editor = this.getEditor(dataContext, project);
            this.actionPerformedImpl(project, editor);
        }
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project) {
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/actions/CodeInsightAction.getEditor must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/actions/CodeInsightAction.getEditor must not be null");
        }
        return PlatformDataKeys.EDITOR.getData(dataContext);
    }

    public void actionPerformedImpl(final @NotNull Project project, final Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/actions/CodeInsightAction.actionPerformedImpl must not be null");
        }
        if (editor == null) {
            return;
        }
        final PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor, project);
        if (psiFile == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                final CodeInsightActionHandler handler = CodeInsightAction.this.getHandler();
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
                            return;
                        }
                        handler.invoke(project, editor, psiFile);
                    }
                };
                if (handler.startInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(action);
                } else {
                    action.run();
                }
            }
        }, this.getCommandName(), DocCommandGroupId.noneGroupId(editor.getDocument()));
    }

    @Override
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = this.getEditor(dataContext, project);
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor(editor, project);
        if (file == null || !this.isValidForFile(project, editor, file)) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(this.isEnabledForFile(project, editor, file));
        }
    }

    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        return true;
    }

    protected boolean isEnabledForFile(Project project, Editor editor, PsiFile file) {
        return true;
    }

    protected abstract CodeInsightActionHandler getHandler();

    protected String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text != null ? text : "";
    }
}

