/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class GatheringChangelistBuilder
implements ChangelistBuilder {
    private final Set<VirtualFile> myCheckSet;
    private final List<Change> myChanges;
    private final UpdatedFilesReverseSide myFiles;
    private final VirtualFile myMergeRoot;
    private final SvnVcs myVcs;

    public GatheringChangelistBuilder(Project project, UpdatedFilesReverseSide files, VirtualFile mergeRoot) {
        this.myVcs = SvnVcs.getInstance(project);
        this.myFiles = files;
        this.myMergeRoot = mergeRoot;
        this.myChanges = new ArrayList<Change>();
        this.myCheckSet = new HashSet<VirtualFile>();
    }

    public void processChange(Change change, VcsKey vcsKey) {
        this.addChange(change);
    }

    public void processChangeInList(Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
        this.addChange(change);
    }

    public void processChangeInList(Change change, String changeListName, VcsKey vcsKey) {
        this.addChange(change);
    }

    private void addChange(Change change) {
        FilePath path = ChangesUtil.getFilePath((Change)change);
        VirtualFile vf = path.getVirtualFile();
        if ((this.mergeinfoChanged(path.getIOFile()) || vf != null && this.myFiles.containsFile(vf)) && !this.myCheckSet.contains(vf)) {
            this.myCheckSet.add(vf);
            this.myChanges.add(change);
        }
    }

    private boolean mergeinfoChanged(File file) {
        SVNWCClient client = this.myVcs.createWCClient();
        try {
            SVNPropertyData current = client.doGetProperty(file, "svn:mergeinfo", SVNRevision.UNDEFINED, SVNRevision.WORKING);
            SVNPropertyData base = client.doGetProperty(file, "svn:mergeinfo", SVNRevision.UNDEFINED, SVNRevision.BASE);
            if (current != null) {
                SVNPropertyValue baseValue;
                if (base == null) {
                    return true;
                }
                SVNPropertyValue currentValue = current.getValue();
                return !Comparing.equal((Object)currentValue, (Object)(baseValue = base.getValue()));
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return false;
    }

    public void processUnversionedFile(VirtualFile file) {
    }

    public void processLocallyDeletedFile(FilePath file) {
    }

    public void processLocallyDeletedFile(LocallyDeletedChange locallyDeletedChange) {
    }

    public void processModifiedWithoutCheckout(VirtualFile file) {
    }

    public void processIgnoredFile(VirtualFile file) {
    }

    public void processLockedFolder(VirtualFile file) {
    }

    public void processLogicallyLockedFolder(VirtualFile file, LogicalLock logicalLock) {
    }

    public void processSwitchedFile(VirtualFile file, String branch, boolean recursive) {
    }

    public void processRootSwitch(VirtualFile file, String branch) {
    }

    public boolean isUpdatingUnversionedFiles() {
        return false;
    }

    public boolean reportChangesOutsideProject() {
        return true;
    }

    public void reportWarningMessage(String message) {
    }

    public List<Change> getChanges() {
        return this.myChanges;
    }
}

