/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class ShowAllSubmittedFilesAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.actions.ShowAllSubmittedFilesAction");

    public ShowAllSubmittedFilesAction() {
        super(SvnBundle.message("action.name.show.all.paths.affected", new Object[0]), null, IconLoader.getIcon((String)"/icons/allRevisions.png"));
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        e.getPresentation().setEnabled(e.getData(VcsDataKeys.VCS_FILE_REVISION) != null && revisionVirtualFile != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (revision != null && revisionVirtualFile != null) {
            SvnFileRevision svnRevision = (SvnFileRevision)revision;
            ShowAllSubmittedFilesAction.showSubmittedFiles(project, svnRevision, revisionVirtualFile);
        }
    }

    public static void showSubmittedFiles(Project project, SvnFileRevision svnRevision, VirtualFile file) {
        SvnChangeList changeList = ShowAllSubmittedFilesAction.loadRevisions(project, svnRevision, file);
        if (changeList != null) {
            long revNumber = ((SvnRevisionNumber)svnRevision.getRevisionNumber()).getRevision().getNumber();
            AbstractVcsHelper.getInstance((Project)project).showChangesListBrowser((CommittedChangeList)changeList, ShowAllSubmittedFilesAction.getTitle(revNumber));
        }
    }

    private static String getTitle(long revisionNumber) {
        return SvnBundle.message("dialog.title.affected.paths", revisionNumber);
    }

    @Nullable
    public static SvnChangeList loadRevisions(Project project, SvnFileRevision svnRevision, @Nullable VirtualFile file) {
        return ShowAllSubmittedFilesAction.loadRevisions(project, svnRevision, file, true);
    }

    @Nullable
    public static SvnChangeList loadRevisions(Project project, SvnFileRevision svnRevision, @Nullable VirtualFile file, boolean underProgress) {
        final Ref result = new Ref();
        final SvnRevisionNumber number = (SvnRevisionNumber)svnRevision.getRevisionNumber();
        final SVNRevision targetRevision = ((SvnRevisionNumber)svnRevision.getRevisionNumber()).getRevision();
        final SvnVcs vcs = SvnVcs.getInstance(project);
        try {
            SVNURL repositoryUrl;
            final Exception[] ex = new Exception[1];
            String url = svnRevision.getURL();
            final SVNLogEntry[] logEntry = new SVNLogEntry[1];
            final SvnRepositoryLocation location = new SvnRepositoryLocation(url);
            final SVNLogClient client = vcs.createLogClient();
            if (file != null && file.isInLocalFileSystem()) {
                SvnFileUrlMapping urlMapping = vcs.getSvnFileUrlMapping();
                RootUrlInfo wcRoot = urlMapping.getWcRootForFilePath(new File(file.getPath()));
                if (wcRoot == null) {
                    return null;
                }
                repositoryUrl = wcRoot.getRepositoryUrlUrl();
            } else {
                SVNInfo svnInfo = vcs.createWCClient().doInfo(SVNURL.parseURIEncoded((String)url), SVNRevision.HEAD, SVNRevision.HEAD);
                repositoryUrl = svnInfo.getRepositoryRootURL();
                if (repositoryUrl == null) {
                    Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.load.version", number, "Cannot get repository url"), (String)SvnBundle.message("message.title.error.fetching.affected.paths", new Object[0]));
                    return null;
                }
            }
            Runnable process = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressManager.getInstance().getProgressIndicator().setText(SvnBundle.message("progress.text.loading.log", new Object[0]));
                        client.doLog(repositoryUrl, null, targetRevision, targetRevision, targetRevision, false, true, 0L, new ISVNLogEntryHandler(){

                            public void handleLogEntry(SVNLogEntry currentLogEntry) throws SVNException {
                                logEntry[0] = currentLogEntry;
                            }
                        });
                        if (logEntry[0] == null) {
                            throw new VcsException(SvnBundle.message("exception.text.cannot.load.version", number));
                        }
                        ProgressManager.getInstance().getProgressIndicator().setText(SvnBundle.message("progress.text.processing.changes", new Object[0]));
                        result.set((Object)new SvnChangeList(vcs, location, logEntry[0], repositoryUrl.toString()));
                    }
                    catch (Exception e) {
                        ex[0] = e;
                    }
                }
            };
            if (underProgress) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(process, ShowAllSubmittedFilesAction.getTitle(targetRevision.getNumber()), false, project);
            } else {
                process.run();
            }
            if (ex[0] != null) {
                throw ex[0];
            }
        }
        catch (Exception e1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            e1.printStackTrace(new PrintStream(baos));
            LOG.info("For url: " + svnRevision.getURL() + "Exception: " + new String(baos.toByteArray()));
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.load.version", number, e1.getLocalizedMessage()), (String)SvnBundle.message("message.title.error.fetching.affected.paths", new Object[0]));
            return null;
        }
        return (SvnChangeList)result.get();
    }
}

