/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NonNls;

@com.intellij.openapi.components.State(name="Git.Application.Settings", storages={@Storage(id="Git.Application.Settings", file="$APP_CONFIG$/vcs.xml")})
public class GitVcsApplicationSettings
implements PersistentStateComponent<State> {
    @NonNls
    static final String[] DEFAULT_WINDOWS_PATHS = new String[]{"C:\\cygwin\\bin", "C:\\Program Files\\Git\\bin", "C:\\Program Files (x86)\\Git\\bin"};
    @NonNls
    static final String DEFAULT_WINDOWS_GIT = "git.exe";
    @NonNls
    static final String[] DEFAULT_UNIX_PATHS = new String[]{"/usr/local/bin", "/usr/bin", "/opt/local/bin", "/opt/bin", "/usr/local/git/bin"};
    @NonNls
    static final String DEFAULT_UNIX_GIT = "git";
    private String myPathToGit;

    public String defaultGit() {
        if (this.myPathToGit == null) {
            String[] paths;
            String program;
            if (SystemInfo.isWindows) {
                program = DEFAULT_WINDOWS_GIT;
                paths = DEFAULT_WINDOWS_PATHS;
            } else {
                program = DEFAULT_UNIX_GIT;
                paths = DEFAULT_UNIX_PATHS;
            }
            for (String p : paths) {
                File f = new File(p, program);
                if (!f.exists()) continue;
                this.myPathToGit = f.getAbsolutePath();
                break;
            }
            if (this.myPathToGit == null) {
                this.myPathToGit = program;
            }
        }
        return this.myPathToGit;
    }

    public State getState() {
        State s = new State();
        s.PATH_TO_GIT = this.myPathToGit;
        return s;
    }

    public void loadState(State state) {
        this.myPathToGit = state.PATH_TO_GIT;
    }

    public String getPathToGit() {
        return this.myPathToGit;
    }

    public void setPathToGit(String pathToGit) {
        this.myPathToGit = pathToGit;
    }

    public static class State {
        public String PATH_TO_GIT;
    }
}

