/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SideBorder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.util.ui.ClientPropertyHolder;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    @NonNls
    public static final String HTML_MIME = "text/html";
    public static final char MNEMONIC = '\u001b';
    @NonNls
    public static final String JSLIDER_ISFILLED = "JSlider.isFilled";
    @NonNls
    public static final String ARIAL_FONT_NAME = "Arial";
    @NonNls
    public static final String TABLE_FOCUS_CELL_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    private static final Color ACTIVE_COLOR = new Color(160, 186, 213);
    private static final Color INACTIVE_COLOR = new Color(128, 128, 128);
    private static final Color SEPARATOR_COLOR = INACTIVE_COLOR.brighter();
    public static final Pattern CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
    @NonNls
    public static final String FOCUS_PROXY_KEY = "isFocusProxy";
    public static Key<Integer> KEEP_BORDER_SIDES = Key.create("keepBorderSides");

    private UIUtil() {
    }

    public static boolean isReallyTypedEvent(KeyEvent e) {
        char c = e.getKeyChar();
        if (c < ' ' || c == '\u007f') {
            return false;
        }
        int modifiers = e.getModifiers();
        if (SystemInfo.isMac) {
            return !e.isMetaDown() && !e.isControlDown();
        }
        return (modifiers & 8) == (modifiers & 2);
    }

    public static void setEnabled(Component component, boolean enabled, boolean recursively) {
        component.setEnabled(enabled);
        if (recursively && enabled == component.isEnabled() && component instanceof Container) {
            Container container = (Container)component;
            int subComponentCount = container.getComponentCount();
            for (int i = 0; i < subComponentCount; ++i) {
                UIUtil.setEnabled(container.getComponent(i), enabled, recursively);
            }
        }
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public static void setActionNameAndMnemonic(String text, Action action) {
        String mnemoChar;
        int mnemoPos = text.indexOf(38);
        if (mnemoPos >= 0 && mnemoPos < text.length() - 2 && (mnemoChar = text.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action.putValue("MnemonicKey", mnemoChar.charAt(0));
        }
        text = text.replaceAll("&", "");
        action.putValue("Name", text);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static Color getLabelBackground() {
        return UIManager.getColor("Label.background");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Icon getOptionPanelWarningIcon() {
        return UIManager.getIcon("OptionPane.warningIcon");
    }

    public static Icon getOptionPanelQuestionIcon() {
        return UIManager.getIcon("OptionPane.questionIcon");
    }

    @NotNull
    public static String removeMnemonic(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.removeMnemonic must not be null");
        }
        if (s.indexOf(38) != -1) {
            s = StringUtil.replace(s, "&", "");
        }
        if (s.indexOf(27) != -1) {
            s = StringUtil.replace(s, String.valueOf('\u001b'), "");
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil.removeMnemonic must not return null");
        }
        return string;
    }

    public static String replaceMnemonicAmpersand(String value) {
        if (value.indexOf(38) >= 0) {
            boolean useMacMnemonic = value.contains("&&");
            StringBuilder realValue = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\\') {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        realValue.append('&');
                        ++i;
                        continue;
                    }
                    realValue.append(c);
                    continue;
                }
                if (c == '&') {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        if (SystemInfo.isMac) {
                            realValue.append('\u001b');
                        }
                        ++i;
                        continue;
                    }
                    if (SystemInfo.isMac && useMacMnemonic) continue;
                    realValue.append('\u001b');
                    continue;
                }
                realValue.append(c);
            }
            return realValue.toString();
        }
        return value;
    }

    public static Color getTableHeaderBackground() {
        return UIManager.getColor("TableHeader.background");
    }

    public static Color getTreeTextForeground() {
        return UIManager.getColor("Tree.textForeground");
    }

    public static Color getTreeSelectionBackground() {
        return UIManager.getColor("Tree.selectionBackground");
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListSelectionForeground() {
        Color color = UIManager.getColor("List.selectionForeground");
        if (color == null) {
            return UIManager.getColor("List[Selected].textForeground");
        }
        return color;
    }

    public static Color getFieldForegroundColor() {
        return UIManager.getColor("field.foreground");
    }

    public static Color getTableSelectionBackground() {
        return UIManager.getColor("Table.selectionBackground");
    }

    public static Color getActiveTextColor() {
        return UIManager.getColor("textActiveText");
    }

    public static Color getInactiveTextColor() {
        return UIManager.getColor("textInactiveText");
    }

    public static Color getActiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.background");
    }

    public static Color getInactiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.inactiveBackground");
    }

    public static Font getTreeFont() {
        return UIManager.getFont("Tree.font");
    }

    public static Font getListFont() {
        return UIManager.getFont("List.font");
    }

    public static Color getTreeSelectionForeground() {
        return UIManager.getColor("Tree.selectionForeground");
    }

    public static Color getTextInactiveTextColor() {
        return UIManager.getColor("textInactiveText");
    }

    public static void installPopupMenuColorAndFonts(JComponent contentPane) {
        LookAndFeel.installColorsAndFont(contentPane, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    public static void installPopupMenuBorder(JComponent contentPane) {
        LookAndFeel.installBorder(contentPane, "PopupMenu.border");
    }

    public static boolean isMotifLookAndFeel() {
        return "Motif".equals(UIManager.getLookAndFeel().getID());
    }

    public static Color getTreeSelectionBorderColor() {
        return UIManager.getColor("Tree.selectionBorderColor");
    }

    public static Object getTreeRightChildIndent() {
        return UIManager.get("Tree.rightChildIndent");
    }

    public static Object getTreeLeftChildIndent() {
        return UIManager.get("Tree.leftChildIndent");
    }

    public static Color getToolTipBackground() {
        return UIManager.getColor("ToolTip.background");
    }

    public static Color getToolTipForeground() {
        return UIManager.getColor("ToolTip.foreground");
    }

    public static Color getComboBoxDisabledForeground() {
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public static Color getComboBoxDisabledBackground() {
        return UIManager.getColor("ComboBox.disabledBackground");
    }

    public static Color getButtonSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public static Integer getPropertyMaxGutterIconWidth(String propertyPrefix) {
        return (Integer)UIManager.get(propertyPrefix + ".maxGutterIconWidth");
    }

    public static Color getMenuItemDisabledForeground() {
        return UIManager.getColor("MenuItem.disabledForeground");
    }

    public static Object getMenuItemDisabledForegroundObject() {
        return UIManager.get("MenuItem.disabledForeground");
    }

    public static Object getTabbedPanePaintContentBorder(JComponent c) {
        return c.getClientProperty("TabbedPane.paintContentBorder");
    }

    public static boolean isMenuCrossMenuMnemonics() {
        return UIManager.getBoolean("Menu.crossMenuMnemonic");
    }

    public static Color getTableBackground() {
        return UIManager.getColor("Table.background");
    }

    public static Color getTableSelectionForeground() {
        return UIManager.getColor("Table.selectionForeground");
    }

    public static Color getTableForeground() {
        return UIManager.getColor("Table.foreground");
    }

    public static Color getListBackground() {
        return UIManager.getColor("List.background");
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static Color getPanelBackground() {
        return UIManager.getColor("Panel.background");
    }

    public static Color getTreeForeground() {
        return UIManager.getColor("Tree.foreground");
    }

    public static Color getTableFocusCellBackground() {
        return UIManager.getColor(TABLE_FOCUS_CELL_BACKGROUND_PROPERTY);
    }

    public static Color getListSelectionBackground() {
        Color color = UIManager.getColor("List.selectionBackground");
        if (color == null) {
            return UIManager.getColor("List[Selected].textBackground");
        }
        return color;
    }

    public static Color getTextFieldForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Font getButtonFont() {
        return UIManager.getFont("Button.font");
    }

    public static Font getToolTipFont() {
        return UIManager.getFont("ToolTip.font");
    }

    public static Color getTabbedPaneBackground() {
        return UIManager.getColor("TabbedPane.background");
    }

    public static void setSliderIsFilled(JSlider slider, boolean value) {
        slider.putClientProperty(JSLIDER_ISFILLED, value);
    }

    public static Color getLabelTextForeground() {
        return UIManager.getColor("Label.textForeground");
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Font getOptionPaneMessageFont() {
        return UIManager.getFont("OptionPane.messageFont");
    }

    public static Color getSeparatorShadow() {
        return UIManager.getColor("Separator.shadow");
    }

    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    public static Color getSeparatorHighlight() {
        return UIManager.getColor("Separator.highlight");
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    public static void setLineStyleAngled(ClientPropertyHolder component) {
        component.putClientProperty("JTree.lineStyle", "Angled");
    }

    public static void setLineStyleAngled(JTree component) {
        component.putClientProperty("JTree.lineStyle", "Angled");
    }

    public static Color getTableFocusCellForeground() {
        return UIManager.getColor("Table.focusCellForeground");
    }

    public static Color getPanelBackgound() {
        return UIManager.getColor("Panel.background");
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    public static Border getButtonBorder() {
        return UIManager.getBorder("Button.border");
    }

    public static Icon getErrorIcon() {
        return UIManager.getIcon("OptionPane.errorIcon");
    }

    public static Icon getInformationIcon() {
        return UIManager.getIcon("OptionPane.informationIcon");
    }

    public static Icon getQuestionIcon() {
        return UIManager.getIcon("OptionPane.questionIcon");
    }

    public static Icon getWarningIcon() {
        return UIManager.getIcon("OptionPane.warningIcon");
    }

    public static Icon getBalloonInformationIcon() {
        return IconLoader.getIcon("/general/balloonInformation.png");
    }

    public static Icon getBalloonWarningIcon() {
        return IconLoader.getIcon("/general/balloonWarning.png");
    }

    public static Icon getBalloonErrorIcon() {
        return IconLoader.getIcon("/general/balloonError.png");
    }

    public static Icon getRadioButtonIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    public static Icon getTreeCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    public static Icon getTreeExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    public static Border getTableHeaderCellBorder() {
        return UIManager.getBorder("TableHeader.cellBorder");
    }

    public static Color getWindowColor() {
        return UIManager.getColor("window");
    }

    public static Color getTextAreaForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    public static Color getOptionPaneBackground() {
        return UIManager.getColor("OptionPane.background");
    }

    public static boolean isUnderQuaquaLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Quaqua");
    }

    public static boolean isUnderNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Nimbus");
    }

    public static boolean isUnderAquaLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isFullRowSelectionLAF() {
        return UIUtil.isUnderNimbusLookAndFeel() || UIUtil.isUnderQuaquaLookAndFeel();
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderQuaquaLookAndFeel();
    }

    public static void removeQuaquaVisualMarginsIn(Component component) {
        if (component instanceof JComponent) {
            Component[] children;
            JComponent jComponent = (JComponent)component;
            for (Component child : children = jComponent.getComponents()) {
                UIUtil.removeQuaquaVisualMarginsIn(child);
            }
            jComponent.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        }
    }

    public static boolean isControlKeyDown(MouseEvent mouseEvent) {
        return SystemInfo.isMac ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    public static String[] getValidFontNames(boolean familyName) {
        Font[] fonts;
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!font.canDisplay('a') || !font.canDisplay('z') || !font.canDisplay('A') || !font.canDisplay('Z') || !font.canDisplay('0') || !font.canDisplay('1')) continue;
                result.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ArrayUtil.toStringArray(result);
    }

    public static String[] getStandardFontSizes() {
        return new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    }

    public static void setupEnclosingDialogBounds(JComponent component) {
        component.revalidate();
        component.repaint();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
            window.pack();
        }
    }

    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            if (fg.getRed() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getRed()));
            if (fg.getGreen() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getGreen()));
            if (fg.getBlue() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getBlue()));
            rule.append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        int n = i1 = i1 != x1 + 1 ? y + 2 : y + 1;
        while (i1 <= y1) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
            i1 += 2;
        }
        int n2 = i1 = i1 != y1 + 1 ? x1 - 2 : x1 - 1;
        while (i1 >= x) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
            i1 -= 2;
        }
        int n3 = i1 = i1 != x - 1 ? y1 - 2 : y1 - 1;
        while (i1 >= y) {
            UIUtil.drawLine(g, x, i1, x, i1);
            i1 -= 2;
        }
    }

    public static void applyRenderingHints(Graphics g) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            ((Graphics2D)g).addRenderingHints(map);
        }
    }

    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                AWTEvent event1 = eventQueue.getNextEvent();
                if (!(event1 instanceof InvocationEvent)) continue;
                ((InvocationEvent)event1).dispatch();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public static void pump() {
        assert (!SwingUtilities.isEventDispatchThread());
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                queue.offer(queue);
            }
        });
        try {
            queue.take();
        }
        catch (InterruptedException e) {
            LOG.error(e);
        }
    }

    public static void addAwtListener(final AWTEventListener listener, long mask, Disposable parent) {
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, mask);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            }
        });
    }

    public static void drawVDottedLine(Graphics2D g, int lineX, int startY, int endY, Color bgColor, Color fgColor) {
        g.setColor(bgColor);
        UIUtil.drawLine(g, lineX, startY, lineX, endY);
        g.setColor(fgColor);
        for (int i = startY / 2 * 2; i < endY; i += 2) {
            g.drawRect(lineX, i, 0, 0);
        }
    }

    public static void drawHDottedLine(Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor) {
        g.setColor(bgColor);
        UIUtil.drawLine(g, startX, lineY, endX, lineY);
        g.setColor(fgColor);
        for (int i = startX / 2 * 2; i < endX; i += 2) {
            g.drawRect(i, lineY, 0, 0);
        }
    }

    public static void drawDottedLine(Graphics2D g, int x1, int y1, int x2, int y2, Color bgColor, Color fgColor) {
        if (x1 == x2) {
            UIUtil.drawVDottedLine(g, x1, y1, y2, bgColor, fgColor);
        } else if (y1 == y2) {
            UIUtil.drawHDottedLine(g, x1, x2, y1, bgColor, fgColor);
        } else {
            throw new IllegalArgumentException("Only vertical or horizontal lines are supported");
        }
    }

    public static boolean isFocusAncestor(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.isFocusAncestor must not be null");
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        if (owner == component) {
            return true;
        }
        return SwingUtilities.isDescendingFrom(owner, component);
    }

    public static boolean isCloseClick(MouseEvent e) {
        return UIUtil.isCloseClick(e, 501);
    }

    public static boolean isCloseClick(MouseEvent e, int effectiveType) {
        if (e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 2 || e.getButton() == 1 && e.isShiftDown();
    }

    public static boolean isActionClick(MouseEvent e) {
        return UIUtil.isActionClick(e, 501);
    }

    public static boolean isActionClick(MouseEvent e, int effectiveType) {
        if (UIUtil.isCloseClick(e) || e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 1;
    }

    @NotNull
    public static Color getBgFillColor(@NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.getBgFillColor must not be null");
        }
        Component parent = UIUtil.findNearestOpaque(c);
        Color color = parent == null ? c.getBackground() : parent.getBackground();
        if (color == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil.getBgFillColor must not return null");
        }
        return color;
    }

    @Nullable
    public static Component findNearestOpaque(JComponent c) {
        Container eachParent;
        for (eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!((Component)eachParent).isOpaque()) continue;
            return eachParent;
        }
        return eachParent;
    }

    @NonNls
    public static String getCssFontDeclaration(Font font) {
        return "<style> body, div, td { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "; } </style>";
    }

    public static boolean isWinLafOnVista() {
        return (SystemInfo.isWindowsVista || SystemInfo.isWindows7) && "Windows".equals(UIManager.getLookAndFeel().getName());
    }

    public static boolean isStandardMenuLAF() {
        return UIUtil.isWinLafOnVista() || "Nimbus".equals(UIManager.getLookAndFeel().getName());
    }

    public static Color getFocusedFillColor() {
        return UIUtil.toAlpha(UIUtil.getListSelectionBackground(), 100);
    }

    public static Color getFocusedBoundsColor() {
        return UIUtil.getBoundsColor();
    }

    public static Color getBoundsColor() {
        return new Color(128, 128, 128);
    }

    public static Color getBoundsColor(boolean focused) {
        return focused ? UIUtil.getFocusedBoundsColor() : UIUtil.getBoundsColor();
    }

    public static Color toAlpha(Color color, int alpha) {
        Color actual = color != null ? color : Color.black;
        return new Color(actual.getRed(), actual.getGreen(), actual.getBlue(), alpha);
    }

    public static void requestFocus(final @NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.requestFocus must not be null");
        }
        if (c.isShowing()) {
            c.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    c.requestFocus();
                }
            });
        }
    }

    public static void dispose(Component c) {
        MouseWheelListener[] mouseWheelListeners;
        MouseMotionListener[] motionListeners;
        MouseListener[] mouseListeners;
        if (c == null) {
            return;
        }
        for (MouseListener each : mouseListeners = c.getMouseListeners()) {
            c.removeMouseListener(each);
        }
        for (MouseMotionListener each : motionListeners = c.getMouseMotionListeners()) {
            c.removeMouseMotionListener(each);
        }
        for (MouseWheelListener each : mouseWheelListeners = c.getMouseWheelListeners()) {
            c.removeMouseWheelListener(each);
        }
    }

    public static void disposeProgress(final JProgressBar progress) {
        if (!UIUtil.isUnderNativeMacLookAndFeel()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UIUtil.isToDispose(progress)) {
                    progress.getUI().uninstallUI(progress);
                    progress.putClientProperty("isDisposed", Boolean.TRUE);
                }
            }
        });
    }

    private static boolean isToDispose(JProgressBar progress) {
        ProgressBarUI ui = progress.getUI();
        if (ui == null) {
            return false;
        }
        if (Boolean.TYPE.equals(progress.getClientProperty("isDisposed"))) {
            return false;
        }
        try {
            Field progressBarField = ReflectionUtil.findField(ui.getClass(), JProgressBar.class, "progressBar");
            progressBarField.setAccessible(true);
            return progressBarField.get(ui) != null;
        }
        catch (NoSuchFieldException e) {
            return true;
        }
        catch (IllegalAccessException e) {
            return true;
        }
    }

    @Nullable
    public static Component findUltimateParent(Component c) {
        if (c == null) {
            return null;
        }
        Component eachParent = c;
        while (eachParent.getParent() != null) {
            eachParent = eachParent.getParent();
        }
        return eachParent;
    }

    public static void setToolkitModal(JDialog dialog) {
        try {
            Class<?> modalityType = dialog.getClass().getClassLoader().loadClass("java.awt.Dialog$ModalityType");
            Field field = modalityType.getField("TOOLKIT_MODAL");
            Object value = field.get(null);
            Method method = dialog.getClass().getMethod("setModalityType", modalityType);
            method.invoke((Object)dialog, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateDialogIcon(JDialog dialog, List<Image> images) {
        try {
            Method method = dialog.getClass().getMethod("setIconImages", List.class);
            method.invoke((Object)dialog, images);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasJdk6Dialogs() {
        try {
            UIUtil.class.getClassLoader().loadClass("java.awt.Dialog$ModalityType");
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static Color getBorderActiveColor() {
        return ACTIVE_COLOR;
    }

    public static Color getBorderInactiveColor() {
        return INACTIVE_COLOR;
    }

    public static Color getBorderSeparatorColor() {
        return SEPARATOR_COLOR;
    }

    public static HTMLEditorKit getHTMLEditorKit() {
        HTMLEditorKit kit = new HTMLEditorKit();
        Font font = UIManager.getFont("Label.font");
        String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : 11;
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule(String.format("body, div, p { font-family: %s; font-size: %s; } p { margin-top: 0; }", family, size));
        kit.setStyleSheet(styleSheet);
        return kit;
    }

    public static void removeScrollBorder(final Component c) {
        new AwtVisitor(c){

            @Override
            public boolean visit(Component component) {
                if (component instanceof JScrollPane && !UIUtil.hasNonPrimitiveParents(c, component)) {
                    JScrollPane scrollPane = (JScrollPane)component;
                    Integer keepBorderSides = (Integer)scrollPane.getClientProperty(KEEP_BORDER_SIDES);
                    if (keepBorderSides != null) {
                        if (scrollPane.getBorder() instanceof LineBorder) {
                            Color color = ((LineBorder)scrollPane.getBorder()).getLineColor();
                            scrollPane.setBorder(new SideBorder(color, keepBorderSides));
                        } else {
                            scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), keepBorderSides));
                        }
                    } else {
                        scrollPane.setBorder(null);
                    }
                }
                return false;
            }
        };
    }

    public static boolean hasNonPrimitiveParents(Component stopParent, Component c) {
        Container eachParent = c.getParent();
        while (eachParent != null && eachParent != stopParent) {
            if (!UIUtil.isPrimitive(eachParent)) {
                return true;
            }
            eachParent = eachParent.getParent();
        }
        return false;
    }

    public static boolean isPrimitive(Component c) {
        return c instanceof JPanel || c instanceof JLayeredPane;
    }

    public static Point getCenterPoint(Dimension container, Dimension child) {
        return UIUtil.getCenterPoint(new Rectangle(new Point(), container), child);
    }

    public static Point getCenterPoint(Rectangle container, Dimension child) {
        Point result = new Point();
        Point containerLocation = container.getLocation();
        Dimension containerSize = container.getSize();
        result.x = containerLocation.x + (containerSize.width / 2 - child.width / 2);
        result.y = containerLocation.y + (containerSize.height / 2 - child.height / 2);
        return result;
    }

    public static String toHtml(String html) {
        return UIUtil.toHtml(html, 0);
    }

    @NonNls
    public static String toHtml(String html, int hPadding) {
        html = CLOSE_TAG_PATTERN.matcher(html).replaceAll("<$1$2></$1>");
        Font font = UIManager.getFont("Label.font");
        String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : 11;
        return "<html><style>body { font-family: " + family + "; font-size: " + size + ";} ul li {list-style-type:circle;}</style>" + UIUtil.addPadding(html, hPadding) + "</html>";
    }

    public static String addPadding(String html, int hPadding) {
        return String.format("<p style=\"margin: 0 %dpx 0 %dpx;\">%s</p>", hPadding, hPadding, html);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.invokeLaterIfNeeded must not be null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.invokeAndWaitIfNeeded must not be null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public static boolean isFocusProxy(@Nullable Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(FOCUS_PROXY_KEY));
    }

    public static void setFocusProxy(JComponent c, boolean isProxy) {
        c.putClientProperty(FOCUS_PROXY_KEY, isProxy ? Boolean.TRUE : null);
    }

    public static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics;
    }

    public static int getSelectedButton(ButtonGroup group) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (group.isSelected(button.getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setSelectedButton(ButtonGroup group, int index) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            group.setSelected(button.getModel(), index == i);
            ++i;
        }
    }

    public static class LeglessTreeUi
    extends BasicTreeUI {
        @Override
        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        @Override
        protected boolean isToggleSelectionEvent(MouseEvent e) {
            return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }
    }
}

