/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.AppVerifier;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.tools.CertInformation;
import net.sourceforge.jnlp.util.JarFile;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.NetscapeCertTypeExtension;

public class JarCertVerifier
implements CertVerifier {
    private static final String META_INF = "META-INF/";
    private static final String SIG_PREFIX = "META-INF/SIG-";
    private static final long SIX_MONTHS = 15552000000L;
    private List<String> verifiedJars = new ArrayList<String>();
    private List<String> unverifiedJars = new ArrayList<String>();
    private Map<CertPath, CertInformation> certs = new HashMap<CertPath, CertInformation>();
    private CertPath currentlyUsed;
    private Map<String, Integer> jarSignableEntries = new HashMap<String, Integer>();
    private AppVerifier appVerifier;

    public JarCertVerifier(AppVerifier verifier) {
        this.appVerifier = verifier;
    }

    public boolean isTriviallySigned() {
        return JarCertVerifier.getTotalJarEntries(this.jarSignableEntries) <= 0 && this.certs.size() <= 0;
    }

    @Override
    public boolean getAlreadyTrustPublisher() {
        boolean allPublishersTrusted = this.appVerifier.hasAlreadyTrustedPublisher(this.certs, this.jarSignableEntries);
        if (JNLPRuntime.isDebug()) {
            System.out.println("App already has trusted publisher: " + allPublishersTrusted);
        }
        return allPublishersTrusted;
    }

    @Override
    public boolean getRootInCacerts() {
        boolean allRootCAsTrusted = this.appVerifier.hasRootInCacerts(this.certs, this.jarSignableEntries);
        if (JNLPRuntime.isDebug()) {
            System.out.println("App has trusted root CA: " + allRootCAsTrusted);
        }
        return allRootCAsTrusted;
    }

    @Override
    public CertPath getCertPath(CertPath cPath) {
        return this.currentlyUsed;
    }

    @Override
    public boolean hasSigningIssues(CertPath certPath) {
        return this.certs.get(certPath).hasSigningIssues();
    }

    @Override
    public List<String> getDetails(CertPath certPath) {
        if (certPath != null) {
            this.currentlyUsed = certPath;
        }
        return this.certs.get(this.currentlyUsed).getDetailsAsStrings();
    }

    public List<CertPath> getCertsList() {
        return new ArrayList<CertPath>(this.certs.keySet());
    }

    public CertInformation getCertInformation(CertPath cPath) {
        return this.certs.get(cPath);
    }

    public boolean isFullySigned() {
        if (this.isTriviallySigned()) {
            return true;
        }
        boolean fullySigned = this.appVerifier.isFullySigned(this.certs, this.jarSignableEntries);
        if (JNLPRuntime.isDebug()) {
            System.out.println("App already has trusted publisher: " + fullySigned);
        }
        return fullySigned;
    }

    public void add(List<JARDesc> jars, ResourceTracker tracker) throws Exception {
        this.verifyJars(jars, tracker);
    }

    private void verifyJars(List<JARDesc> jars, ResourceTracker tracker) throws Exception {
        for (JARDesc jar : jars) {
            String localFile;
            File jarFile = tracker.getCacheFile(jar.getLocation());
            if (jarFile == null || this.verifiedJars.contains(localFile = jarFile.getAbsolutePath()) || this.unverifiedJars.contains(localFile)) continue;
            VerifyResult result = this.verifyJar(localFile);
            if (result == VerifyResult.UNSIGNED) {
                this.unverifiedJars.add(localFile);
                continue;
            }
            if (result == VerifyResult.SIGNED_NOT_OK) {
                this.verifiedJars.add(localFile);
                continue;
            }
            if (result != VerifyResult.SIGNED_OK) continue;
            this.verifiedJars.add(localFile);
        }
        for (CertPath certPath : this.certs.keySet()) {
            this.checkTrustedCerts(certPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerifyResult verifyJar(String jarName) throws Exception {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarName, true);
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                entriesVec.addElement(je);
                InputStream is = jarFile.getInputStream(je);
                try {
                    while (is.read(buffer, 0, buffer.length) != -1) {
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            VerifyResult verifyResult = this.verifyJarEntryCerts(jarName, jarFile.getManifest() != null, entriesVec);
            return verifyResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    VerifyResult verifyJarEntryCerts(String jarName, boolean jarHasManifest, Vector<JarEntry> entries) throws Exception {
        HashMap<CertPath, Integer> jarSignCount = new HashMap<CertPath, Integer>();
        int numSignableEntriesInJar = 0;
        long now = System.currentTimeMillis();
        if (jarHasManifest) {
            for (JarEntry je : entries) {
                boolean shouldHaveSignature;
                String name = je.getName();
                CodeSigner[] signers = je.getCodeSigners();
                boolean isSigned = signers != null;
                boolean bl = shouldHaveSignature = !je.isDirectory() && !JarCertVerifier.isMetaInfFile(name);
                if (shouldHaveSignature) {
                    ++numSignableEntriesInJar;
                }
                if (!shouldHaveSignature || !isSigned) continue;
                for (int i = 0; i < signers.length; ++i) {
                    CertPath certPath = signers[i].getSignerCertPath();
                    if (!jarSignCount.containsKey(certPath)) {
                        jarSignCount.put(certPath, 1);
                        continue;
                    }
                    jarSignCount.put(certPath, (Integer)jarSignCount.get(certPath) + 1);
                }
            }
        } else {
            ++numSignableEntriesInJar;
        }
        this.jarSignableEntries.put(jarName, numSignableEntriesInJar);
        boolean allEntriesSignedBySingleCert = false;
        for (CertPath certPath : jarSignCount.keySet()) {
            if ((Integer)jarSignCount.get(certPath) != numSignableEntriesInJar) continue;
            allEntriesSignedBySingleCert = true;
            boolean wasPreviouslyVerified = this.certs.containsKey(certPath);
            if (!wasPreviouslyVerified) {
                this.certs.put(certPath, new CertInformation());
            }
            CertInformation certInfo = this.certs.get(certPath);
            if (wasPreviouslyVerified) {
                certInfo.resetForReverification();
            }
            certInfo.setNumJarEntriesSigned(jarName, numSignableEntriesInJar);
            Certificate cert = certPath.getCertificates().get(0);
            if (!(cert instanceof X509Certificate)) continue;
            this.checkCertUsage(certPath, (X509Certificate)cert, null);
            long notBefore = ((X509Certificate)cert).getNotBefore().getTime();
            long notAfter = ((X509Certificate)cert).getNotAfter().getTime();
            if (now < notBefore) {
                certInfo.setNotYetValidCert();
            }
            if (notAfter < now) {
                certInfo.setHasExpiredCert();
                continue;
            }
            if (notAfter >= now + 15552000000L) continue;
            certInfo.setHasExpiringCert();
        }
        VerifyResult result = null;
        if (numSignableEntriesInJar == 0) {
            result = VerifyResult.SIGNED_OK;
        } else if (allEntriesSignedBySingleCert) {
            for (CertPath entryCertPath : jarSignCount.keySet()) {
                if (!this.certs.containsKey(entryCertPath) || this.hasSigningIssues(entryCertPath)) continue;
                result = VerifyResult.SIGNED_OK;
                break;
            }
            if (result == null) {
                result = VerifyResult.SIGNED_NOT_OK;
            }
        } else {
            result = VerifyResult.UNSIGNED;
        }
        if (JNLPRuntime.isDebug()) {
            System.out.println("Jar found at " + jarName + "has been verified as " + (Object)((Object)result));
        }
        return result;
    }

    private void checkTrustedCerts(CertPath certPath) throws Exception {
        CertInformation info = this.certs.get(certPath);
        try {
            X509Certificate publisher = (X509Certificate)this.getPublisher(certPath);
            KeyStore[] certKeyStores = KeyStores.getCertKeyStores();
            if (CertificateUtils.inKeyStores(publisher, certKeyStores)) {
                info.setAlreadyTrustPublisher();
            }
            KeyStore[] caKeyStores = KeyStores.getCAKeyStores();
            for (Certificate certificate : certPath.getCertificates()) {
                if (!CertificateUtils.inKeyStores((X509Certificate)certificate, caKeyStores)) continue;
                info.setRootInCacerts();
                return;
            }
        }
        catch (Exception e) {
            if (JNLPRuntime.isDebug()) {
                System.out.println("WARNING: Unable to read through cert store files.");
            }
            throw e;
        }
        info.setUntrusted();
    }

    public void setCurrentlyUsedCertPath(CertPath cPath) {
        this.currentlyUsed = cPath;
    }

    @Override
    public Certificate getPublisher(CertPath cPath) {
        if (cPath != null) {
            this.currentlyUsed = cPath;
        }
        if (this.currentlyUsed != null) {
            List<? extends Certificate> certList = this.currentlyUsed.getCertificates();
            if (certList.size() > 0) {
                return certList.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public Certificate getRoot(CertPath cPath) {
        if (cPath != null) {
            this.currentlyUsed = cPath;
        }
        if (this.currentlyUsed != null) {
            List<? extends Certificate> certList = this.currentlyUsed.getCertificates();
            if (certList.size() > 0) {
                return certList.get(certList.size() - 1);
            }
            return null;
        }
        return null;
    }

    static boolean isMetaInfFile(String name) {
        String ucName = name.toUpperCase();
        return ucName.startsWith(META_INF);
    }

    void checkCertUsage(CertPath certPath, X509Certificate userCert, boolean[] bad) {
        boolean[] keyUsage;
        if (bad != null) {
            bad[2] = false;
            bad[1] = false;
            bad[0] = false;
        }
        if (!((keyUsage = userCert.getKeyUsage()) == null || keyUsage.length >= 1 && keyUsage[0])) {
            if (bad != null) {
                bad[0] = true;
            } else {
                this.certs.get(certPath).setBadKeyUsage();
            }
        }
        try {
            List<String> xKeyUsage = userCert.getExtendedKeyUsage();
            if (xKeyUsage != null && !xKeyUsage.contains("2.5.29.37.0") && !xKeyUsage.contains("1.3.6.1.5.5.7.3.3")) {
                if (bad != null) {
                    bad[1] = true;
                } else {
                    this.certs.get(certPath).setBadExtendedKeyUsage();
                }
            }
        }
        catch (CertificateParsingException e) {
            // empty catch block
        }
        try {
            byte[] netscapeEx = userCert.getExtensionValue("2.16.840.1.113730.1.1");
            if (netscapeEx != null) {
                DerInputStream in = new DerInputStream(netscapeEx);
                byte[] encoded = in.getOctetString();
                NetscapeCertTypeExtension extn = new NetscapeCertTypeExtension(encoded = new DerValue(encoded).getUnalignedBitString().toByteArray());
                Boolean val = (Boolean)extn.get("object_signing");
                if (!val.booleanValue()) {
                    if (bad != null) {
                        bad[2] = true;
                    } else {
                        this.certs.get(certPath).setBadNetscapeCertType();
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public boolean allJarsSigned() {
        return this.unverifiedJars.size() == 0;
    }

    public void checkTrustWithUser(JNLPFile file) throws LaunchException {
        this.appVerifier.checkTrustWithUser(this, file);
    }

    public Map<String, Integer> getJarSignableEntries() {
        return Collections.unmodifiableMap(this.jarSignableEntries);
    }

    public static int getTotalJarEntries(Map<String, Integer> map) {
        int sum = 0;
        for (int value : map.values()) {
            sum += value;
        }
        return sum;
    }

    static enum VerifyResult {
        UNSIGNED,
        SIGNED_OK,
        SIGNED_NOT_OK;

    }
}

